/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.relaxng;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.ConcreteType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.DataTypeWithFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.EnumerationFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.FinalComponent;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.FractionDigitsFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.LengthFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.ListType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.MaxLengthFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.MinLengthFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.PatternFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.RangeFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.TokenType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.TotalDigitsFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.UnionType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.WhiteSpaceFacet;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatypeImpl;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.BinaryExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ConcurExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.DataExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionVisitorVoid;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.InterleaveExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ListExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.MixedExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OneOrMoreExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OtherExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SequenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ValueExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.EmptyStringType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.relax.NoneType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.XMLWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.writer.relaxng.Context;
import java.util.HashSet;
import java.util.Vector;

public abstract class PatternWriter
implements ExpressionVisitorVoid {
    protected final XMLWriter writer;
    protected final Context context;

    public PatternWriter(Context context) {
        this.writer = context.getWriter();
        this.context = context;
    }

    public abstract void onOther(OtherExp var1);

    public abstract void onRef(ReferenceExp var1);

    public void onElement(ElementExp elementExp) {
        this.writer.start("element");
        this.context.writeNameClass(elementExp.getNameClass());
        this.visitUnary(elementExp.contentModel);
        this.writer.end("element");
    }

    public void onEpsilon() {
        this.writer.element("empty");
    }

    public void onNullSet() {
        this.writer.element("notAllowed");
    }

    public void onAnyString() {
        this.writer.element("text");
    }

    public void onInterleave(InterleaveExp interleaveExp) {
        this.visitBinExp("interleave", interleaveExp, InterleaveExp.class);
    }

    public void onConcur(ConcurExp concurExp) {
        throw new IllegalArgumentException("the grammar includes concur, which is not supported");
    }

    public void onList(ListExp listExp) {
        this.writer.start("list");
        this.visitUnary(listExp.exp);
        this.writer.end("list");
    }

    protected void onOptional(Expression expression) {
        if (expression instanceof OneOrMoreExp) {
            this.onZeroOrMore((OneOrMoreExp)expression);
            return;
        }
        this.writer.start("optional");
        this.visitUnary(expression);
        this.writer.end("optional");
    }

    public void onChoice(ChoiceExp choiceExp) {
        if (choiceExp.exp1 == Expression.epsilon) {
            this.onOptional(choiceExp.exp2);
            return;
        }
        if (choiceExp.exp2 == Expression.epsilon) {
            this.onOptional(choiceExp.exp1);
            return;
        }
        this.visitBinExp("choice", choiceExp, ChoiceExp.class);
    }

    public void onSequence(SequenceExp sequenceExp) {
        this.visitBinExp("group", sequenceExp, SequenceExp.class);
    }

    public void visitBinExp(String string, BinaryExp binaryExp, Class clazz) {
        this.writer.start(string);
        Expression[] expressionArray = binaryExp.getChildren();
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            expressionArray[i2].visit(this);
        }
        this.writer.end(string);
    }

    public void onMixed(MixedExp mixedExp) {
        this.writer.start("mixed");
        this.visitUnary(mixedExp.exp);
        this.writer.end("mixed");
    }

    public void onOneOrMore(OneOrMoreExp oneOrMoreExp) {
        this.writer.start("oneOrMore");
        this.visitUnary(oneOrMoreExp.exp);
        this.writer.end("oneOrMore");
    }

    protected void onZeroOrMore(OneOrMoreExp oneOrMoreExp) {
        this.writer.start("zeroOrMore");
        this.visitUnary(oneOrMoreExp.exp);
        this.writer.end("zeroOrMore");
    }

    public void onAttribute(AttributeExp attributeExp) {
        this.writer.start("attribute");
        this.context.writeNameClass(attributeExp.nameClass);
        this.visitUnary(attributeExp.exp);
        this.writer.end("attribute");
    }

    public void visitUnary(Expression expression) {
        if (expression instanceof SequenceExp) {
            SequenceExp sequenceExp = (SequenceExp)expression;
            this.visitUnary(sequenceExp.exp1);
            sequenceExp.exp2.visit(this);
        } else {
            expression.visit(this);
        }
    }

    public void onValue(ValueExp valueExp) {
        if (valueExp.dt instanceof XSDatatypeImpl) {
            XSDatatypeImpl xSDatatypeImpl = (XSDatatypeImpl)valueExp.dt;
            final Vector<String> vector = new Vector<String>();
            String string = xSDatatypeImpl.convertToLexicalValue(valueExp.value, new SerializationContext(){

                public String getNamespacePrefix(String string) {
                    int n2 = vector.size() / 2;
                    vector.add("xmlns:ns" + n2);
                    vector.add(string);
                    return "ns" + n2;
                }
            });
            if (xSDatatypeImpl != TokenType.theInstance) {
                vector.add("type");
                vector.add(xSDatatypeImpl.getName());
            }
            this.writer.start("value", vector.toArray(new String[0]));
            this.writer.characters(string);
            this.writer.end("value");
            return;
        }
        throw new UnsupportedOperationException(valueExp.dt.getClass().getName());
    }

    public void onData(DataExp dataExp) {
        Datatype datatype = dataExp.dt;
        if (datatype instanceof XSDatatypeImpl) {
            XSDatatypeImpl xSDatatypeImpl = (XSDatatypeImpl)datatype;
            if (this.isPredefinedType(datatype)) {
                this.writer.element("data", new String[]{"type", xSDatatypeImpl.getName()});
            } else {
                this.serializeDataType(xSDatatypeImpl);
            }
            return;
        }
        this.writer.element("data-unknown", new String[]{"class", datatype.getClass().getName()});
    }

    protected void serializeDataType(XSDatatype xSDatatype) {
        if (xSDatatype instanceof UnionType) {
            this.serializeUnionType((UnionType)xSDatatype);
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Vector<XSDatatype> vector = new Vector<XSDatatype>();
        XSDatatype xSDatatype2 = xSDatatype;
        while (xSDatatype2 instanceof DataTypeWithFacet || xSDatatype2 instanceof FinalComponent) {
            if (xSDatatype2 instanceof FinalComponent) {
                xSDatatype2 = xSDatatype2.getBaseType();
                continue;
            }
            String string = ((DataTypeWithFacet)xSDatatype2).facetName;
            if (string.equals("enumeration")) {
                this.serializeEnumeration((XSDatatypeImpl)xSDatatype, (EnumerationFacet)xSDatatype2);
                return;
            }
            if (string.equals("whiteSpace")) {
                System.err.println("warning: unsupported whiteSpace facet is ignored");
                xSDatatype2 = xSDatatype2.getBaseType();
                continue;
            }
            if (!hashSet.contains(string)) {
                hashSet.add(string);
                vector.add(xSDatatype2);
            }
            xSDatatype2 = ((DataTypeWithFacet)xSDatatype2).baseType;
        }
        if (xSDatatype2 instanceof ListType) {
            this.serializeListType((XSDatatypeImpl)xSDatatype);
            return;
        }
        if (!(xSDatatype2 instanceof ConcreteType)) {
            throw new Error(xSDatatype2.getClass().getName());
        }
        if (xSDatatype2 instanceof EmptyStringType) {
            this.writer.element("value");
            return;
        }
        if (xSDatatype2 instanceof NoneType) {
            this.writer.element("notAllowed");
            return;
        }
        this.writer.start("data", new String[]{"type", xSDatatype2.getName()});
        for (int i2 = vector.size() - 1; i2 >= 0; --i2) {
            DataTypeWithFacet dataTypeWithFacet = (DataTypeWithFacet)vector.get(i2);
            if (dataTypeWithFacet instanceof LengthFacet) {
                this.param("length", Long.toString(((LengthFacet)dataTypeWithFacet).length));
                continue;
            }
            if (dataTypeWithFacet instanceof MinLengthFacet) {
                this.param("minLength", Long.toString(((MinLengthFacet)dataTypeWithFacet).minLength));
                continue;
            }
            if (dataTypeWithFacet instanceof MaxLengthFacet) {
                this.param("maxLength", Long.toString(((MaxLengthFacet)dataTypeWithFacet).maxLength));
                continue;
            }
            if (dataTypeWithFacet instanceof PatternFacet) {
                String string = "";
                PatternFacet patternFacet = (PatternFacet)dataTypeWithFacet;
                for (int i3 = 0; i3 < patternFacet.getRegExps().length; ++i3) {
                    if (string.length() != 0) {
                        string = string + "|";
                    }
                    string = string + patternFacet.patterns[i3];
                }
                this.param("pattern", string);
                continue;
            }
            if (dataTypeWithFacet instanceof TotalDigitsFacet) {
                this.param("totalDigits", Long.toString(((TotalDigitsFacet)dataTypeWithFacet).precision));
                continue;
            }
            if (dataTypeWithFacet instanceof FractionDigitsFacet) {
                this.param("fractionDigits", Long.toString(((FractionDigitsFacet)dataTypeWithFacet).scale));
                continue;
            }
            if (dataTypeWithFacet instanceof RangeFacet) {
                this.param(dataTypeWithFacet.facetName, dataTypeWithFacet.convertToLexicalValue(((RangeFacet)dataTypeWithFacet).limitValue, null));
                continue;
            }
            if (dataTypeWithFacet instanceof WhiteSpaceFacet) continue;
            throw new Error();
        }
        this.writer.end("data");
    }

    protected void param(String string, String string2) {
        this.writer.start("param", new String[]{"name", string});
        this.writer.characters(string2);
        this.writer.end("param");
    }

    protected boolean isPredefinedType(Datatype datatype) {
        return !(datatype instanceof DataTypeWithFacet) && !(datatype instanceof UnionType) && !(datatype instanceof ListType) && !(datatype instanceof FinalComponent) && !(datatype instanceof EmptyStringType) && !(datatype instanceof NoneType);
    }

    protected void serializeUnionType(UnionType unionType) {
        this.writer.start("choice");
        for (int i2 = 0; i2 < unionType.memberTypes.length; ++i2) {
            this.serializeDataType(unionType.memberTypes[i2]);
        }
        this.writer.end("choice");
    }

    protected void serializeListType(XSDatatypeImpl xSDatatypeImpl) {
        ListType listType = (ListType)xSDatatypeImpl.getConcreteType();
        if (xSDatatypeImpl.getFacetObject("length") != null) {
            int n2 = ((LengthFacet)xSDatatypeImpl.getFacetObject((String)"length")).length;
            this.writer.start("list");
            for (int i2 = 0; i2 < n2; ++i2) {
                this.serializeDataType(listType.itemType);
            }
            this.writer.end("list");
            return;
        }
        if (xSDatatypeImpl.getFacetObject("maxLength") != null) {
            throw new UnsupportedOperationException("warning: maxLength facet to list type is not properly converted.");
        }
        MinLengthFacet minLengthFacet = (MinLengthFacet)xSDatatypeImpl.getFacetObject("minLength");
        this.writer.start("list");
        if (minLengthFacet != null) {
            for (int i3 = 0; i3 < minLengthFacet.minLength; ++i3) {
                this.serializeDataType(listType.itemType);
            }
        }
        this.writer.start("zeroOrMore");
        this.serializeDataType(listType.itemType);
        this.writer.end("zeroOrMore");
        this.writer.end("list");
    }

    protected void serializeEnumeration(XSDatatypeImpl xSDatatypeImpl, EnumerationFacet enumerationFacet) {
        Object[] objectArray = enumerationFacet.values.toArray();
        if (objectArray.length > 1) {
            this.writer.start("choice");
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            final Vector<String> vector = new Vector<String>();
            String string = xSDatatypeImpl.convertToLexicalValue(objectArray[i2], new SerializationContext(){

                public String getNamespacePrefix(String string) {
                    int n2 = vector.size() / 2;
                    vector.add("xmlns:ns" + n2);
                    vector.add(string);
                    return "ns" + n2;
                }
            });
            boolean bl2 = xSDatatypeImpl.isValid(string, new ValidationContext(){

                public String resolveNamespacePrefix(String string) {
                    if (!string.startsWith("ns")) {
                        return null;
                    }
                    int n2 = Integer.parseInt(string.substring(2));
                    return (String)vector.get(n2 * 2 + 1);
                }

                public boolean isUnparsedEntity(String string) {
                    return true;
                }

                public boolean isNotation(String string) {
                    return true;
                }

                public String getBaseUri() {
                    return null;
                }
            });
            vector.add("type");
            vector.add(xSDatatypeImpl.getConcreteType().getName());
            if (!bl2) continue;
            this.writer.start("value", vector.toArray(new String[0]));
            this.writer.characters(string);
            this.writer.end("value");
        }
        if (objectArray.length > 1) {
            this.writer.end("choice");
        }
    }
}

