/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTDecodeException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.HeaderDeserializer;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.PayloadDeserializer;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Header;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Payload;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectReader;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class JWTParser {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = JWTParser.createDefaultObjectMapper();
    private static final ObjectReader DEFAULT_PAYLOAD_READER = DEFAULT_OBJECT_MAPPER.readerFor(Payload.class);
    private static final ObjectReader DEFAULT_HEADER_READER = DEFAULT_OBJECT_MAPPER.readerFor(Header.class);
    private final ObjectReader payloadReader = DEFAULT_PAYLOAD_READER;
    private final ObjectReader headerReader = DEFAULT_HEADER_READER;

    public Payload parsePayload(String string) throws JWTDecodeException {
        if (string == null) {
            throw JWTParser.decodeException();
        }
        try {
            return (Payload)this.payloadReader.readValue(string);
        }
        catch (IOException iOException) {
            throw JWTParser.decodeException(string);
        }
    }

    public Header parseHeader(String string) throws JWTDecodeException {
        if (string == null) {
            throw JWTParser.decodeException();
        }
        try {
            return (Header)this.headerReader.readValue(string);
        }
        catch (IOException iOException) {
            throw JWTParser.decodeException(string);
        }
    }

    static void addDeserializers(ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(Payload.class, new PayloadDeserializer());
        simpleModule.addDeserializer(Header.class, new HeaderDeserializer());
        objectMapper.registerModule(simpleModule);
    }

    private static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        JWTParser.addDeserializers(objectMapper);
        return objectMapper;
    }

    private static JWTDecodeException decodeException() {
        return JWTParser.decodeException(null);
    }

    private static JWTDecodeException decodeException(String string) {
        return new JWTDecodeException(String.format("The string '%s' doesn't have a valid JSON format.", string));
    }
}

