/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.hash.PrimitiveHasher;

public final class HashingOutputStream
extends FilterOutputStream {
    private final PrimitiveHasher hasher;

    public HashingOutputStream(HashFunction hashFunction, OutputStream outputStream) {
        super(Preconditions.checkNotNull(outputStream));
        this.hasher = Preconditions.checkNotNull(hashFunction.newPrimitiveHasher());
    }

    @Override
    public void write(int n2) throws IOException {
        this.hasher.putByte((byte)n2);
        this.out.write(n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.hasher.putBytes(byArray, n2, n3);
        this.out.write(byArray, n2, n3);
    }

    public HashCode hash() {
        return this.hasher.hash();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

