/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.util;

import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ConcurrentReferenceHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ReflectionUtils {
    public static final MethodFilter USER_DECLARED_METHODS = method -> !method.isBridge() && !method.isSynthetic() && method.getDeclaringClass() != Object.class;
    public static final FieldFilter COPYABLE_FIELDS = field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Map<Class<?>, Method[]> declaredMethodsCache = new ConcurrentReferenceHashMap(256);
    private static final Map<Class<?>, Field[]> declaredFieldsCache = new ConcurrentReferenceHashMap(256);

    public static void handleReflectionException(Exception exception) {
        if (exception instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + exception.getMessage());
        }
        if (exception instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method or field: " + exception.getMessage());
        }
        if (exception instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new UndeclaredThrowableException(exception);
    }

    public static void handleInvocationTargetException(InvocationTargetException invocationTargetException) {
        ReflectionUtils.rethrowRuntimeException(invocationTargetException.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new UndeclaredThrowableException(throwable);
    }

    public static <T> Constructor<T> accessibleConstructor(Class<T> clazz, Class<?> ... classArray) throws NoSuchMethodException {
        Constructor<T> constructor = clazz.getDeclaredConstructor(classArray);
        ReflectionUtils.makeAccessible(constructor);
        return constructor;
    }

    public static void makeAccessible(Constructor<?> constructor) {
        if (!(Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers()) || constructor.isAccessible())) {
            constructor.setAccessible(true);
        }
    }

    public static Object invokeMethod(Method method, Object object) {
        return ReflectionUtils.invokeMethod(method, object, EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeMethod(Method method, Object object, Object ... objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            ReflectionUtils.handleReflectionException(exception);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback methodCallback, MethodFilter methodFilter) {
        if (methodFilter == USER_DECLARED_METHODS && clazz == Object.class) {
            return;
        }
        Method[] methodArray = ReflectionUtils.getDeclaredMethods(clazz, false);
        for (Method genericDeclaration : methodArray) {
            if (methodFilter != null && !methodFilter.matches(genericDeclaration)) continue;
            try {
                methodCallback.doWith(genericDeclaration);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("Not allowed to access method '" + genericDeclaration.getName() + "': " + illegalAccessException);
            }
        }
        if (clazz.getSuperclass() != null && (methodFilter != USER_DECLARED_METHODS || clazz.getSuperclass() != Object.class)) {
            ReflectionUtils.doWithMethods(clazz.getSuperclass(), methodCallback, methodFilter);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectionUtils.doWithMethods(genericDeclaration, methodCallback, methodFilter);
            }
        }
    }

    private static Method[] getDeclaredMethods(Class<?> clazz, boolean bl2) {
        Assert.notNull(clazz, "Class must not be null");
        Method[] methodArray = declaredMethodsCache.get(clazz);
        if (methodArray == null) {
            try {
                Method[] methodArray2 = clazz.getDeclaredMethods();
                List<Method> list = ReflectionUtils.findConcreteMethodsOnInterfaces(clazz);
                if (list != null) {
                    methodArray = new Method[methodArray2.length + list.size()];
                    System.arraycopy(methodArray2, 0, methodArray, 0, methodArray2.length);
                    int n2 = methodArray2.length;
                    Iterator<Method> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Method method;
                        methodArray[n2] = method = iterator.next();
                        ++n2;
                    }
                } else {
                    methodArray = methodArray2;
                }
                declaredMethodsCache.put(clazz, methodArray.length == 0 ? EMPTY_METHOD_ARRAY : methodArray);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", throwable);
            }
        }
        return methodArray.length == 0 || !bl2 ? methodArray : (Method[])methodArray.clone();
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> arrayList = null;
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            for (Method method : clazz2.getMethods()) {
                if (Modifier.isAbstract(method.getModifiers())) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Method>();
                }
                arrayList.add(method);
            }
        }
        return arrayList;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static Field findField(Class<?> clazz, String string) {
        return ReflectionUtils.findField(clazz, string, null);
    }

    public static Field findField(Class<?> clazz, String string, Class<?> clazz2) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.isTrue(string != null || clazz2 != null, "Either name or type of the field must be specified");
        for (Class<?> clazz3 = clazz; Object.class != clazz3 && clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            Field[] fieldArray;
            for (Field field : fieldArray = ReflectionUtils.getDeclaredFields(clazz3)) {
                if (string != null && !string.equals(field.getName()) || clazz2 != null && !clazz2.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        Field[] fieldArray = declaredFieldsCache.get(clazz);
        if (fieldArray == null) {
            try {
                fieldArray = clazz.getDeclaredFields();
                declaredFieldsCache.put(clazz, fieldArray.length == 0 ? EMPTY_FIELD_ARRAY : fieldArray);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", throwable);
            }
        }
        return fieldArray;
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    @FunctionalInterface
    public static interface FieldFilter {
    }

    @FunctionalInterface
    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    @FunctionalInterface
    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

