/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.MethodParameter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.Property;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.AccessException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.PropertyAccessor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CompilablePropertyAccessor;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.StringUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectivePropertyAccessor
implements PropertyAccessor {
    private static final Set<Class<?>> ANY_TYPES = Collections.emptySet();
    private static final Set<Class<?>> BOOLEAN_TYPES;
    private final boolean allowWrite;
    private final Map<PropertyCacheKey, InvokerPair> readerCache = new ConcurrentHashMap<PropertyCacheKey, InvokerPair>(64);
    private final Map<PropertyCacheKey, Member> writerCache = new ConcurrentHashMap<PropertyCacheKey, Member>(64);
    private final Map<PropertyCacheKey, TypeDescriptor> typeDescriptorCache = new ConcurrentHashMap<PropertyCacheKey, TypeDescriptor>(64);
    private final Map<Class<?>, Method[]> sortedMethodsCache = new ConcurrentHashMap(64);
    private volatile InvokerPair lastReadInvokerPair;

    public ReflectivePropertyAccessor() {
        this.allowWrite = true;
    }

    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return null;
    }

    @Override
    public boolean canRead(EvaluationContext evaluationContext, Object object, String string) throws AccessException {
        Class<?> clazz;
        if (object == null) {
            return false;
        }
        Class<?> clazz2 = clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        if (clazz.isArray() && string.equals("length")) {
            return true;
        }
        PropertyCacheKey propertyCacheKey = new PropertyCacheKey(clazz, string, object instanceof Class);
        if (this.readerCache.containsKey(propertyCacheKey)) {
            return true;
        }
        Method method = this.findGetterForProperty(string, clazz, object);
        if (method != null) {
            Property property = new Property(clazz, method, null);
            TypeDescriptor typeDescriptor = new TypeDescriptor(property);
            method = ClassUtils.getInterfaceMethodIfPossible(method, clazz);
            this.readerCache.put(propertyCacheKey, new InvokerPair(method, typeDescriptor));
            this.typeDescriptorCache.put(propertyCacheKey, typeDescriptor);
            return true;
        }
        Field field = this.findField(string, clazz, object);
        if (field != null) {
            TypeDescriptor typeDescriptor = new TypeDescriptor(field);
            this.readerCache.put(propertyCacheKey, new InvokerPair(field, typeDescriptor));
            this.typeDescriptorCache.put(propertyCacheKey, typeDescriptor);
            return true;
        }
        return false;
    }

    @Override
    public TypedValue read(EvaluationContext evaluationContext, Object object, String string) throws AccessException {
        Object object2;
        AccessibleObject accessibleObject;
        InvokerPair invokerPair;
        Class<?> clazz;
        Assert.state(object != null, "Target must not be null");
        Class<?> clazz2 = clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        if (clazz.isArray() && string.equals("length")) {
            if (object instanceof Class) {
                throw new AccessException("Cannot access length on array class itself");
            }
            return new TypedValue(Array.getLength(object));
        }
        PropertyCacheKey propertyCacheKey = new PropertyCacheKey(clazz, string, object instanceof Class);
        this.lastReadInvokerPair = invokerPair = this.readerCache.get(propertyCacheKey);
        if (invokerPair == null || invokerPair.member instanceof Method) {
            accessibleObject = (Method)(invokerPair != null ? invokerPair.member : null);
            if (accessibleObject == null && (accessibleObject = this.findGetterForProperty(string, clazz, object)) != null) {
                object2 = new Property(clazz, (Method)accessibleObject, null);
                TypeDescriptor typeDescriptor = new TypeDescriptor((Property)object2);
                accessibleObject = ClassUtils.getInterfaceMethodIfPossible((Method)accessibleObject, clazz);
                this.lastReadInvokerPair = invokerPair = new InvokerPair((Member)((Object)accessibleObject), typeDescriptor);
                this.readerCache.put(propertyCacheKey, invokerPair);
            }
            if (accessibleObject != null) {
                try {
                    ReflectionUtils.makeAccessible((Method)accessibleObject);
                    object2 = ((Method)accessibleObject).invoke(object, new Object[0]);
                    return new TypedValue(object2, invokerPair.typeDescriptor.narrow(object2));
                }
                catch (Exception exception) {
                    throw new AccessException("Unable to access property '" + string + "' through getter method", exception);
                }
            }
        }
        if (invokerPair == null || invokerPair.member instanceof Field) {
            accessibleObject = (Field)(invokerPair == null ? null : invokerPair.member);
            if (accessibleObject == null && (accessibleObject = this.findField(string, clazz, object)) != null) {
                this.lastReadInvokerPair = invokerPair = new InvokerPair((Member)((Object)accessibleObject), new TypeDescriptor((Field)accessibleObject));
                this.readerCache.put(propertyCacheKey, invokerPair);
            }
            if (accessibleObject != null) {
                try {
                    ReflectionUtils.makeAccessible((Field)accessibleObject);
                    object2 = ((Field)accessibleObject).get(object);
                    return new TypedValue(object2, invokerPair.typeDescriptor.narrow(object2));
                }
                catch (Exception exception) {
                    throw new AccessException("Unable to access field '" + string + "'", exception);
                }
            }
        }
        throw new AccessException("Neither getter method nor field found for property '" + string + "'");
    }

    @Override
    public boolean canWrite(EvaluationContext evaluationContext, Object object, String string) throws AccessException {
        if (!this.allowWrite || object == null) {
            return false;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        PropertyCacheKey propertyCacheKey = new PropertyCacheKey(clazz, string, object instanceof Class);
        if (this.writerCache.containsKey(propertyCacheKey)) {
            return true;
        }
        Method method = this.findSetterForProperty(string, clazz, object);
        if (method != null) {
            Property property = new Property(clazz, null, method);
            TypeDescriptor typeDescriptor = new TypeDescriptor(property);
            method = ClassUtils.getInterfaceMethodIfPossible(method, clazz);
            this.writerCache.put(propertyCacheKey, method);
            this.typeDescriptorCache.put(propertyCacheKey, typeDescriptor);
            return true;
        }
        Field field = this.findField(string, clazz, object);
        if (field != null) {
            this.writerCache.put(propertyCacheKey, field);
            this.typeDescriptorCache.put(propertyCacheKey, new TypeDescriptor(field));
            return true;
        }
        return false;
    }

    @Override
    public void write(EvaluationContext evaluationContext, Object object, String string, Object object2) throws AccessException {
        AccessibleObject accessibleObject;
        PropertyCacheKey propertyCacheKey;
        Member member;
        if (!this.allowWrite) {
            throw new AccessException("PropertyAccessor for property '" + string + "' on target [" + object + "] does not allow write operations");
        }
        Assert.state(object != null, "Target must not be null");
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        Object object3 = object2;
        TypeDescriptor typeDescriptor = this.getTypeDescriptor(evaluationContext, object, string);
        if (typeDescriptor != null) {
            try {
                object3 = evaluationContext.getTypeConverter().convertValue(object2, TypeDescriptor.forObject(object2), typeDescriptor);
            }
            catch (EvaluationException evaluationException) {
                throw new AccessException("Type conversion failure", evaluationException);
            }
        }
        if ((member = this.writerCache.get(propertyCacheKey = new PropertyCacheKey(clazz, string, object instanceof Class))) == null || member instanceof Method) {
            accessibleObject = (Method)member;
            if (accessibleObject == null && (accessibleObject = this.findSetterForProperty(string, clazz, object)) != null) {
                accessibleObject = ClassUtils.getInterfaceMethodIfPossible((Method)accessibleObject, clazz);
                member = accessibleObject;
                this.writerCache.put(propertyCacheKey, member);
            }
            if (accessibleObject != null) {
                try {
                    ReflectionUtils.makeAccessible((Method)accessibleObject);
                    ((Method)accessibleObject).invoke(object, object3);
                    return;
                }
                catch (Exception exception) {
                    throw new AccessException("Unable to access property '" + string + "' through setter method", exception);
                }
            }
        }
        if (member == null || member instanceof Field) {
            accessibleObject = (Field)member;
            if (accessibleObject == null && (accessibleObject = this.findField(string, clazz, object)) != null) {
                member = accessibleObject;
                this.writerCache.put(propertyCacheKey, member);
            }
            if (accessibleObject != null) {
                try {
                    ReflectionUtils.makeAccessible((Field)accessibleObject);
                    ((Field)accessibleObject).set(object, object3);
                    return;
                }
                catch (Exception exception) {
                    throw new AccessException("Unable to access field '" + string + "'", exception);
                }
            }
        }
        throw new AccessException("Neither setter method nor field found for property '" + string + "'");
    }

    private TypeDescriptor getTypeDescriptor(EvaluationContext evaluationContext, Object object, String string) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        if (clazz.isArray() && string.equals("length")) {
            return TypeDescriptor.valueOf(Integer.TYPE);
        }
        PropertyCacheKey propertyCacheKey = new PropertyCacheKey(clazz, string, object instanceof Class);
        TypeDescriptor typeDescriptor = this.typeDescriptorCache.get(propertyCacheKey);
        if (typeDescriptor == null) {
            try {
                if (this.canRead(evaluationContext, object, string) || this.canWrite(evaluationContext, object, string)) {
                    typeDescriptor = this.typeDescriptorCache.get(propertyCacheKey);
                }
            }
            catch (AccessException accessException) {
                // empty catch block
            }
        }
        return typeDescriptor;
    }

    private Method findGetterForProperty(String string, Class<?> clazz, Object object) {
        Method method = this.findGetterForProperty(string, clazz, object instanceof Class);
        if (method == null && object instanceof Class) {
            method = this.findGetterForProperty(string, object.getClass(), false);
        }
        return method;
    }

    private Method findSetterForProperty(String string, Class<?> clazz, Object object) {
        Method method = this.findSetterForProperty(string, clazz, object instanceof Class);
        if (method == null && object instanceof Class) {
            method = this.findSetterForProperty(string, object.getClass(), false);
        }
        return method;
    }

    protected Method findGetterForProperty(String string, Class<?> clazz, boolean bl2) {
        Method method = this.findMethodForProperty(this.getPropertyMethodSuffixes(string), "get", clazz, bl2, 0, ANY_TYPES);
        if (method == null && (method = this.findMethodForProperty(this.getPropertyMethodSuffixes(string), "is", clazz, bl2, 0, BOOLEAN_TYPES)) == null) {
            method = this.findMethodForProperty(new String[]{string}, "", clazz, bl2, 0, ANY_TYPES);
        }
        return method;
    }

    protected Method findSetterForProperty(String string, Class<?> clazz, boolean bl2) {
        return this.findMethodForProperty(this.getPropertyMethodSuffixes(string), "set", clazz, bl2, 1, ANY_TYPES);
    }

    private Method findMethodForProperty(String[] stringArray, String string, Class<?> clazz, boolean bl2, int n2, Set<Class<?>> set) {
        Method[] methodArray = this.getSortedMethods(clazz);
        for (String string2 : stringArray) {
            for (Method method : methodArray) {
                if (!this.isCandidateForProperty(method, clazz) || !method.getName().equals(string + string2) || method.getParameterCount() != n2 || bl2 && !Modifier.isStatic(method.getModifiers()) || !set.isEmpty() && !set.contains(method.getReturnType())) continue;
                return method;
            }
        }
        return null;
    }

    private Method[] getSortedMethods(Class<?> clazz2) {
        return this.sortedMethodsCache.computeIfAbsent(clazz2, clazz -> {
            Method[] methodArray = clazz.getMethods();
            Arrays.sort(methodArray, (method, method2) -> method.isBridge() == method2.isBridge() ? 0 : (method.isBridge() ? 1 : -1));
            return methodArray;
        });
    }

    protected boolean isCandidateForProperty(Method method, Class<?> clazz) {
        return true;
    }

    protected String[] getPropertyMethodSuffixes(String string) {
        String string2 = this.getPropertyMethodSuffix(string);
        if (string2.length() > 0 && Character.isUpperCase(string2.charAt(0))) {
            return new String[]{string2};
        }
        return new String[]{string2, StringUtils.capitalize(string2)};
    }

    protected String getPropertyMethodSuffix(String string) {
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1))) {
            return string;
        }
        return StringUtils.capitalize(string);
    }

    private Field findField(String string, Class<?> clazz, Object object) {
        Field field = this.findField(string, clazz, object instanceof Class);
        if (field == null && object instanceof Class) {
            field = this.findField(string, object.getClass(), false);
        }
        return field;
    }

    protected Field findField(String string, Class<?> clazz, boolean bl2) {
        Field field;
        Field[] fieldArray;
        for (Field field2 : fieldArray = clazz.getFields()) {
            if (!field2.getName().equals(string) || bl2 && !Modifier.isStatic(field2.getModifiers())) continue;
            return field2;
        }
        if (clazz.getSuperclass() != null && (field = this.findField(string, clazz.getSuperclass(), bl2)) != null) {
            return field;
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            Field field3 = this.findField(string, clazz2, bl2);
            if (field3 == null) continue;
            return field3;
        }
        return null;
    }

    public PropertyAccessor createOptimalAccessor(EvaluationContext evaluationContext, Object object, String string) {
        AccessibleObject accessibleObject;
        Class<?> clazz;
        if (object == null) {
            return this;
        }
        Class<?> clazz2 = clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        if (clazz.isArray()) {
            return this;
        }
        PropertyCacheKey propertyCacheKey = new PropertyCacheKey(clazz, string, object instanceof Class);
        InvokerPair invokerPair = this.readerCache.get(propertyCacheKey);
        if (invokerPair == null || invokerPair.member instanceof Method) {
            accessibleObject = (Method)(invokerPair != null ? invokerPair.member : null);
            if (accessibleObject == null && (accessibleObject = this.findGetterForProperty(string, clazz, object)) != null) {
                TypeDescriptor typeDescriptor = new TypeDescriptor(new MethodParameter((Method)accessibleObject, -1));
                accessibleObject = ClassUtils.getInterfaceMethodIfPossible(accessibleObject, clazz);
                invokerPair = new InvokerPair((Member)((Object)accessibleObject), typeDescriptor);
                ReflectionUtils.makeAccessible(accessibleObject);
                this.readerCache.put(propertyCacheKey, invokerPair);
            }
            if (accessibleObject != null) {
                return new OptimalPropertyAccessor(invokerPair);
            }
        }
        if (invokerPair == null || invokerPair.member instanceof Field) {
            AccessibleObject accessibleObject2 = accessibleObject = invokerPair != null ? (Field)invokerPair.member : null;
            if (accessibleObject == null && (accessibleObject = this.findField(string, clazz, object instanceof Class)) != null) {
                invokerPair = new InvokerPair((Member)((Object)accessibleObject), new TypeDescriptor((Field)accessibleObject));
                ReflectionUtils.makeAccessible((Field)accessibleObject);
                this.readerCache.put(propertyCacheKey, invokerPair);
            }
            if (accessibleObject != null) {
                return new OptimalPropertyAccessor(invokerPair);
            }
        }
        return this;
    }

    static {
        HashSet<Class<Boolean>> hashSet = new HashSet<Class<Boolean>>(4);
        hashSet.add(Boolean.class);
        hashSet.add(Boolean.TYPE);
        BOOLEAN_TYPES = Collections.unmodifiableSet(hashSet);
    }

    public static class OptimalPropertyAccessor
    implements CompilablePropertyAccessor {
        public final Member member;
        private final TypeDescriptor typeDescriptor;

        OptimalPropertyAccessor(InvokerPair invokerPair) {
            this.member = invokerPair.member;
            this.typeDescriptor = invokerPair.typeDescriptor;
        }

        @Override
        public Class<?>[] getSpecificTargetClasses() {
            throw new UnsupportedOperationException("Should not be called on an OptimalPropertyAccessor");
        }

        @Override
        public boolean canRead(EvaluationContext evaluationContext, Object object, String string) throws AccessException {
            Class<?> clazz;
            if (object == null) {
                return false;
            }
            Class<?> clazz2 = clazz = object instanceof Class ? (Class<?>)object : object.getClass();
            if (clazz.isArray()) {
                return false;
            }
            if (this.member instanceof Method) {
                Method method = (Method)this.member;
                String string2 = "get" + StringUtils.capitalize(string);
                if (string2.equals(method.getName())) {
                    return true;
                }
                string2 = "is" + StringUtils.capitalize(string);
                if (string2.equals(method.getName())) {
                    return true;
                }
            }
            return this.member.getName().equals(string);
        }

        @Override
        public TypedValue read(EvaluationContext evaluationContext, Object object, String string) throws AccessException {
            if (this.member instanceof Method) {
                Method method = (Method)this.member;
                try {
                    ReflectionUtils.makeAccessible(method);
                    Object object2 = method.invoke(object, new Object[0]);
                    return new TypedValue(object2, this.typeDescriptor.narrow(object2));
                }
                catch (Exception exception) {
                    throw new AccessException("Unable to access property '" + string + "' through getter method", exception);
                }
            }
            Field field = (Field)this.member;
            try {
                ReflectionUtils.makeAccessible(field);
                Object object3 = field.get(object);
                return new TypedValue(object3, this.typeDescriptor.narrow(object3));
            }
            catch (Exception exception) {
                throw new AccessException("Unable to access field '" + string + "'", exception);
            }
        }

        @Override
        public boolean canWrite(EvaluationContext evaluationContext, Object object, String string) {
            throw new UnsupportedOperationException("Should not be called on an OptimalPropertyAccessor");
        }

        @Override
        public void write(EvaluationContext evaluationContext, Object object, String string, Object object2) {
            throw new UnsupportedOperationException("Should not be called on an OptimalPropertyAccessor");
        }

        @Override
        public boolean isCompilable() {
            return Modifier.isPublic(this.member.getModifiers()) && Modifier.isPublic(this.member.getDeclaringClass().getModifiers());
        }

        @Override
        public Class<?> getPropertyType() {
            if (this.member instanceof Method) {
                return ((Method)this.member).getReturnType();
            }
            return ((Field)this.member).getType();
        }

        @Override
        public void generateCode(String string, MethodVisitor methodVisitor, CodeFlow codeFlow) {
            boolean bl2 = Modifier.isStatic(this.member.getModifiers());
            String string2 = codeFlow.lastDescriptor();
            String string3 = this.member.getDeclaringClass().getName().replace('.', '/');
            if (!bl2) {
                if (string2 == null) {
                    codeFlow.loadTarget(methodVisitor);
                }
                if (string2 == null || !string3.equals(string2.substring(1))) {
                    methodVisitor.visitTypeInsn(192, string3);
                }
            } else if (string2 != null) {
                methodVisitor.visitInsn(87);
            }
            if (this.member instanceof Method) {
                Method method = (Method)this.member;
                boolean bl3 = method.getDeclaringClass().isInterface();
                int n2 = bl2 ? 184 : (bl3 ? 185 : 182);
                methodVisitor.visitMethodInsn(n2, string3, method.getName(), CodeFlow.createSignatureDescriptor(method), bl3);
            } else {
                methodVisitor.visitFieldInsn(bl2 ? 178 : 180, string3, this.member.getName(), CodeFlow.toJvmDescriptor(((Field)this.member).getType()));
            }
        }
    }

    private static final class PropertyCacheKey
    implements Comparable<PropertyCacheKey> {
        private final Class<?> clazz;
        private final String property;
        private final boolean targetIsClass;

        public PropertyCacheKey(Class<?> clazz, String string, boolean bl2) {
            this.clazz = clazz;
            this.property = string;
            this.targetIsClass = bl2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PropertyCacheKey)) {
                return false;
            }
            PropertyCacheKey propertyCacheKey = (PropertyCacheKey)object;
            return this.clazz == propertyCacheKey.clazz && this.property.equals(propertyCacheKey.property) && this.targetIsClass == propertyCacheKey.targetIsClass;
        }

        public int hashCode() {
            return this.clazz.hashCode() * 29 + this.property.hashCode();
        }

        public String toString() {
            return "PropertyCacheKey [clazz=" + this.clazz.getName() + ", property=" + this.property + ", targetIsClass=" + this.targetIsClass + "]";
        }

        @Override
        public int compareTo(PropertyCacheKey propertyCacheKey) {
            int n2 = this.clazz.getName().compareTo(propertyCacheKey.clazz.getName());
            if (n2 == 0) {
                n2 = this.property.compareTo(propertyCacheKey.property);
            }
            return n2;
        }
    }

    private static class InvokerPair {
        final Member member;
        final TypeDescriptor typeDescriptor;

        public InvokerPair(Member member, TypeDescriptor typeDescriptor) {
            this.member = member;
            this.typeDescriptor = typeDescriptor;
        }
    }
}

