/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.ParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.ParserContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.common.TemplateAwareExpressionParser;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.InternalParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelParserConfiguration;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Assign;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.BeanReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.BooleanLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.CompoundExpression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.ConstructorReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Elvis;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.FunctionReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Identifier;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Indexer;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.InlineList;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.InlineMap;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Literal;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.MethodReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.NullLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpAnd;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpDec;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpDivide;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpEQ;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpGE;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpGT;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpInc;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpLE;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpLT;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpMinus;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpModulus;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpMultiply;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpNE;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpOr;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OpPlus;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OperatorBetween;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OperatorInstanceof;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OperatorMatches;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OperatorNot;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.OperatorPower;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Projection;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.PropertyOrFieldReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.QualifiedIdentifier;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Selection;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.StringLiteral;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Ternary;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.TypeReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.VariableReference;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.SpelExpression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.Token;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.TokenKind;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.Tokenizer;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.StringUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.regex.Pattern;

class InternalSpelExpressionParser
extends TemplateAwareExpressionParser {
    private static final Pattern VALID_QUALIFIED_ID_PATTERN = Pattern.compile("[\\p{L}\\p{N}_$]+");
    private final SpelParserConfiguration configuration;
    private final Deque<SpelNodeImpl> constructedNodes = new ArrayDeque<SpelNodeImpl>();
    private String expressionString = "";
    private List<Token> tokenStream = Collections.emptyList();
    private int tokenStreamLength;
    private int tokenStreamPointer;

    public InternalSpelExpressionParser(SpelParserConfiguration spelParserConfiguration) {
        this.configuration = spelParserConfiguration;
    }

    @Override
    protected SpelExpression doParseExpression(String string, ParserContext parserContext) throws ParseException {
        try {
            this.expressionString = string;
            Tokenizer tokenizer = new Tokenizer(string);
            this.tokenStream = tokenizer.process();
            this.tokenStreamLength = this.tokenStream.size();
            this.tokenStreamPointer = 0;
            this.constructedNodes.clear();
            SpelNodeImpl spelNodeImpl = this.eatExpression();
            Assert.state(spelNodeImpl != null, "No node");
            Token token = this.peekToken();
            if (token != null) {
                throw new SpelParseException(token.startPos, SpelMessage.MORE_INPUT, this.toString(this.nextToken()));
            }
            Assert.isTrue(this.constructedNodes.isEmpty(), "At least one node expected");
            return new SpelExpression(string, spelNodeImpl, this.configuration);
        }
        catch (InternalParseException internalParseException) {
            throw internalParseException.getCause();
        }
    }

    private SpelNodeImpl eatExpression() {
        SpelNodeImpl spelNodeImpl = this.eatLogicalOrExpression();
        Token token = this.peekToken();
        if (token != null) {
            if (token.kind == TokenKind.ASSIGN) {
                if (spelNodeImpl == null) {
                    spelNodeImpl = new NullLiteral(token.startPos - 1, token.endPos - 1);
                }
                this.nextToken();
                SpelNodeImpl spelNodeImpl2 = this.eatLogicalOrExpression();
                return new Assign(token.startPos, token.endPos, spelNodeImpl, spelNodeImpl2);
            }
            if (token.kind == TokenKind.ELVIS) {
                if (spelNodeImpl == null) {
                    spelNodeImpl = new NullLiteral(token.startPos - 1, token.endPos - 2);
                }
                this.nextToken();
                SpelNodeImpl spelNodeImpl3 = this.eatExpression();
                if (spelNodeImpl3 == null) {
                    spelNodeImpl3 = new NullLiteral(token.startPos + 1, token.endPos + 1);
                }
                return new Elvis(token.startPos, token.endPos, spelNodeImpl, spelNodeImpl3);
            }
            if (token.kind == TokenKind.QMARK) {
                if (spelNodeImpl == null) {
                    spelNodeImpl = new NullLiteral(token.startPos - 1, token.endPos - 1);
                }
                this.nextToken();
                SpelNodeImpl spelNodeImpl4 = this.eatExpression();
                this.eatToken(TokenKind.COLON);
                SpelNodeImpl spelNodeImpl5 = this.eatExpression();
                return new Ternary(token.startPos, token.endPos, spelNodeImpl, spelNodeImpl4, spelNodeImpl5);
            }
        }
        return spelNodeImpl;
    }

    private SpelNodeImpl eatLogicalOrExpression() {
        SpelNodeImpl spelNodeImpl = this.eatLogicalAndExpression();
        while (this.peekIdentifierToken("or") || this.peekToken(TokenKind.SYMBOLIC_OR)) {
            Token token = this.takeToken();
            SpelNodeImpl spelNodeImpl2 = this.eatLogicalAndExpression();
            this.checkOperands(token, spelNodeImpl, spelNodeImpl2);
            spelNodeImpl = new OpOr(token.startPos, token.endPos, spelNodeImpl, spelNodeImpl2);
        }
        return spelNodeImpl;
    }

    private SpelNodeImpl eatLogicalAndExpression() {
        SpelNodeImpl spelNodeImpl = this.eatRelationalExpression();
        while (this.peekIdentifierToken("and") || this.peekToken(TokenKind.SYMBOLIC_AND)) {
            Token token = this.takeToken();
            SpelNodeImpl spelNodeImpl2 = this.eatRelationalExpression();
            this.checkOperands(token, spelNodeImpl, spelNodeImpl2);
            spelNodeImpl = new OpAnd(token.startPos, token.endPos, spelNodeImpl, spelNodeImpl2);
        }
        return spelNodeImpl;
    }

    private SpelNodeImpl eatRelationalExpression() {
        SpelNodeImpl spelNodeImpl = this.eatSumExpression();
        Token token = this.maybeEatRelationalOperator();
        if (token != null) {
            Token token2 = this.takeToken();
            SpelNodeImpl spelNodeImpl2 = this.eatSumExpression();
            this.checkOperands(token2, spelNodeImpl, spelNodeImpl2);
            TokenKind tokenKind = token.kind;
            if (token.isNumericRelationalOperator()) {
                if (tokenKind == TokenKind.GT) {
                    return new OpGT(token2.startPos, token2.endPos, spelNodeImpl, spelNodeImpl2);
                }
                if (tokenKind == TokenKind.LT) {
                    return new OpLT(token2.startPos, token2.endPos, spelNodeImpl, spelNodeImpl2);
                }
                if (tokenKind == TokenKind.LE) {
                    return new OpLE(token2.startPos, token2.endPos, spelNodeImpl, spelNodeImpl2);
                }
                if (tokenKind == TokenKind.GE) {
                    return new OpGE(token2.startPos, token2.endPos, spelNodeImpl, spelNodeImpl2);
                }
                if (tokenKind == TokenKind.EQ) {
                    return new OpEQ(token2.startPos, token2.endPos, spelNodeImpl, spelNodeImpl2);
                }
                Assert.isTrue(tokenKind == TokenKind.NE, "Not-equals token expected");
                return new OpNE(token2.startPos, token2.endPos, spelNodeImpl, spelNodeImpl2);
            }
            if (tokenKind == TokenKind.INSTANCEOF) {
                return new OperatorInstanceof(token2.startPos, token2.endPos, spelNodeImpl, spelNodeImpl2);
            }
            if (tokenKind == TokenKind.MATCHES) {
                return new OperatorMatches(token2.startPos, token2.endPos, spelNodeImpl, spelNodeImpl2);
            }
            Assert.isTrue(tokenKind == TokenKind.BETWEEN, "Between token expected");
            return new OperatorBetween(token2.startPos, token2.endPos, spelNodeImpl, spelNodeImpl2);
        }
        return spelNodeImpl;
    }

    private SpelNodeImpl eatSumExpression() {
        SpelNodeImpl spelNodeImpl = this.eatProductExpression();
        while (this.peekToken(TokenKind.PLUS, TokenKind.MINUS, TokenKind.INC)) {
            Token token = this.takeToken();
            SpelNodeImpl spelNodeImpl2 = this.eatProductExpression();
            this.checkRightOperand(token, spelNodeImpl2);
            if (token.kind == TokenKind.PLUS) {
                spelNodeImpl = new OpPlus(token.startPos, token.endPos, spelNodeImpl, spelNodeImpl2);
                continue;
            }
            if (token.kind != TokenKind.MINUS) continue;
            spelNodeImpl = new OpMinus(token.startPos, token.endPos, spelNodeImpl, spelNodeImpl2);
        }
        return spelNodeImpl;
    }

    private SpelNodeImpl eatProductExpression() {
        SpelNodeImpl spelNodeImpl = this.eatPowerIncDecExpression();
        while (this.peekToken(TokenKind.STAR, TokenKind.DIV, TokenKind.MOD)) {
            Token token = this.takeToken();
            SpelNodeImpl spelNodeImpl2 = this.eatPowerIncDecExpression();
            this.checkOperands(token, spelNodeImpl, spelNodeImpl2);
            if (token.kind == TokenKind.STAR) {
                spelNodeImpl = new OpMultiply(token.startPos, token.endPos, spelNodeImpl, spelNodeImpl2);
                continue;
            }
            if (token.kind == TokenKind.DIV) {
                spelNodeImpl = new OpDivide(token.startPos, token.endPos, spelNodeImpl, spelNodeImpl2);
                continue;
            }
            Assert.isTrue(token.kind == TokenKind.MOD, "Mod token expected");
            spelNodeImpl = new OpModulus(token.startPos, token.endPos, spelNodeImpl, spelNodeImpl2);
        }
        return spelNodeImpl;
    }

    private SpelNodeImpl eatPowerIncDecExpression() {
        SpelNodeImpl spelNodeImpl = this.eatUnaryExpression();
        if (this.peekToken(TokenKind.POWER)) {
            Token token = this.takeToken();
            SpelNodeImpl spelNodeImpl2 = this.eatUnaryExpression();
            this.checkRightOperand(token, spelNodeImpl2);
            return new OperatorPower(token.startPos, token.endPos, spelNodeImpl, spelNodeImpl2);
        }
        if (spelNodeImpl != null && this.peekToken(TokenKind.INC, TokenKind.DEC)) {
            Token token = this.takeToken();
            if (token.getKind() == TokenKind.INC) {
                return new OpInc(token.startPos, token.endPos, true, spelNodeImpl);
            }
            return new OpDec(token.startPos, token.endPos, true, spelNodeImpl);
        }
        return spelNodeImpl;
    }

    private SpelNodeImpl eatUnaryExpression() {
        if (this.peekToken(TokenKind.PLUS, TokenKind.MINUS, TokenKind.NOT)) {
            Token token = this.takeToken();
            SpelNodeImpl spelNodeImpl = this.eatUnaryExpression();
            Assert.state(spelNodeImpl != null, "No node");
            if (token.kind == TokenKind.NOT) {
                return new OperatorNot(token.startPos, token.endPos, spelNodeImpl);
            }
            if (token.kind == TokenKind.PLUS) {
                return new OpPlus(token.startPos, token.endPos, spelNodeImpl);
            }
            Assert.isTrue(token.kind == TokenKind.MINUS, "Minus token expected");
            return new OpMinus(token.startPos, token.endPos, spelNodeImpl);
        }
        if (this.peekToken(TokenKind.INC, TokenKind.DEC)) {
            Token token = this.takeToken();
            SpelNodeImpl spelNodeImpl = this.eatUnaryExpression();
            if (token.getKind() == TokenKind.INC) {
                return new OpInc(token.startPos, token.endPos, false, spelNodeImpl);
            }
            return new OpDec(token.startPos, token.endPos, false, spelNodeImpl);
        }
        return this.eatPrimaryExpression();
    }

    private SpelNodeImpl eatPrimaryExpression() {
        SpelNodeImpl spelNodeImpl = this.eatStartNode();
        ArrayList<SpelNodeImpl> arrayList = null;
        SpelNodeImpl spelNodeImpl2 = this.eatNode();
        while (spelNodeImpl2 != null) {
            if (arrayList == null) {
                arrayList = new ArrayList<SpelNodeImpl>(4);
                arrayList.add(spelNodeImpl);
            }
            arrayList.add(spelNodeImpl2);
            spelNodeImpl2 = this.eatNode();
        }
        if (spelNodeImpl == null || arrayList == null) {
            return spelNodeImpl;
        }
        return new CompoundExpression(spelNodeImpl.getStartPosition(), ((SpelNodeImpl)arrayList.get(arrayList.size() - 1)).getEndPosition(), arrayList.toArray(new SpelNodeImpl[0]));
    }

    private SpelNodeImpl eatNode() {
        return this.peekToken(TokenKind.DOT, TokenKind.SAFE_NAVI) ? this.eatDottedNode() : this.eatNonDottedNode();
    }

    private SpelNodeImpl eatNonDottedNode() {
        if (this.peekToken(TokenKind.LSQUARE) && this.maybeEatIndexer()) {
            return this.pop();
        }
        return null;
    }

    private SpelNodeImpl eatDottedNode() {
        boolean bl2;
        Token token = this.takeToken();
        boolean bl3 = bl2 = token.kind == TokenKind.SAFE_NAVI;
        if (this.maybeEatMethodOrProperty(bl2) || this.maybeEatFunctionOrVar() || this.maybeEatProjection(bl2) || this.maybeEatSelection(bl2)) {
            return this.pop();
        }
        if (this.peekToken() == null) {
            throw this.internalException(token.startPos, SpelMessage.OOD, new Object[0]);
        }
        throw this.internalException(token.startPos, SpelMessage.UNEXPECTED_DATA_AFTER_DOT, this.toString(this.peekToken()));
    }

    private boolean maybeEatFunctionOrVar() {
        if (!this.peekToken(TokenKind.HASH)) {
            return false;
        }
        Token token = this.takeToken();
        Token token2 = this.eatToken(TokenKind.IDENTIFIER);
        SpelNodeImpl[] spelNodeImplArray = this.maybeEatMethodArgs();
        if (spelNodeImplArray == null) {
            this.push(new VariableReference(token2.stringValue(), token.startPos, token2.endPos));
            return true;
        }
        this.push(new FunctionReference(token2.stringValue(), token.startPos, token2.endPos, spelNodeImplArray));
        return true;
    }

    private SpelNodeImpl[] maybeEatMethodArgs() {
        if (!this.peekToken(TokenKind.LPAREN)) {
            return null;
        }
        ArrayList<SpelNodeImpl> arrayList = new ArrayList<SpelNodeImpl>();
        this.consumeArguments(arrayList);
        this.eatToken(TokenKind.RPAREN);
        return arrayList.toArray(new SpelNodeImpl[0]);
    }

    private void eatConstructorArgs(List<SpelNodeImpl> list) {
        if (!this.peekToken(TokenKind.LPAREN)) {
            throw new InternalParseException(new SpelParseException(this.expressionString, this.positionOf(this.peekToken()), SpelMessage.MISSING_CONSTRUCTOR_ARGS, new Object[0]));
        }
        this.consumeArguments(list);
        this.eatToken(TokenKind.RPAREN);
    }

    private void consumeArguments(List<SpelNodeImpl> list) {
        Token token;
        Token token2 = this.peekToken();
        Assert.state(token2 != null, "Expected token");
        int n2 = token2.startPos;
        do {
            this.nextToken();
            token2 = this.peekToken();
            if (token2 == null) {
                throw this.internalException(n2, SpelMessage.RUN_OUT_OF_ARGUMENTS, new Object[0]);
            }
            if (token2.kind == TokenKind.RPAREN) continue;
            list.add(this.eatExpression());
        } while ((token = this.peekToken()) != null && token.kind == TokenKind.COMMA);
        if (token == null) {
            throw this.internalException(n2, SpelMessage.RUN_OUT_OF_ARGUMENTS, new Object[0]);
        }
    }

    private int positionOf(Token token) {
        if (token == null) {
            return this.expressionString.length();
        }
        return token.startPos;
    }

    private SpelNodeImpl eatStartNode() {
        if (this.maybeEatLiteral()) {
            return this.pop();
        }
        if (this.maybeEatParenExpression()) {
            return this.pop();
        }
        if (this.maybeEatTypeReference() || this.maybeEatNullReference() || this.maybeEatConstructorReference() || this.maybeEatMethodOrProperty(false) || this.maybeEatFunctionOrVar()) {
            return this.pop();
        }
        if (this.maybeEatBeanReference()) {
            return this.pop();
        }
        if (this.maybeEatProjection(false) || this.maybeEatSelection(false) || this.maybeEatIndexer()) {
            return this.pop();
        }
        if (this.maybeEatInlineListOrMap()) {
            return this.pop();
        }
        return null;
    }

    private boolean maybeEatBeanReference() {
        if (this.peekToken(TokenKind.BEAN_REF) || this.peekToken(TokenKind.FACTORY_BEAN_REF)) {
            BeanReference beanReference;
            Token token = this.takeToken();
            Token token2 = null;
            String string = null;
            if (this.peekToken(TokenKind.IDENTIFIER)) {
                token2 = this.eatToken(TokenKind.IDENTIFIER);
                string = token2.stringValue();
            } else if (this.peekToken(TokenKind.LITERAL_STRING)) {
                token2 = this.eatToken(TokenKind.LITERAL_STRING);
                string = token2.stringValue();
                string = string.substring(1, string.length() - 1);
            } else {
                throw this.internalException(token.startPos, SpelMessage.INVALID_BEAN_REFERENCE, new Object[0]);
            }
            if (token.getKind() == TokenKind.FACTORY_BEAN_REF) {
                String string2 = String.valueOf(TokenKind.FACTORY_BEAN_REF.tokenChars) + string;
                beanReference = new BeanReference(token.startPos, token2.endPos, string2);
            } else {
                beanReference = new BeanReference(token2.startPos, token2.endPos, string);
            }
            this.constructedNodes.push(beanReference);
            return true;
        }
        return false;
    }

    private boolean maybeEatTypeReference() {
        if (this.peekToken(TokenKind.IDENTIFIER)) {
            Token token = this.peekToken();
            Assert.state(token != null, "Expected token");
            if (!"T".equals(token.stringValue())) {
                return false;
            }
            Token token2 = this.takeToken();
            if (this.peekToken(TokenKind.RSQUARE)) {
                this.push(new PropertyOrFieldReference(false, token2.stringValue(), token2.startPos, token2.endPos));
                return true;
            }
            this.eatToken(TokenKind.LPAREN);
            SpelNodeImpl spelNodeImpl = this.eatPossiblyQualifiedId();
            int n2 = 0;
            while (this.peekToken(TokenKind.LSQUARE, true)) {
                this.eatToken(TokenKind.RSQUARE);
                ++n2;
            }
            this.eatToken(TokenKind.RPAREN);
            this.constructedNodes.push(new TypeReference(token.startPos, token.endPos, spelNodeImpl, n2));
            return true;
        }
        return false;
    }

    private boolean maybeEatNullReference() {
        if (this.peekToken(TokenKind.IDENTIFIER)) {
            Token token = this.peekToken();
            Assert.state(token != null, "Expected token");
            if (!"null".equalsIgnoreCase(token.stringValue())) {
                return false;
            }
            this.nextToken();
            this.constructedNodes.push(new NullLiteral(token.startPos, token.endPos));
            return true;
        }
        return false;
    }

    private boolean maybeEatProjection(boolean bl2) {
        Token token = this.peekToken();
        if (!this.peekToken(TokenKind.PROJECT, true)) {
            return false;
        }
        Assert.state(token != null, "No token");
        SpelNodeImpl spelNodeImpl = this.eatExpression();
        Assert.state(spelNodeImpl != null, "No node");
        this.eatToken(TokenKind.RSQUARE);
        this.constructedNodes.push(new Projection(bl2, token.startPos, token.endPos, spelNodeImpl));
        return true;
    }

    private boolean maybeEatInlineListOrMap() {
        Token token = this.peekToken();
        if (!this.peekToken(TokenKind.LCURLY, true)) {
            return false;
        }
        Assert.state(token != null, "No token");
        SpelNodeImpl spelNodeImpl = null;
        Token token2 = this.peekToken();
        if (this.peekToken(TokenKind.RCURLY, true)) {
            Assert.state(token2 != null, "No token");
            spelNodeImpl = new InlineList(token.startPos, token2.endPos, new SpelNodeImpl[0]);
        } else if (this.peekToken(TokenKind.COLON, true)) {
            token2 = this.eatToken(TokenKind.RCURLY);
            spelNodeImpl = new InlineMap(token.startPos, token2.endPos, new SpelNodeImpl[0]);
        } else {
            SpelNodeImpl spelNodeImpl2 = this.eatExpression();
            if (this.peekToken(TokenKind.RCURLY)) {
                ArrayList<SpelNodeImpl> arrayList = new ArrayList<SpelNodeImpl>();
                arrayList.add(spelNodeImpl2);
                token2 = this.eatToken(TokenKind.RCURLY);
                spelNodeImpl = new InlineList(token.startPos, token2.endPos, arrayList.toArray(new SpelNodeImpl[0]));
            } else if (this.peekToken(TokenKind.COMMA, true)) {
                ArrayList<SpelNodeImpl> arrayList = new ArrayList<SpelNodeImpl>();
                arrayList.add(spelNodeImpl2);
                do {
                    arrayList.add(this.eatExpression());
                } while (this.peekToken(TokenKind.COMMA, true));
                token2 = this.eatToken(TokenKind.RCURLY);
                spelNodeImpl = new InlineList(token.startPos, token2.endPos, arrayList.toArray(new SpelNodeImpl[0]));
            } else if (this.peekToken(TokenKind.COLON, true)) {
                ArrayList<SpelNodeImpl> arrayList = new ArrayList<SpelNodeImpl>();
                arrayList.add(spelNodeImpl2);
                arrayList.add(this.eatExpression());
                while (this.peekToken(TokenKind.COMMA, true)) {
                    arrayList.add(this.eatExpression());
                    this.eatToken(TokenKind.COLON);
                    arrayList.add(this.eatExpression());
                }
                token2 = this.eatToken(TokenKind.RCURLY);
                spelNodeImpl = new InlineMap(token.startPos, token2.endPos, arrayList.toArray(new SpelNodeImpl[0]));
            } else {
                throw this.internalException(token.startPos, SpelMessage.OOD, new Object[0]);
            }
        }
        this.constructedNodes.push(spelNodeImpl);
        return true;
    }

    private boolean maybeEatIndexer() {
        Token token = this.peekToken();
        if (!this.peekToken(TokenKind.LSQUARE, true)) {
            return false;
        }
        Assert.state(token != null, "No token");
        SpelNodeImpl spelNodeImpl = this.eatExpression();
        Assert.state(spelNodeImpl != null, "No node");
        this.eatToken(TokenKind.RSQUARE);
        this.constructedNodes.push(new Indexer(token.startPos, token.endPos, spelNodeImpl));
        return true;
    }

    private boolean maybeEatSelection(boolean bl2) {
        Token token = this.peekToken();
        if (!this.peekSelectToken()) {
            return false;
        }
        Assert.state(token != null, "No token");
        this.nextToken();
        SpelNodeImpl spelNodeImpl = this.eatExpression();
        if (spelNodeImpl == null) {
            throw this.internalException(token.startPos, SpelMessage.MISSING_SELECTION_EXPRESSION, new Object[0]);
        }
        this.eatToken(TokenKind.RSQUARE);
        if (token.kind == TokenKind.SELECT_FIRST) {
            this.constructedNodes.push(new Selection(bl2, 1, token.startPos, token.endPos, spelNodeImpl));
        } else if (token.kind == TokenKind.SELECT_LAST) {
            this.constructedNodes.push(new Selection(bl2, 2, token.startPos, token.endPos, spelNodeImpl));
        } else {
            this.constructedNodes.push(new Selection(bl2, 0, token.startPos, token.endPos, spelNodeImpl));
        }
        return true;
    }

    private SpelNodeImpl eatPossiblyQualifiedId() {
        ArrayDeque<Identifier> arrayDeque = new ArrayDeque<Identifier>();
        Token token = this.peekToken();
        while (this.isValidQualifiedId(token)) {
            this.nextToken();
            if (token.kind != TokenKind.DOT) {
                arrayDeque.add(new Identifier(token.stringValue(), token.startPos, token.endPos));
            }
            token = this.peekToken();
        }
        if (arrayDeque.isEmpty()) {
            if (token == null) {
                throw this.internalException(this.expressionString.length(), SpelMessage.OOD, new Object[0]);
            }
            throw this.internalException(token.startPos, SpelMessage.NOT_EXPECTED_TOKEN, "qualified ID", token.getKind().toString().toLowerCase());
        }
        return new QualifiedIdentifier(((SpelNodeImpl)arrayDeque.getFirst()).getStartPosition(), ((SpelNodeImpl)arrayDeque.getLast()).getEndPosition(), arrayDeque.toArray(new SpelNodeImpl[0]));
    }

    private boolean isValidQualifiedId(Token token) {
        if (token == null || token.kind == TokenKind.LITERAL_STRING) {
            return false;
        }
        if (token.kind == TokenKind.DOT || token.kind == TokenKind.IDENTIFIER) {
            return true;
        }
        String string = token.stringValue();
        return StringUtils.hasLength(string) && VALID_QUALIFIED_ID_PATTERN.matcher(string).matches();
    }

    private boolean maybeEatMethodOrProperty(boolean bl2) {
        if (this.peekToken(TokenKind.IDENTIFIER)) {
            Token token = this.takeToken();
            SpelNodeImpl[] spelNodeImplArray = this.maybeEatMethodArgs();
            if (spelNodeImplArray == null) {
                this.push(new PropertyOrFieldReference(bl2, token.stringValue(), token.startPos, token.endPos));
                return true;
            }
            this.push(new MethodReference(bl2, token.stringValue(), token.startPos, token.endPos, spelNodeImplArray));
            return true;
        }
        return false;
    }

    private boolean maybeEatConstructorReference() {
        if (this.peekIdentifierToken("new")) {
            Token token = this.takeToken();
            if (this.peekToken(TokenKind.RSQUARE)) {
                this.push(new PropertyOrFieldReference(false, token.stringValue(), token.startPos, token.endPos));
                return true;
            }
            SpelNodeImpl spelNodeImpl = this.eatPossiblyQualifiedId();
            ArrayList<SpelNodeImpl> arrayList = new ArrayList<SpelNodeImpl>();
            arrayList.add(spelNodeImpl);
            if (this.peekToken(TokenKind.LSQUARE)) {
                ArrayList<SpelNodeImpl> arrayList2 = new ArrayList<SpelNodeImpl>();
                while (this.peekToken(TokenKind.LSQUARE, true)) {
                    if (!this.peekToken(TokenKind.RSQUARE)) {
                        arrayList2.add(this.eatExpression());
                    } else {
                        arrayList2.add(null);
                    }
                    this.eatToken(TokenKind.RSQUARE);
                }
                if (this.maybeEatInlineListOrMap()) {
                    arrayList.add(this.pop());
                }
                this.push(new ConstructorReference(token.startPos, token.endPos, arrayList2.toArray(new SpelNodeImpl[0]), arrayList.toArray(new SpelNodeImpl[0])));
            } else {
                this.eatConstructorArgs(arrayList);
                this.push(new ConstructorReference(token.startPos, token.endPos, arrayList.toArray(new SpelNodeImpl[0])));
            }
            return true;
        }
        return false;
    }

    private void push(SpelNodeImpl spelNodeImpl) {
        this.constructedNodes.push(spelNodeImpl);
    }

    private SpelNodeImpl pop() {
        return this.constructedNodes.pop();
    }

    private boolean maybeEatLiteral() {
        Token token = this.peekToken();
        if (token == null) {
            return false;
        }
        if (token.kind == TokenKind.LITERAL_INT) {
            this.push(Literal.getIntLiteral(token.stringValue(), token.startPos, token.endPos, 10));
        } else if (token.kind == TokenKind.LITERAL_LONG) {
            this.push(Literal.getLongLiteral(token.stringValue(), token.startPos, token.endPos, 10));
        } else if (token.kind == TokenKind.LITERAL_HEXINT) {
            this.push(Literal.getIntLiteral(token.stringValue(), token.startPos, token.endPos, 16));
        } else if (token.kind == TokenKind.LITERAL_HEXLONG) {
            this.push(Literal.getLongLiteral(token.stringValue(), token.startPos, token.endPos, 16));
        } else if (token.kind == TokenKind.LITERAL_REAL) {
            this.push(Literal.getRealLiteral(token.stringValue(), token.startPos, token.endPos, false));
        } else if (token.kind == TokenKind.LITERAL_REAL_FLOAT) {
            this.push(Literal.getRealLiteral(token.stringValue(), token.startPos, token.endPos, true));
        } else if (this.peekIdentifierToken("true")) {
            this.push(new BooleanLiteral(token.stringValue(), token.startPos, token.endPos, true));
        } else if (this.peekIdentifierToken("false")) {
            this.push(new BooleanLiteral(token.stringValue(), token.startPos, token.endPos, false));
        } else if (token.kind == TokenKind.LITERAL_STRING) {
            this.push(new StringLiteral(token.stringValue(), token.startPos, token.endPos, token.stringValue()));
        } else {
            return false;
        }
        this.nextToken();
        return true;
    }

    private boolean maybeEatParenExpression() {
        if (this.peekToken(TokenKind.LPAREN)) {
            this.nextToken();
            SpelNodeImpl spelNodeImpl = this.eatExpression();
            Assert.state(spelNodeImpl != null, "No node");
            this.eatToken(TokenKind.RPAREN);
            this.push(spelNodeImpl);
            return true;
        }
        return false;
    }

    private Token maybeEatRelationalOperator() {
        Token token = this.peekToken();
        if (token == null) {
            return null;
        }
        if (token.isNumericRelationalOperator()) {
            return token;
        }
        if (token.isIdentifier()) {
            String string = token.stringValue();
            if (string.equalsIgnoreCase("instanceof")) {
                return token.asInstanceOfToken();
            }
            if (string.equalsIgnoreCase("matches")) {
                return token.asMatchesToken();
            }
            if (string.equalsIgnoreCase("between")) {
                return token.asBetweenToken();
            }
        }
        return null;
    }

    private Token eatToken(TokenKind tokenKind) {
        Token token = this.nextToken();
        if (token == null) {
            int n2 = this.expressionString.length();
            throw this.internalException(n2, SpelMessage.OOD, new Object[0]);
        }
        if (token.kind != tokenKind) {
            throw this.internalException(token.startPos, SpelMessage.NOT_EXPECTED_TOKEN, tokenKind.toString().toLowerCase(), token.getKind().toString().toLowerCase());
        }
        return token;
    }

    private boolean peekToken(TokenKind tokenKind) {
        return this.peekToken(tokenKind, false);
    }

    private boolean peekToken(TokenKind tokenKind, boolean bl2) {
        Token token = this.peekToken();
        if (token == null) {
            return false;
        }
        if (token.kind == tokenKind) {
            if (bl2) {
                ++this.tokenStreamPointer;
            }
            return true;
        }
        return tokenKind == TokenKind.IDENTIFIER && token.kind.ordinal() >= TokenKind.DIV.ordinal() && token.kind.ordinal() <= TokenKind.NOT.ordinal() && token.data != null;
    }

    private boolean peekToken(TokenKind tokenKind, TokenKind tokenKind2) {
        Token token = this.peekToken();
        if (token == null) {
            return false;
        }
        return token.kind == tokenKind || token.kind == tokenKind2;
    }

    private boolean peekToken(TokenKind tokenKind, TokenKind tokenKind2, TokenKind tokenKind3) {
        Token token = this.peekToken();
        if (token == null) {
            return false;
        }
        return token.kind == tokenKind || token.kind == tokenKind2 || token.kind == tokenKind3;
    }

    private boolean peekIdentifierToken(String string) {
        Token token = this.peekToken();
        if (token == null) {
            return false;
        }
        return token.kind == TokenKind.IDENTIFIER && string.equalsIgnoreCase(token.stringValue());
    }

    private boolean peekSelectToken() {
        Token token = this.peekToken();
        if (token == null) {
            return false;
        }
        return token.kind == TokenKind.SELECT || token.kind == TokenKind.SELECT_FIRST || token.kind == TokenKind.SELECT_LAST;
    }

    private Token takeToken() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            throw new IllegalStateException("No token");
        }
        return this.tokenStream.get(this.tokenStreamPointer++);
    }

    private Token nextToken() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            return null;
        }
        return this.tokenStream.get(this.tokenStreamPointer++);
    }

    private Token peekToken() {
        if (this.tokenStreamPointer >= this.tokenStreamLength) {
            return null;
        }
        return this.tokenStream.get(this.tokenStreamPointer);
    }

    public String toString(Token token) {
        if (token == null) {
            return "";
        }
        if (token.getKind().hasPayload()) {
            return token.stringValue();
        }
        return token.kind.toString().toLowerCase();
    }

    private void checkOperands(Token token, SpelNodeImpl spelNodeImpl, SpelNodeImpl spelNodeImpl2) {
        this.checkLeftOperand(token, spelNodeImpl);
        this.checkRightOperand(token, spelNodeImpl2);
    }

    private void checkLeftOperand(Token token, SpelNodeImpl spelNodeImpl) {
        if (spelNodeImpl == null) {
            throw this.internalException(token.startPos, SpelMessage.LEFT_OPERAND_PROBLEM, new Object[0]);
        }
    }

    private void checkRightOperand(Token token, SpelNodeImpl spelNodeImpl) {
        if (spelNodeImpl == null) {
            throw this.internalException(token.startPos, SpelMessage.RIGHT_OPERAND_PROBLEM, new Object[0]);
        }
    }

    private InternalParseException internalException(int n2, SpelMessage spelMessage, Object ... objectArray) {
        return new InternalParseException(new SpelParseException(this.expressionString, n2, spelMessage, objectArray));
    }
}

