/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.Label;
import com.gradle.maven.extension.internal.dep.org.springframework.asm.MethodVisitor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.CodeFlow;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.util.Assert;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ObjectUtils;

public class Ternary
extends SpelNodeImpl {
    public Ternary(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super(n2, n3, spelNodeImplArray);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        Boolean bl2 = this.children[0].getValue(expressionState, Boolean.class);
        if (bl2 == null) {
            throw new SpelEvaluationException(this.getChild(0).getStartPosition(), SpelMessage.TYPE_CONVERSION_ERROR, "null", "boolean");
        }
        TypedValue typedValue = this.children[bl2 != false ? 1 : 2].getValueInternal(expressionState);
        this.computeExitTypeDescriptor();
        return typedValue;
    }

    @Override
    public String toStringAST() {
        return this.getChild(0).toStringAST() + " ? " + this.getChild(1).toStringAST() + " : " + this.getChild(2).toStringAST();
    }

    private void computeExitTypeDescriptor() {
        if (this.exitTypeDescriptor == null && this.children[1].exitTypeDescriptor != null && this.children[2].exitTypeDescriptor != null) {
            String string = this.children[1].exitTypeDescriptor;
            String string2 = this.children[2].exitTypeDescriptor;
            this.exitTypeDescriptor = ObjectUtils.nullSafeEquals(string, string2) ? string : "Ljava/lang/Object";
        }
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl spelNodeImpl = this.children[0];
        SpelNodeImpl spelNodeImpl2 = this.children[1];
        SpelNodeImpl spelNodeImpl3 = this.children[2];
        return spelNodeImpl.isCompilable() && spelNodeImpl2.isCompilable() && spelNodeImpl3.isCompilable() && CodeFlow.isBooleanCompatible(spelNodeImpl.exitTypeDescriptor) && spelNodeImpl2.exitTypeDescriptor != null && spelNodeImpl3.exitTypeDescriptor != null;
    }

    @Override
    public void generateCode(MethodVisitor methodVisitor, CodeFlow codeFlow) {
        this.computeExitTypeDescriptor();
        codeFlow.enterCompilationScope();
        this.children[0].generateCode(methodVisitor, codeFlow);
        String string = codeFlow.lastDescriptor();
        Assert.state(string != null, "No last descriptor");
        if (!CodeFlow.isPrimitive(string)) {
            CodeFlow.insertUnboxInsns(methodVisitor, 'Z', string);
        }
        codeFlow.exitCompilationScope();
        Label label = new Label();
        Label label2 = new Label();
        methodVisitor.visitJumpInsn(153, label);
        codeFlow.enterCompilationScope();
        this.children[1].generateCode(methodVisitor, codeFlow);
        if (!CodeFlow.isPrimitive(this.exitTypeDescriptor)) {
            string = codeFlow.lastDescriptor();
            Assert.state(string != null, "No last descriptor");
            CodeFlow.insertBoxIfNecessary(methodVisitor, string.charAt(0));
        }
        codeFlow.exitCompilationScope();
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label);
        codeFlow.enterCompilationScope();
        this.children[2].generateCode(methodVisitor, codeFlow);
        if (!CodeFlow.isPrimitive(this.exitTypeDescriptor)) {
            string = codeFlow.lastDescriptor();
            Assert.state(string != null, "No last descriptor");
            CodeFlow.insertBoxIfNecessary(methodVisitor, string.charAt(0));
        }
        codeFlow.exitCompilationScope();
        methodVisitor.visitLabel(label2);
        codeFlow.pushDescriptor(this.exitTypeDescriptor);
    }
}

