/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeComparator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ExpressionState;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelEvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.SpelMessage;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.Operator;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.ast.SpelNodeImpl;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.BooleanTypedValue;
import java.util.List;

public class OperatorBetween
extends Operator {
    public OperatorBetween(int n2, int n3, SpelNodeImpl ... spelNodeImplArray) {
        super("between", n2, n3, spelNodeImplArray);
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        Object object = this.getLeftOperand().getValueInternal(expressionState).getValue();
        Object object2 = this.getRightOperand().getValueInternal(expressionState).getValue();
        if (!(object2 instanceof List) || ((List)object2).size() != 2) {
            throw new SpelEvaluationException(this.getRightOperand().getStartPosition(), SpelMessage.BETWEEN_RIGHT_OPERAND_MUST_BE_TWO_ELEMENT_LIST, new Object[0]);
        }
        List list = (List)object2;
        Object e2 = list.get(0);
        Object e3 = list.get(1);
        TypeComparator typeComparator = expressionState.getTypeComparator();
        try {
            return BooleanTypedValue.forValue(typeComparator.compare(object, e2) >= 0 && typeComparator.compare(object, e3) <= 0);
        }
        catch (SpelEvaluationException spelEvaluationException) {
            spelEvaluationException.setPosition(this.getStartPosition());
            throw spelEvaluationException;
        }
    }
}

