/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.common;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.Expression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.ExpressionParser;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.ParseException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.ParserContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.common.CompositeStringExpression;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.common.LiteralExpression;
import java.util.ArrayDeque;
import java.util.ArrayList;

public abstract class TemplateAwareExpressionParser
implements ExpressionParser {
    @Override
    public Expression parseExpression(String string, ParserContext parserContext) throws ParseException {
        if (parserContext != null && parserContext.isTemplate()) {
            return this.parseTemplate(string, parserContext);
        }
        return this.doParseExpression(string, parserContext);
    }

    private Expression parseTemplate(String string, ParserContext parserContext) throws ParseException {
        if (string.isEmpty()) {
            return new LiteralExpression("");
        }
        Expression[] expressionArray = this.parseExpressions(string, parserContext);
        if (expressionArray.length == 1) {
            return expressionArray[0];
        }
        return new CompositeStringExpression(string, expressionArray);
    }

    private Expression[] parseExpressions(String string, ParserContext parserContext) throws ParseException {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        String string2 = parserContext.getExpressionPrefix();
        String string3 = parserContext.getExpressionSuffix();
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf(string2, n2);
            if (n3 >= n2) {
                int n4;
                int n5;
                if (n3 > n2) {
                    arrayList.add(new LiteralExpression(string.substring(n2, n3)));
                }
                if ((n5 = this.skipToCorrectEndSuffix(string3, string, n4 = n3 + string2.length())) == -1) {
                    throw new ParseException(string, n3, "No ending suffix '" + string3 + "' for expression starting at character " + n3 + ": " + string.substring(n3));
                }
                if (n5 == n4) {
                    throw new ParseException(string, n3, "No expression defined within delimiter '" + string2 + string3 + "' at character " + n3);
                }
                String string4 = string.substring(n3 + string2.length(), n5);
                if ((string4 = string4.trim()).isEmpty()) {
                    throw new ParseException(string, n3, "No expression defined within delimiter '" + string2 + string3 + "' at character " + n3);
                }
                arrayList.add(this.doParseExpression(string4, parserContext));
                n2 = n5 + string3.length();
                continue;
            }
            arrayList.add(new LiteralExpression(string.substring(n2)));
            n2 = string.length();
        }
        return arrayList.toArray(new Expression[0]);
    }

    private boolean isSuffixHere(String string, int n2, String string2) {
        int n3 = 0;
        for (int i2 = 0; i2 < string2.length() && n2 < string.length(); ++i2) {
            if (string.charAt(n2++) == string2.charAt(n3++)) continue;
            return false;
        }
        return n3 == string2.length();
    }

    private int skipToCorrectEndSuffix(String string, String string2, int n2) throws ParseException {
        int n3;
        int n4 = string2.length();
        int n5 = string2.indexOf(string, n2);
        if (n5 == -1) {
            return -1;
        }
        ArrayDeque<Bracket> arrayDeque = new ArrayDeque<Bracket>();
        block5: for (n3 = n2; !(n3 >= n4 || this.isSuffixHere(string2, n3, string) && arrayDeque.isEmpty()); ++n3) {
            char c2 = string2.charAt(n3);
            switch (c2) {
                case '(': 
                case '[': 
                case '{': {
                    arrayDeque.push(new Bracket(c2, n3));
                    continue block5;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (arrayDeque.isEmpty()) {
                        throw new ParseException(string2, n3, "Found closing '" + c2 + "' at position " + n3 + " without an opening '" + Bracket.theOpenBracketFor(c2) + "'");
                    }
                    Bracket bracket = (Bracket)arrayDeque.pop();
                    if (bracket.compatibleWithCloseBracket(c2)) continue block5;
                    throw new ParseException(string2, n3, "Found closing '" + c2 + "' at position " + n3 + " but most recent opening is '" + bracket.bracket + "' at position " + bracket.pos);
                }
                case '\"': 
                case '\'': {
                    int n6 = string2.indexOf(c2, n3 + 1);
                    if (n6 == -1) {
                        throw new ParseException(string2, n3, "Found non terminating string literal starting at position " + n3);
                    }
                    n3 = n6;
                }
            }
        }
        if (!arrayDeque.isEmpty()) {
            Bracket bracket = (Bracket)arrayDeque.pop();
            throw new ParseException(string2, bracket.pos, "Missing closing '" + Bracket.theCloseBracketFor(bracket.bracket) + "' for '" + bracket.bracket + "' at position " + bracket.pos);
        }
        if (!this.isSuffixHere(string2, n3, string)) {
            return -1;
        }
        return n3;
    }

    protected abstract Expression doParseExpression(String var1, ParserContext var2) throws ParseException;

    private static class Bracket {
        char bracket;
        int pos;

        Bracket(char c2, int n2) {
            this.bracket = c2;
            this.pos = n2;
        }

        boolean compatibleWithCloseBracket(char c2) {
            if (this.bracket == '{') {
                return c2 == '}';
            }
            if (this.bracket == '[') {
                return c2 == ']';
            }
            return c2 == ')';
        }

        static char theOpenBracketFor(char c2) {
            if (c2 == '}') {
                return '{';
            }
            if (c2 == ']') {
                return '[';
            }
            return '(';
        }

        static char theCloseBracketFor(char c2) {
            if (c2 == '{') {
                return '}';
            }
            if (c2 == '[') {
                return ']';
            }
            return ')';
        }
    }
}

