/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.ConversionService;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support.ConversionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

final class CollectionToObjectConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    public CollectionToObjectConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Collection.class, Object.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return ConversionUtils.canConvertElements(typeDescriptor.getElementTypeDescriptor(), typeDescriptor2, this.conversionService);
    }

    @Override
    public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            return null;
        }
        if (typeDescriptor.isAssignableTo(typeDescriptor2)) {
            return object;
        }
        Collection collection = (Collection)object;
        if (collection.isEmpty()) {
            return null;
        }
        Object e2 = collection.iterator().next();
        return this.conversionService.convert(e2, typeDescriptor.elementTypeDescriptor(e2), typeDescriptor2);
    }
}

