/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.common.io;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ConnectionState {
    private final AtomicReference<State> state = new AtomicReference<State>(State.HANDSHAKING);
    private final AtomicBoolean wasOpened = new AtomicBoolean(false);

    public boolean canReadWebSocketFrames() {
        State state = this.state.get();
        return state == State.OPENED || state == State.CLOSING;
    }

    public boolean wasOpened() {
        return this.wasOpened.get();
    }

    public boolean opening() {
        State state;
        block5: while (true) {
            state = this.state.get();
            switch (state) {
                case HANDSHAKING: {
                    if (!this.state.compareAndSet(state, State.OPENING)) continue block5;
                    this.wasOpened.set(true);
                    return true;
                }
                case CLOSING: {
                    return false;
                }
                case DISCONNECTED: {
                    return false;
                }
            }
            break;
        }
        throw new IllegalStateException(this.toString(state));
    }

    public boolean opened() {
        State state;
        block5: while (true) {
            state = this.state.get();
            switch (state) {
                case OPENING: {
                    if (!this.state.compareAndSet(state, State.OPENED)) continue block5;
                    return true;
                }
                case CLOSING: {
                    return false;
                }
                case DISCONNECTED: {
                    return false;
                }
            }
            break;
        }
        throw new IllegalStateException(this.toString(state));
    }

    public boolean closing() {
        State state;
        block5: while (true) {
            state = this.state.get();
            switch (state) {
                case HANDSHAKING: 
                case OPENING: 
                case OPENED: {
                    if (!this.state.compareAndSet(state, State.CLOSING)) continue block5;
                    return true;
                }
                case CLOSING: {
                    return false;
                }
                case DISCONNECTED: {
                    return false;
                }
            }
            break;
        }
        throw new IllegalStateException(this.toString(state));
    }

    public boolean disconnected() {
        State state;
        do {
            state = this.state.get();
            switch (state) {
                case DISCONNECTED: {
                    return false;
                }
            }
        } while (!this.state.compareAndSet(state, State.DISCONNECTED));
        return true;
    }

    private String toString(State state) {
        return String.format("%s@%x[%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), state});
    }

    public String toString() {
        return this.toString(this.state.get());
    }

    private static enum State {
        HANDSHAKING,
        OPENING,
        OPENED,
        CLOSING,
        DISCONNECTED;

    }
}

