/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Invocable;
import java.util.function.Consumer;

public interface Callback
extends Invocable {
    public static final Callback NOOP = new Callback(){

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    };

    default public void succeeded() {
    }

    default public void failed(Throwable throwable) {
    }

    public static Callback from(Runnable runnable, Consumer<Throwable> consumer) {
        return Callback.from(Invocable.InvocationType.BLOCKING, runnable, consumer);
    }

    public static Callback from(final Invocable.InvocationType invocationType, final Runnable runnable, final Consumer<Throwable> consumer) {
        return new Callback(){

            @Override
            public void succeeded() {
                runnable.run();
            }

            @Override
            public void failed(Throwable throwable) {
                consumer.accept(throwable);
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return invocationType;
            }
        };
    }

    public static class Nested
    extends Completing {
        private final Callback callback;

        public Nested(Callback callback) {
            this.callback = callback;
        }

        @Override
        public void succeeded() {
            try {
                this.callback.succeeded();
            }
            finally {
                this.completed();
            }
        }

        @Override
        public void failed(Throwable throwable) {
            try {
                this.callback.failed(throwable);
            }
            finally {
                this.completed();
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this.callback.getInvocationType();
        }
    }

    public static class Completing
    implements Callback {
        @Override
        public void succeeded() {
            this.completed();
        }

        @Override
        public void failed(Throwable throwable) {
            this.completed();
        }

        public void completed() {
        }
    }
}

