/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntConsumer;

public interface ByteBufferPool {
    public ByteBuffer acquire(int var1, boolean var2);

    public void release(ByteBuffer var1);

    default public ByteBuffer newByteBuffer(int n2, boolean bl2) {
        return bl2 ? BufferUtil.allocateDirect(n2) : BufferUtil.allocate(n2);
    }

    public static class Bucket {
        private final Queue<ByteBuffer> _queue = new ConcurrentLinkedQueue<ByteBuffer>();
        private final ByteBufferPool _pool;
        private final int _capacity;
        private final int _maxSize;
        private final AtomicInteger _size;
        private final AtomicLong _lastUpdate = new AtomicLong(System.nanoTime());
        private final IntConsumer _memoryFunction;

        public Bucket(ByteBufferPool byteBufferPool, int n2, int n3, IntConsumer intConsumer) {
            this._pool = byteBufferPool;
            this._capacity = n2;
            this._maxSize = n3;
            this._size = n3 > 0 ? new AtomicInteger() : null;
            this._memoryFunction = Objects.requireNonNull(intConsumer);
        }

        public ByteBuffer acquire() {
            ByteBuffer byteBuffer = this._queue.poll();
            if (byteBuffer != null) {
                if (this._size != null) {
                    this._size.decrementAndGet();
                }
                this._memoryFunction.accept(-byteBuffer.capacity());
            }
            return byteBuffer;
        }

        public void release(ByteBuffer byteBuffer) {
            this.resetUpdateTime();
            BufferUtil.reset(byteBuffer);
            if (this._size == null || this._size.incrementAndGet() <= this._maxSize) {
                this._queue.offer(byteBuffer);
                this._memoryFunction.accept(byteBuffer.capacity());
            } else {
                this._size.decrementAndGet();
            }
        }

        void resetUpdateTime() {
            this._lastUpdate.lazySet(System.nanoTime());
        }

        public void clear() {
            ByteBuffer byteBuffer;
            int n2;
            int n3 = n2 = this._size == null ? 0 : this._size.get() - 1;
            while (n2 >= 0 && (byteBuffer = this.acquire()) != null) {
                if (this._size == null) continue;
                --n2;
            }
        }

        boolean isEmpty() {
            return this._queue.isEmpty();
        }

        int size() {
            return this._queue.size();
        }

        long getLastUpdate() {
            return this._lastUpdate.get();
        }

        public String toString() {
            return String.format("%s@%x{capacity=%d, size=%d, maxSize=%d}", this.getClass().getSimpleName(), this.hashCode(), this._capacity, this.size(), this._maxSize);
        }
    }
}

