/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeaderValue;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.QuotedCSV;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ArrayTernaryTrie;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Trie;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Stream;

public class HttpFields
implements Iterable<HttpField> {
    private static final Logger LOG = Log.getLogger(HttpFields.class);
    private HttpField[] _fields;
    private int _size;
    @Deprecated
    private static final Float __one = new Float("1.0");
    @Deprecated
    private static final Float __zero = new Float("0.0");
    @Deprecated
    private static final Trie<Float> __qualities = new ArrayTernaryTrie<Float>();

    public HttpFields() {
        this(16);
    }

    public HttpFields(int n2) {
        this._fields = new HttpField[n2];
    }

    public int size() {
        return this._size;
    }

    @Override
    public Iterator<HttpField> iterator() {
        return new ListItr();
    }

    public Stream<HttpField> stream() {
        return Arrays.stream(this._fields).limit(this._size);
    }

    public HttpField getField(int n2) {
        if (n2 >= this._size) {
            throw new NoSuchElementException();
        }
        return this._fields[n2];
    }

    public HttpField getField(HttpHeader httpHeader) {
        for (int i2 = 0; i2 < this._size; ++i2) {
            HttpField httpField = this._fields[i2];
            if (httpField.getHeader() != httpHeader) continue;
            return httpField;
        }
        return null;
    }

    public HttpField getField(String string) {
        for (int i2 = 0; i2 < this._size; ++i2) {
            HttpField httpField = this._fields[i2];
            if (!httpField.is(string)) continue;
            return httpField;
        }
        return null;
    }

    public boolean contains(HttpHeader httpHeader, String string) {
        int n2 = this._size;
        while (n2-- > 0) {
            HttpField httpField = this._fields[n2];
            if (httpField.getHeader() != httpHeader || !httpField.contains(string)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String string, String string2) {
        int n2 = this._size;
        while (n2-- > 0) {
            HttpField httpField = this._fields[n2];
            if (!httpField.is(string) || !httpField.contains(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(HttpHeader httpHeader) {
        int n2 = this._size;
        while (n2-- > 0) {
            HttpField httpField = this._fields[n2];
            if (httpField.getHeader() != httpHeader) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(String string) {
        int n2 = this._size;
        while (n2-- > 0) {
            HttpField httpField = this._fields[n2];
            if (!httpField.is(string)) continue;
            return true;
        }
        return false;
    }

    public String get(HttpHeader httpHeader) {
        for (int i2 = 0; i2 < this._size; ++i2) {
            HttpField httpField = this._fields[i2];
            if (httpField.getHeader() != httpHeader) continue;
            return httpField.getValue();
        }
        return null;
    }

    public String get(String string) {
        for (int i2 = 0; i2 < this._size; ++i2) {
            HttpField httpField = this._fields[i2];
            if (!httpField.is(string)) continue;
            return httpField.getValue();
        }
        return null;
    }

    public List<String> getValuesList(HttpHeader httpHeader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this._size; ++i2) {
            HttpField httpField = this._fields[i2];
            if (httpField.getHeader() != httpHeader) continue;
            arrayList.add(httpField.getValue());
        }
        return arrayList;
    }

    public List<String> getCSV(String string, boolean bl2) {
        QuotedCSV quotedCSV = null;
        for (HttpField httpField : this) {
            if (!httpField.is(string)) continue;
            if (quotedCSV == null) {
                quotedCSV = new QuotedCSV(bl2, new String[0]);
            }
            quotedCSV.addValue(httpField.getValue());
        }
        return quotedCSV == null ? Collections.emptyList() : quotedCSV.getValues();
    }

    public void put(HttpField httpField) {
        boolean bl2 = false;
        int n2 = this._size;
        while (n2-- > 0) {
            HttpField httpField2 = this._fields[n2];
            if (!httpField2.isSameName(httpField)) continue;
            if (bl2) {
                --this._size;
                System.arraycopy(this._fields, n2 + 1, this._fields, n2, this._size - n2);
                continue;
            }
            this._fields[n2] = httpField;
            bl2 = true;
        }
        if (!bl2) {
            this.add(httpField);
        }
    }

    public void put(HttpHeader httpHeader, HttpHeaderValue httpHeaderValue) {
        this.put(httpHeader, httpHeaderValue.toString());
    }

    public void put(HttpHeader httpHeader, String string) {
        Objects.requireNonNull(httpHeader, "header must not be null");
        if (string == null) {
            this.remove(httpHeader);
        } else {
            this.put(new HttpField(httpHeader, string));
        }
    }

    public void add(String string, String string2) {
        if (string2 == null) {
            return;
        }
        HttpField httpField = new HttpField(string, string2);
        this.add(httpField);
    }

    public void add(HttpHeader httpHeader, String string) {
        Objects.requireNonNull(httpHeader, "header must not be null");
        if (string == null) {
            throw new IllegalArgumentException("null value");
        }
        HttpField httpField = new HttpField(httpHeader, string);
        this.add(httpField);
    }

    public HttpField remove(HttpHeader httpHeader) {
        HttpField httpField = null;
        int n2 = this._size;
        while (n2-- > 0) {
            HttpField httpField2 = this._fields[n2];
            if (httpField2.getHeader() != httpHeader) continue;
            httpField = httpField2;
            this.remove(n2);
        }
        return httpField;
    }

    public HttpField remove(String string) {
        HttpField httpField = null;
        int n2 = this._size;
        while (n2-- > 0) {
            HttpField httpField2 = this._fields[n2];
            if (!httpField2.is(string)) continue;
            httpField = httpField2;
            this.remove(n2);
        }
        return httpField;
    }

    private void remove(int n2) {
        --this._size;
        System.arraycopy(this._fields, n2 + 1, this._fields, n2, this._size - n2);
        this._fields[this._size] = null;
    }

    public long getLongField(String string) throws NumberFormatException {
        HttpField httpField = this.getField(string);
        return httpField == null ? -1L : httpField.getLongValue();
    }

    public int hashCode() {
        int n2 = 0;
        for (HttpField httpField : this._fields) {
            n2 += httpField.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HttpFields)) {
            return false;
        }
        HttpFields httpFields = (HttpFields)object;
        if (this.size() != httpFields.size()) {
            return false;
        }
        block0: for (HttpField httpField : this) {
            for (HttpField httpField2 : httpFields) {
                if (!httpField.equals(httpField2)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (HttpField httpField : this) {
                if (httpField == null) continue;
                String string = httpField.getName();
                if (string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(": ");
                string = httpField.getValue();
                if (string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append("\r\n");
            }
            stringBuilder.append("\r\n");
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            LOG.warn(exception);
            return exception.toString();
        }
    }

    public void add(HttpField httpField) {
        if (httpField != null) {
            if (this._size == this._fields.length) {
                this._fields = Arrays.copyOf(this._fields, this._size * 2);
            }
            this._fields[this._size++] = httpField;
        }
    }

    static /* synthetic */ HttpField[] access$202(HttpFields httpFields, HttpField[] httpFieldArray) {
        httpFields._fields = httpFieldArray;
        return httpFieldArray;
    }

    static {
        __qualities.put("*", __one);
        __qualities.put("1.0", __one);
        __qualities.put("1", __one);
        __qualities.put("0.9", new Float("0.9"));
        __qualities.put("0.8", new Float("0.8"));
        __qualities.put("0.7", new Float("0.7"));
        __qualities.put("0.66", new Float("0.66"));
        __qualities.put("0.6", new Float("0.6"));
        __qualities.put("0.5", new Float("0.5"));
        __qualities.put("0.4", new Float("0.4"));
        __qualities.put("0.33", new Float("0.33"));
        __qualities.put("0.3", new Float("0.3"));
        __qualities.put("0.2", new Float("0.2"));
        __qualities.put("0.1", new Float("0.1"));
        __qualities.put("0", __zero);
        __qualities.put("0.0", __zero);
    }

    private class ListItr
    implements ListIterator<HttpField> {
        int _cursor;
        int _current = -1;

        private ListItr() {
        }

        @Override
        public boolean hasNext() {
            return this._cursor != HttpFields.this._size;
        }

        @Override
        public HttpField next() {
            if (this._cursor == HttpFields.this._size) {
                throw new NoSuchElementException();
            }
            this._current = this._cursor++;
            return HttpFields.this._fields[this._current];
        }

        @Override
        public void remove() {
            if (this._current < 0) {
                throw new IllegalStateException();
            }
            HttpFields.this.remove(this._current);
            ((HttpFields)HttpFields.this)._fields[((HttpFields)HttpFields.this)._size] = null;
            this._cursor = this._current;
            this._current = -1;
        }

        @Override
        public boolean hasPrevious() {
            return this._cursor > 0;
        }

        @Override
        public HttpField previous() {
            if (this._cursor == 0) {
                throw new NoSuchElementException();
            }
            this._current = --this._cursor;
            return HttpFields.this._fields[this._current];
        }

        @Override
        public int nextIndex() {
            return this._cursor;
        }

        @Override
        public int previousIndex() {
            return this._cursor - 1;
        }

        @Override
        public void set(HttpField httpField) {
            if (this._current < 0) {
                throw new IllegalStateException();
            }
            if (httpField == null) {
                this.remove();
            } else {
                ((HttpFields)HttpFields.this)._fields[this._current] = httpField;
            }
        }

        @Override
        public void add(HttpField httpField) {
            if (httpField != null) {
                HttpFields.access$202(HttpFields.this, Arrays.copyOf(HttpFields.this._fields, HttpFields.this._fields.length + 1));
                System.arraycopy(HttpFields.this._fields, this._cursor, HttpFields.this._fields, this._cursor + 1, HttpFields.this._size - this._cursor);
                ((HttpFields)HttpFields.this)._fields[this._cursor++] = httpField;
                HttpFields.this._size++;
                this._current = -1;
            }
        }
    }
}

