/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeaderValue;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.QuotedCSV;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.StringUtil;
import java.util.Objects;

public class HttpField {
    private final HttpHeader _header;
    private final String _name;
    private final String _value;
    private int hash = 0;

    public HttpField(HttpHeader httpHeader, String string, String string2) {
        this._header = httpHeader;
        this._name = this._header != null && string == null ? this._header.asString() : Objects.requireNonNull(string, "name");
        this._value = string2;
    }

    public HttpField(HttpHeader httpHeader, String string) {
        this(httpHeader, httpHeader.asString(), string);
    }

    public HttpField(HttpHeader httpHeader, HttpHeaderValue httpHeaderValue) {
        this(httpHeader, httpHeader.asString(), httpHeaderValue.asString());
    }

    public HttpField(String string, String string2) {
        this(HttpHeader.CACHE.get(string), string, string2);
    }

    public HttpHeader getHeader() {
        return this._header;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public long getLongValue() {
        return Long.parseLong(this._value);
    }

    public String[] getValues() {
        if (this._value == null) {
            return null;
        }
        QuotedCSV quotedCSV = new QuotedCSV(false, this._value);
        return quotedCSV.getValues().toArray(new String[quotedCSV.size()]);
    }

    public boolean contains(String string) {
        if (string == null) {
            return this._value == null;
        }
        if (string.isEmpty()) {
            return false;
        }
        if (this._value == null) {
            return false;
        }
        if (string.equals(this._value)) {
            return true;
        }
        string = StringUtil.asciiToLowerCase(string);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block31: for (int i2 = 0; i2 < this._value.length(); ++i2) {
            char c2 = this._value.charAt(i2);
            switch (n2) {
                case 0: {
                    switch (c2) {
                        case '\"': {
                            n3 = 0;
                            n2 = 2;
                            continue block31;
                        }
                        case ',': {
                            continue block31;
                        }
                        case ';': {
                            n4 = -1;
                            n3 = -1;
                            n2 = 5;
                            continue block31;
                        }
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                    }
                    n3 = Character.toLowerCase(c2) == string.charAt(0) ? 1 : -1;
                    n2 = 1;
                    continue block31;
                }
                case 1: {
                    switch (c2) {
                        case ',': {
                            if (n3 == string.length()) {
                                return true;
                            }
                            n2 = 0;
                            continue block31;
                        }
                        case ';': {
                            n4 = n3 >= 0 ? 0 : -1;
                            n2 = 5;
                            continue block31;
                        }
                    }
                    if (n3 <= 0) continue block31;
                    if (n3 < string.length()) {
                        n3 = Character.toLowerCase(c2) == string.charAt(n3) ? n3 + 1 : -1;
                        continue block31;
                    }
                    if (c2 == ' ' || c2 == '\t') continue block31;
                    n3 = -1;
                    continue block31;
                }
                case 2: {
                    switch (c2) {
                        case '\\': {
                            n2 = 3;
                            continue block31;
                        }
                        case '\"': {
                            n2 = 4;
                            continue block31;
                        }
                    }
                    if (n3 < 0) continue block31;
                    if (n3 < string.length()) {
                        n3 = Character.toLowerCase(c2) == string.charAt(n3) ? n3 + 1 : -1;
                        continue block31;
                    }
                    n3 = -1;
                    continue block31;
                }
                case 3: {
                    if (n3 >= 0) {
                        n3 = n3 < string.length() ? (Character.toLowerCase(c2) == string.charAt(n3) ? n3 + 1 : -1) : -1;
                    }
                    n2 = 2;
                    continue block31;
                }
                case 4: {
                    switch (c2) {
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                        case ';': {
                            n2 = 5;
                            continue block31;
                        }
                        case ',': {
                            if (n3 == string.length()) {
                                return true;
                            }
                            n2 = 0;
                            continue block31;
                        }
                    }
                    n3 = -1;
                    continue block31;
                }
                case 5: {
                    switch (c2) {
                        case ',': {
                            if (n4 != "q=0".length() && n3 == string.length()) {
                                return true;
                            }
                            n4 = 0;
                            n2 = 0;
                            continue block31;
                        }
                        case '\t': 
                        case ' ': {
                            continue block31;
                        }
                    }
                    if (n4 < 0) continue block31;
                    if (n4 < "q=0".length()) {
                        n4 = Character.toLowerCase(c2) == "q=0".charAt(n4) ? n4 + 1 : -1;
                        continue block31;
                    }
                    if (c2 == '0' || c2 == '.') continue block31;
                    n4 = -1;
                    continue block31;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return n4 != "q=0".length() && n3 == string.length();
    }

    public String toString() {
        String string = this.getValue();
        return this.getName() + ": " + (string == null ? "" : string);
    }

    public boolean isSameName(HttpField httpField) {
        if (httpField == null) {
            return false;
        }
        if (httpField == this) {
            return true;
        }
        if (this._header != null && this._header == httpField.getHeader()) {
            return true;
        }
        return this._name.equalsIgnoreCase(httpField.getName());
    }

    public boolean is(String string) {
        return this._name.equalsIgnoreCase(string);
    }

    private int nameHashCode() {
        int n2 = this.hash;
        int n3 = this._name.length();
        if (n2 == 0 && n3 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                char c2 = this._name.charAt(i2);
                if (c2 >= 'a' && c2 <= 'z') {
                    c2 = (char)(c2 - 32);
                }
                n2 = 31 * n2 + c2;
            }
            this.hash = n2;
        }
        return n2;
    }

    public int hashCode() {
        int n2 = Objects.hashCode(this._value);
        if (this._header == null) {
            return n2 ^ this.nameHashCode();
        }
        return n2 ^ this._header.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HttpField)) {
            return false;
        }
        HttpField httpField = (HttpField)object;
        if (this._header != httpField.getHeader()) {
            return false;
        }
        if (!this._name.equalsIgnoreCase(httpField.getName())) {
            return false;
        }
        return Objects.equals(this._value, httpField.getValue());
    }
}

