/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Request;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Result;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpFields;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpVersion;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import java.nio.ByteBuffer;
import java.util.EventListener;
import java.util.function.LongConsumer;

public interface Response {
    public Request getRequest();

    public HttpVersion getVersion();

    public int getStatus();

    public String getReason();

    public HttpFields getHeaders();

    public boolean abort(Throwable var1);

    public static interface Listener
    extends BeginListener,
    CompleteListener,
    ContentListener,
    FailureListener,
    HeaderListener,
    HeadersListener,
    SuccessListener {
        @Override
        default public void onBegin(Response response) {
        }

        @Override
        default public boolean onHeader(Response response, HttpField httpField) {
            return true;
        }

        @Override
        default public void onHeaders(Response response) {
        }

        @Override
        default public void onContent(Response response, ByteBuffer byteBuffer) {
        }

        @Override
        default public void onSuccess(Response response) {
        }

        @Override
        default public void onFailure(Response response, Throwable throwable) {
        }

        @Override
        default public void onComplete(Result result) {
        }

        public static class Adapter
        implements Listener {
        }
    }

    public static interface CompleteListener
    extends ResponseListener {
        public void onComplete(Result var1);
    }

    public static interface FailureListener
    extends ResponseListener {
        public void onFailure(Response var1, Throwable var2);
    }

    public static interface SuccessListener
    extends ResponseListener {
        public void onSuccess(Response var1);
    }

    public static interface DemandedContentListener
    extends ResponseListener {
        default public void onBeforeContent(Response response, LongConsumer longConsumer) {
            longConsumer.accept(1L);
        }

        public void onContent(Response var1, LongConsumer var2, ByteBuffer var3, Callback var4);
    }

    public static interface AsyncContentListener
    extends DemandedContentListener {
        public void onContent(Response var1, ByteBuffer var2, Callback var3);

        @Override
        default public void onContent(Response response, LongConsumer longConsumer, ByteBuffer byteBuffer, Callback callback) {
            this.onContent(response, byteBuffer, Callback.from(() -> {
                callback.succeeded();
                longConsumer.accept(1L);
            }, callback::failed));
        }
    }

    public static interface ContentListener
    extends AsyncContentListener {
        public void onContent(Response var1, ByteBuffer var2);

        @Override
        default public void onContent(Response response, ByteBuffer byteBuffer, Callback callback) {
            try {
                this.onContent(response, byteBuffer);
                callback.succeeded();
            }
            catch (Throwable throwable) {
                callback.failed(throwable);
            }
        }
    }

    public static interface HeadersListener
    extends ResponseListener {
        public void onHeaders(Response var1);
    }

    public static interface HeaderListener
    extends ResponseListener {
        public boolean onHeader(Response var1, HttpField var2);
    }

    public static interface BeginListener
    extends ResponseListener {
        public void onBegin(Response var1);
    }

    public static interface ResponseListener
    extends EventListener {
    }
}

