/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth;

import com.gradle.maven.extension.internal.dep.org.apache.http.Consts;
import com.gradle.maven.extension.internal.dep.org.apache.http.HeaderElement;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.MalformedChallengeException;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.AuthSchemeBase;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.BasicHeaderValueParser;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.ParserCursor;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.CharArrayBuffer;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class RFC2617Scheme
extends AuthSchemeBase
implements Serializable {
    private final Map<String, String> params = new HashMap<String, String>();
    private transient Charset credentialsCharset;

    public RFC2617Scheme(Charset charset) {
        this.credentialsCharset = charset != null ? charset : Consts.ASCII;
    }

    public Charset getCredentialsCharset() {
        return this.credentialsCharset != null ? this.credentialsCharset : Consts.ASCII;
    }

    String getCredentialsCharset(HttpRequest httpRequest) {
        String string = (String)httpRequest.getParams().getParameter("http.auth.credential-charset");
        if (string == null) {
            string = this.getCredentialsCharset().name();
        }
        return string;
    }

    @Override
    protected void parseChallenge(CharArrayBuffer charArrayBuffer, int n2, int n3) throws MalformedChallengeException {
        BasicHeaderValueParser basicHeaderValueParser = BasicHeaderValueParser.INSTANCE;
        ParserCursor parserCursor = new ParserCursor(n2, charArrayBuffer.length());
        HeaderElement[] headerElementArray = basicHeaderValueParser.parseElements(charArrayBuffer, parserCursor);
        this.params.clear();
        for (HeaderElement headerElement : headerElementArray) {
            this.params.put(headerElement.getName().toLowerCase(Locale.ROOT), headerElement.getValue());
        }
    }

    protected Map<String, String> getParameters() {
        return this.params;
    }

    public String getParameter(String string) {
        if (string == null) {
            return null;
        }
        return this.params.get(string.toLowerCase(Locale.ROOT));
    }

    @Override
    public String getRealm() {
        return this.getParameter("realm");
    }
}

