/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io;

import java.io.File;
import java.util.regex.Pattern;

public class FilenameUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String EXTENSION_SEPARATOR_STR = Character.toString('.');
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = FilenameUtils.isSystemWindows() ? (char)47 : (char)92;
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
    private static final Pattern REG_NAME_PART_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9-]*$");

    static boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    public static int indexOfLastSeparator(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(92);
        return Math.max(n2, n3);
    }

    public static int indexOfExtension(String string) throws IllegalArgumentException {
        int n2;
        if (string == null) {
            return -1;
        }
        if (FilenameUtils.isSystemWindows() && (n2 = string.indexOf(58, FilenameUtils.getAdsCriticalOffset(string))) != -1) {
            throw new IllegalArgumentException("NTFS ADS separator (':') in file name is forbidden.");
        }
        n2 = string.lastIndexOf(46);
        int n3 = FilenameUtils.indexOfLastSeparator(string);
        return n3 > n2 ? -1 : n2;
    }

    public static String getExtension(String string) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfExtension(string);
        if (n2 == -1) {
            return "";
        }
        return string.substring(n2 + 1);
    }

    private static int getAdsCriticalOffset(String string) {
        int n2 = string.lastIndexOf(SYSTEM_SEPARATOR);
        int n3 = string.lastIndexOf(OTHER_SEPARATOR);
        if (n2 == -1) {
            if (n3 == -1) {
                return 0;
            }
            return n3 + 1;
        }
        if (n3 == -1) {
            return n2 + 1;
        }
        return Math.max(n2, n3) + 1;
    }
}

