/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi;

import com.gradle.maven.extension.internal.dep.net.rubygrapefruit.ansi.TextColor;

public class TextAttributes {
    private final boolean bold;
    private final TextColor color;
    private final TextColor background;
    public static final TextAttributes NORMAL = new TextAttributes(false, TextColor.DEFAULT, TextColor.DEFAULT);
    public static final TextAttributes BOLD = new TextAttributes(true, TextColor.DEFAULT, TextColor.DEFAULT);

    private TextAttributes(boolean bl2, TextColor textColor, TextColor textColor2) {
        this.bold = bl2;
        this.color = textColor;
        this.background = textColor2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        TextAttributes textAttributes = (TextAttributes)object;
        return textAttributes.bold == this.bold && textAttributes.color.equals(this.color) && textAttributes.background.equals(this.background);
    }

    public int hashCode() {
        return this.color.hashCode() ^ this.background.hashCode() ^ (this.bold ? 31 : 1);
    }

    public boolean isBold() {
        return this.bold;
    }

    public TextColor getColor() {
        return this.color;
    }

    public TextAttributes boldOn() {
        if (this.bold) {
            return this;
        }
        if (this.color.isDefault() && this.background.isDefault()) {
            return BOLD;
        }
        return new TextAttributes(true, this.color, this.background);
    }

    public TextAttributes boldOff() {
        if (!this.bold) {
            return this;
        }
        if (this.color.isDefault() && this.background.isDefault()) {
            return NORMAL;
        }
        return new TextAttributes(false, this.color, this.background);
    }

    public TextAttributes color(TextColor textColor) {
        if (this.color.equals(textColor)) {
            return this;
        }
        if (textColor.isDefault() && this.background.isDefault() && !this.bold) {
            return NORMAL;
        }
        return new TextAttributes(this.bold, textColor, this.background);
    }
}

