/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.primitives;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.primitives.DoublesMethodsForWeb;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.regex.Pattern;

public final class Doubles
extends DoublesMethodsForWeb {
    static final Pattern FLOATING_POINT_PATTERN = Doubles.fpPattern();

    public static int hashCode(double d2) {
        return Double.valueOf(d2).hashCode();
    }

    private static int indexOf(double[] dArray, double d2, int n2, int n3) {
        for (int i2 = n2; i2 < n3; ++i2) {
            if (dArray[i2] != d2) continue;
            return i2;
        }
        return -1;
    }

    private static int lastIndexOf(double[] dArray, double d2, int n2, int n3) {
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            if (dArray[i2] != d2) continue;
            return i2;
        }
        return -1;
    }

    public static List<Double> asList(double ... dArray) {
        if (dArray.length == 0) {
            return Collections.emptyList();
        }
        return new DoubleArrayAsList(dArray);
    }

    private static Pattern fpPattern() {
        String string = "(?:\\d+#(?:\\.\\d*#)?|\\.\\d+#)";
        String string2 = String.valueOf(string).concat("(?:[eE][+-]?\\d+#)?[fFdD]?");
        String string3 = "(?:[0-9a-fA-F]+#(?:\\.[0-9a-fA-F]*#)?|\\.[0-9a-fA-F]+#)";
        String string4 = new StringBuilder(25 + String.valueOf(string3).length()).append("0[xX]").append(string3).append("[pP][+-]?\\d+#[fFdD]?").toString();
        String string5 = new StringBuilder(23 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("[+-]?(?:NaN|Infinity|").append(string2).append("|").append(string4).append(")").toString();
        string5 = string5.replace("#", "+");
        return Pattern.compile(string5);
    }

    private static class DoubleArrayAsList
    extends AbstractList<Double>
    implements Serializable,
    RandomAccess {
        final double[] array;
        final int start;
        final int end;

        DoubleArrayAsList(double[] dArray) {
            this(dArray, 0, dArray.length);
        }

        DoubleArrayAsList(double[] dArray, int n2, int n3) {
            this.array = dArray;
            this.start = n2;
            this.end = n3;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Double get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.array[this.start + n2];
        }

        public Spliterator.OfDouble spliterator() {
            return Spliterators.spliterator(this.array, this.start, this.end, 0);
        }

        @Override
        public boolean contains(Object object) {
            return object instanceof Double && Doubles.indexOf(this.array, (Double)object, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object object) {
            int n2;
            if (object instanceof Double && (n2 = Doubles.indexOf(this.array, (Double)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            int n2;
            if (object instanceof Double && (n2 = Doubles.lastIndexOf(this.array, (Double)object, this.start, this.end)) >= 0) {
                return n2 - this.start;
            }
            return -1;
        }

        @Override
        public Double set(int n2, Double d2) {
            Preconditions.checkElementIndex(n2, this.size());
            double d3 = this.array[this.start + n2];
            this.array[this.start + n2] = Preconditions.checkNotNull(d2);
            return d3;
        }

        @Override
        public List<Double> subList(int n2, int n3) {
            int n4 = this.size();
            Preconditions.checkPositionIndexes(n2, n3, n4);
            if (n2 == n3) {
                return Collections.emptyList();
            }
            return new DoubleArrayAsList(this.array, this.start + n2, this.start + n3);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof DoubleArrayAsList) {
                DoubleArrayAsList doubleArrayAsList = (DoubleArrayAsList)object;
                int n2 = this.size();
                if (doubleArrayAsList.size() != n2) {
                    return false;
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (this.array[this.start + i2] == doubleArrayAsList.array[doubleArrayAsList.start + i2]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2 = 1;
            for (int i2 = this.start; i2 < this.end; ++i2) {
                n2 = 31 * n2 + Doubles.hashCode(this.array[i2]);
            }
            return n2;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.size() * 12);
            stringBuilder.append('[').append(this.array[this.start]);
            for (int i2 = this.start + 1; i2 < this.end; ++i2) {
                stringBuilder.append(", ").append(this.array[i2]);
            }
            return stringBuilder.append(']').toString();
        }
    }
}

