/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSortedAsList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSortedSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Multiset;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Ordering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.SortedIterables;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

final class RegularImmutableSortedSet<E>
extends ImmutableSortedSet<E> {
    static final RegularImmutableSortedSet<Comparable> NATURAL_EMPTY_SET = new RegularImmutableSortedSet(ImmutableList.of(), Ordering.natural());
    private final transient ImmutableList<E> elements;

    RegularImmutableSortedSet(ImmutableList<E> immutableList, Comparator<? super E> comparator) {
        super(comparator);
        this.elements = immutableList;
    }

    @Override
    Object[] internalArray() {
        return this.elements.internalArray();
    }

    @Override
    int internalArrayStart() {
        return this.elements.internalArrayStart();
    }

    @Override
    int internalArrayEnd() {
        return this.elements.internalArrayEnd();
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public UnmodifiableIterator<E> descendingIterator() {
        return this.elements.reverse().iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.asList().spliterator();
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        this.elements.forEach(consumer);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean contains(Object object) {
        try {
            return object != null && this.unsafeBinarySearch(object) >= 0;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof Multiset) {
            collection = ((Multiset)collection).elementSet();
        }
        if (!SortedIterables.hasSameComparator(this.comparator(), collection) || collection.size() <= 1) {
            return super.containsAll(collection);
        }
        Iterator iterator = this.iterator();
        Iterator<?> iterator2 = collection.iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        Object obj = iterator2.next();
        Object e2 = iterator.next();
        try {
            while (true) {
                int n2;
                if ((n2 = this.unsafeCompare(e2, obj)) < 0) {
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    e2 = iterator.next();
                    continue;
                }
                if (n2 == 0) {
                    if (!iterator2.hasNext()) {
                        return true;
                    }
                    obj = iterator2.next();
                    continue;
                }
                if (n2 > 0) break;
            }
            return false;
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    private int unsafeBinarySearch(Object object) throws ClassCastException {
        return Collections.binarySearch(this.elements, object, this.unsafeComparator());
    }

    @Override
    boolean isPartialView() {
        return this.elements.isPartialView();
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n2) {
        return this.elements.copyIntoArray(objectArray, n2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (this.size() != set.size()) {
            return false;
        }
        if (this.isEmpty()) {
            return true;
        }
        if (SortedIterables.hasSameComparator(this.comparator, set)) {
            Iterator iterator = set.iterator();
            try {
                for (Object e2 : this) {
                    Object e3 = iterator.next();
                    if (e3 != null && this.unsafeCompare(e2, e3) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            catch (NoSuchElementException noSuchElementException) {
                return false;
            }
        }
        return this.containsAll(set);
    }

    @Override
    public E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements.get(0);
    }

    @Override
    public E last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements.get(this.size() - 1);
    }

    @Override
    public E lower(E e2) {
        int n2 = this.headIndex(e2, false) - 1;
        return n2 == -1 ? null : (E)this.elements.get(n2);
    }

    @Override
    public E floor(E e2) {
        int n2 = this.headIndex(e2, true) - 1;
        return n2 == -1 ? null : (E)this.elements.get(n2);
    }

    @Override
    public E ceiling(E e2) {
        int n2 = this.tailIndex(e2, true);
        return n2 == this.size() ? null : (E)this.elements.get(n2);
    }

    @Override
    public E higher(E e2) {
        int n2 = this.tailIndex(e2, false);
        return n2 == this.size() ? null : (E)this.elements.get(n2);
    }

    @Override
    ImmutableSortedSet<E> headSetImpl(E e2, boolean bl2) {
        return this.getSubSet(0, this.headIndex(e2, bl2));
    }

    int headIndex(E e2, boolean bl2) {
        int n2 = Collections.binarySearch(this.elements, Preconditions.checkNotNull(e2), this.comparator());
        if (n2 >= 0) {
            return bl2 ? n2 + 1 : n2;
        }
        return ~n2;
    }

    @Override
    ImmutableSortedSet<E> subSetImpl(E e2, boolean bl2, E e3, boolean bl3) {
        return this.tailSetImpl(e2, bl2).headSetImpl(e3, bl3);
    }

    @Override
    ImmutableSortedSet<E> tailSetImpl(E e2, boolean bl2) {
        return this.getSubSet(this.tailIndex(e2, bl2), this.size());
    }

    int tailIndex(E e2, boolean bl2) {
        int n2 = Collections.binarySearch(this.elements, Preconditions.checkNotNull(e2), this.comparator());
        if (n2 >= 0) {
            return bl2 ? n2 : n2 + 1;
        }
        return ~n2;
    }

    Comparator<Object> unsafeComparator() {
        return this.comparator;
    }

    RegularImmutableSortedSet<E> getSubSet(int n2, int n3) {
        if (n2 == 0 && n3 == this.size()) {
            return this;
        }
        if (n2 < n3) {
            return new RegularImmutableSortedSet<E>(this.elements.subList(n2, n3), this.comparator);
        }
        return RegularImmutableSortedSet.emptySet(this.comparator);
    }

    @Override
    int indexOf(Object object) {
        int n2;
        if (object == null) {
            return -1;
        }
        try {
            n2 = Collections.binarySearch(this.elements, object, this.unsafeComparator());
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
        return n2 >= 0 ? n2 : -1;
    }

    @Override
    ImmutableList<E> createAsList() {
        return this.size() <= 1 ? this.elements : new ImmutableSortedAsList<E>(this, this.elements);
    }

    @Override
    ImmutableSortedSet<E> createDescendingSet() {
        Comparator comparator = Collections.reverseOrder(this.comparator);
        return this.isEmpty() ? RegularImmutableSortedSet.emptySet(comparator) : new RegularImmutableSortedSet<E>(this.elements.reverse(), comparator);
    }
}

