/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.base;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Optional;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public final class MoreObjects {
    public static <T> T firstNonNull(T t2, T t3) {
        if (t2 != null) {
            return t2;
        }
        if (t3 != null) {
            return t3;
        }
        throw new NullPointerException("Both parameters are null");
    }

    public static ToStringHelper toStringHelper(Object object) {
        return new ToStringHelper(object.getClass().getSimpleName());
    }

    public static ToStringHelper toStringHelper(String string) {
        return new ToStringHelper(string);
    }

    public static final class ToStringHelper {
        private final String className;
        private final ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;
        private boolean omitEmptyValues;

        private ToStringHelper(String string) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.omitEmptyValues = false;
            this.className = Preconditions.checkNotNull(string);
        }

        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        public ToStringHelper add(String string, Object object) {
            return this.addHolder(string, object);
        }

        public ToStringHelper add(String string, int n2) {
            return this.addUnconditionalHolder(string, String.valueOf(n2));
        }

        public ToStringHelper add(String string, long l2) {
            return this.addUnconditionalHolder(string, String.valueOf(l2));
        }

        public ToStringHelper addValue(Object object) {
            return this.addHolder(object);
        }

        private static boolean isEmpty(Object object) {
            if (object instanceof CharSequence) {
                return ((CharSequence)object).length() == 0;
            }
            if (object instanceof Collection) {
                return ((Collection)object).isEmpty();
            }
            if (object instanceof Map) {
                return ((Map)object).isEmpty();
            }
            if (object instanceof java.util.Optional) {
                return !((java.util.Optional)object).isPresent();
            }
            if (object instanceof OptionalInt) {
                return !((OptionalInt)object).isPresent();
            }
            if (object instanceof OptionalLong) {
                return !((OptionalLong)object).isPresent();
            }
            if (object instanceof OptionalDouble) {
                return !((OptionalDouble)object).isPresent();
            }
            if (object instanceof Optional) {
                return !((Optional)object).isPresent();
            }
            if (object.getClass().isArray()) {
                return Array.getLength(object) == 0;
            }
            return false;
        }

        public String toString() {
            boolean bl2 = this.omitNullValues;
            boolean bl3 = this.omitEmptyValues;
            String string = "";
            StringBuilder stringBuilder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                Object object = valueHolder.value;
                if (valueHolder instanceof UnconditionalValueHolder || (object == null ? !bl2 : !bl3 || !ToStringHelper.isEmpty(object))) {
                    stringBuilder.append(string);
                    string = ", ";
                    if (valueHolder.name != null) {
                        stringBuilder.append(valueHolder.name).append('=');
                    }
                    if (object != null && object.getClass().isArray()) {
                        Object[] objectArray = new Object[]{object};
                        String string2 = Arrays.deepToString(objectArray);
                        stringBuilder.append(string2, 1, string2.length() - 1);
                    } else {
                        stringBuilder.append(object);
                    }
                }
                valueHolder = valueHolder.next;
            }
            return stringBuilder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        private ToStringHelper addHolder(Object object) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = object;
            return this;
        }

        private ToStringHelper addHolder(String string, Object object) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = object;
            valueHolder.name = Preconditions.checkNotNull(string);
            return this;
        }

        private UnconditionalValueHolder addUnconditionalHolder() {
            UnconditionalValueHolder unconditionalValueHolder = new UnconditionalValueHolder();
            this.holderTail = this.holderTail.next = unconditionalValueHolder;
            return unconditionalValueHolder;
        }

        private ToStringHelper addUnconditionalHolder(String string, Object object) {
            UnconditionalValueHolder unconditionalValueHolder = this.addUnconditionalHolder();
            unconditionalValueHolder.value = object;
            unconditionalValueHolder.name = Preconditions.checkNotNull(string);
            return this;
        }

        private static final class UnconditionalValueHolder
        extends ValueHolder {
            private UnconditionalValueHolder() {
            }
        }

        private static class ValueHolder {
            String name;
            Object value;
            ValueHolder next;

            private ValueHolder() {
            }
        }
    }
}

