/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class OffsetTimeDeserializer
extends JSR310DateTimeDeserializerBase<OffsetTime> {
    public static final OffsetTimeDeserializer INSTANCE = new OffsetTimeDeserializer();

    protected OffsetTimeDeserializer() {
        this(DateTimeFormatter.ISO_OFFSET_TIME);
    }

    protected OffsetTimeDeserializer(DateTimeFormatter dateTimeFormatter) {
        super(OffsetTime.class, dateTimeFormatter);
    }

    protected OffsetTimeDeserializer(OffsetTimeDeserializer offsetTimeDeserializer, Boolean bl2) {
        super(offsetTimeDeserializer, bl2);
    }

    protected OffsetTimeDeserializer withDateFormat(DateTimeFormatter dateTimeFormatter) {
        return new OffsetTimeDeserializer(dateTimeFormatter);
    }

    protected OffsetTimeDeserializer withLeniency(Boolean bl2) {
        return new OffsetTimeDeserializer(this, bl2);
    }

    protected OffsetTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    @Override
    public OffsetTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType()));
        }
        if (!jsonParser.isExpectedStartArrayToken()) {
            if (jsonParser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
                return (OffsetTime)jsonParser.getEmbeddedObject();
            }
            if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                this._throwNoNumericTimestampNeedTimeZone(jsonParser, deserializationContext);
            }
            throw deserializationContext.wrongTokenException(jsonParser, this.handledType(), JsonToken.START_ARRAY, "Expected array or string.");
        }
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken != JsonToken.VALUE_NUMBER_INT) {
            if (jsonToken == JsonToken.END_ARRAY) {
                return null;
            }
            if ((jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                OffsetTime offsetTime = this.deserialize(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return offsetTime;
            }
            deserializationContext.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", new Object[]{jsonToken});
        }
        int n2 = jsonParser.getIntValue();
        int n3 = jsonParser.nextIntValue(-1);
        if (n3 == -1) {
            jsonToken = jsonParser.getCurrentToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                return null;
            }
            if (jsonToken != JsonToken.VALUE_NUMBER_INT) {
                this._reportWrongToken(deserializationContext, JsonToken.VALUE_NUMBER_INT, "minutes");
            }
            n3 = jsonParser.getIntValue();
        }
        int n4 = 0;
        int n5 = 0;
        if (jsonParser.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            n5 = jsonParser.getIntValue();
            if (jsonParser.nextToken() == JsonToken.VALUE_NUMBER_INT) {
                n4 = jsonParser.getIntValue();
                if (n4 < 1000 && !deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                    n4 *= 1000000;
                }
                jsonParser.nextToken();
            }
        }
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            OffsetTime offsetTime = OffsetTime.of(n2, n3, n5, n4, ZoneOffset.of(jsonParser.getText()));
            if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                this._reportWrongToken(deserializationContext, JsonToken.END_ARRAY, "timezone");
            }
            return offsetTime;
        }
        throw deserializationContext.wrongTokenException(jsonParser, this.handledType(), JsonToken.VALUE_STRING, "Expected string for TimeZone after numeric values");
    }

    protected OffsetTime _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (OffsetTime)this._fromEmptyString(jsonParser, deserializationContext, string2);
        }
        try {
            return OffsetTime.parse(string2, this._formatter);
        }
        catch (DateTimeException dateTimeException) {
            return (OffsetTime)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
    }
}

