/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileParser;
import java.io.IOException;
import java.io.InputStream;

public class SmileParserBootstrapper {
    protected final IOContext _context;
    protected final InputStream _in;
    protected final byte[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected final boolean _bufferRecyclable;
    protected int _inputProcessed;

    public SmileParserBootstrapper(IOContext iOContext, InputStream inputStream) {
        this._context = iOContext;
        this._in = inputStream;
        this._inputBuffer = iOContext.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._inputProcessed = 0;
        this._bufferRecyclable = true;
    }

    public SmileParserBootstrapper(IOContext iOContext, byte[] byArray, int n2, int n3) {
        this._context = iOContext;
        this._in = null;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n2 + n3;
        this._inputProcessed = -n2;
        this._bufferRecyclable = false;
    }

    public SmileParser constructParser(int n2, int n3, int n4, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer) throws IOException, JsonParseException {
        int n5;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = byteQuadsCanonicalizer.makeChildOrPlaceholder(n2);
        int n6 = this._inputEnd;
        if (this._inputPtr < n6 && this._in != null && (n5 = this._in.read(this._inputBuffer, n6, this._inputBuffer.length - n6)) > 0) {
            this._inputEnd += n5;
        }
        SmileParser smileParser = new SmileParser(this._context, n3, n4, objectCodec, byteQuadsCanonicalizer2, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._bufferRecyclable);
        boolean bl2 = false;
        if (this._inputPtr >= this._inputEnd) {
            return smileParser;
        }
        byte by2 = this._inputBuffer[this._inputPtr];
        if (by2 == 58) {
            bl2 = smileParser.handleSignature(true, true);
        }
        if (!bl2 && SmileParser.Feature.REQUIRE_HEADER.enabledIn(n4)) {
            String string = by2 == 123 || by2 == 91 ? "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(by2 & 0xFF) + ") -- rather, it starts with '" + (char)by2 + "' (plain JSON input?) -- can not parse" : "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(by2 & 0xFF) + ") and parser has REQUIRE_HEADER enabled: can not parse";
            throw new JsonParseException(smileParser, string);
        }
        return smileParser;
    }
}

