/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonEncoding;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerationException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileParserBootstrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class SmileFactory
extends JsonFactory {
    static final int DEFAULT_SMILE_PARSER_FEATURE_FLAGS = SmileParser.Feature.collectDefaults();
    static final int DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS = SmileGenerator.Feature.collectDefaults();
    protected boolean _cfgDelegateToTextual;
    protected int _smileParserFeatures = DEFAULT_SMILE_PARSER_FEATURE_FLAGS;
    protected int _smileGeneratorFeatures = DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS;

    public SmileFactory() {
        this(null);
    }

    public SmileFactory(ObjectCodec objectCodec) {
        super(objectCodec);
    }

    @Override
    public String getFormatName() {
        return "Smile";
    }

    @Override
    public boolean canUseCharArrays() {
        return false;
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return true;
    }

    @Override
    public SmileParser createParser(InputStream inputStream) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(inputStream), false);
        return this._createParser(this._decorate(inputStream, iOContext), iOContext);
    }

    @Override
    public SmileParser createParser(byte[] byArray) throws IOException {
        return this.createParser(byArray, 0, byArray.length);
    }

    public SmileParser createParser(byte[] byArray, int n2, int n3) throws IOException {
        InputStream inputStream;
        IOContext iOContext = this._createContext(this._createContentReference(byArray, n2, n3), true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, n2, n3, iOContext);
    }

    @Override
    public SmileGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(outputStream), false);
        return this._createGenerator(this._decorate(outputStream, iOContext), iOContext);
    }

    @Override
    public SmileGenerator createGenerator(OutputStream outputStream) throws IOException {
        IOContext iOContext = this._createContext(this._createContentReference(outputStream), false);
        return this._createGenerator(this._decorate(outputStream, iOContext), iOContext);
    }

    @Override
    protected SmileParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException {
        SmileParserBootstrapper smileParserBootstrapper = new SmileParserBootstrapper(iOContext, inputStream);
        return smileParserBootstrapper.constructParser(this._factoryFeatures, this._parserFeatures, this._smileParserFeatures, this._objectCodec, this._byteSymbolCanonicalizer);
    }

    @Override
    protected JsonParser _createParser(Reader reader, IOContext iOContext) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createParser(reader, iOContext);
        }
        return (JsonParser)this._nonByteSource();
    }

    @Override
    protected JsonParser _createParser(char[] cArray, int n2, int n3, IOContext iOContext, boolean bl2) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createParser(cArray, n2, n3, iOContext, bl2);
        }
        return (JsonParser)this._nonByteSource();
    }

    @Override
    protected SmileParser _createParser(byte[] byArray, int n2, int n3, IOContext iOContext) throws IOException {
        return new SmileParserBootstrapper(iOContext, byArray, n2, n3).constructParser(this._factoryFeatures, this._parserFeatures, this._smileParserFeatures, this._objectCodec, this._byteSymbolCanonicalizer);
    }

    @Override
    protected JsonGenerator _createGenerator(Writer writer, IOContext iOContext) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createGenerator(writer, iOContext);
        }
        return (JsonGenerator)this._nonByteTarget();
    }

    @Override
    protected JsonGenerator _createUTF8Generator(OutputStream outputStream, IOContext iOContext) throws IOException {
        return this._createGenerator(outputStream, iOContext);
    }

    @Override
    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (this._cfgDelegateToTextual) {
            return super._createWriter(outputStream, jsonEncoding, iOContext);
        }
        return (Writer)this._nonByteTarget();
    }

    protected <T> T _nonByteSource() throws IOException {
        throw new UnsupportedOperationException("Can not create parser for character-based (not byte-based) source");
    }

    protected <T> T _nonByteTarget() throws IOException {
        throw new UnsupportedOperationException("Can not create generator for character-based (not byte-based) target");
    }

    protected SmileGenerator _createGenerator(OutputStream outputStream, IOContext iOContext) throws IOException {
        int n2 = this._smileGeneratorFeatures;
        SmileGenerator smileGenerator = new SmileGenerator(iOContext, this._generatorFeatures, n2, this._objectCodec, outputStream);
        if ((n2 & SmileGenerator.Feature.WRITE_HEADER.getMask()) != 0) {
            smileGenerator.writeHeader();
        } else {
            if ((n2 & SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES.getMask()) != 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but CHECK_SHARED_STRING_VALUES enabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or disable CHECK_SHARED_STRING_VALUES to resolve)", smileGenerator);
            }
            if ((n2 & SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT.getMask()) == 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but ENCODE_BINARY_AS_7BIT disabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or ENCODE_BINARY_AS_7BIT to resolve)", smileGenerator);
            }
        }
        return smileGenerator;
    }
}

