/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.impl;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;

public class BeanPropertyMap
implements Serializable,
Iterable<SettableBeanProperty> {
    protected final boolean _caseInsensitive;
    private int _hashMask;
    private int _size;
    private int _spillCount;
    private Object[] _hashArea;
    private final SettableBeanProperty[] _propsInOrder;
    private final Map<String, List<PropertyName>> _aliasDefs;
    private final Map<String, String> _aliasMapping;
    private final Locale _locale;

    public BeanPropertyMap(boolean bl2, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map, Locale locale) {
        this._caseInsensitive = bl2;
        this._propsInOrder = collection.toArray(new SettableBeanProperty[collection.size()]);
        this._aliasDefs = map;
        this._locale = locale;
        this._aliasMapping = this._buildAliasMapping(map, bl2, locale);
        this.init(collection);
    }

    private BeanPropertyMap(BeanPropertyMap beanPropertyMap, SettableBeanProperty settableBeanProperty, int n2, int n3) {
        this._caseInsensitive = beanPropertyMap._caseInsensitive;
        this._locale = beanPropertyMap._locale;
        this._hashMask = beanPropertyMap._hashMask;
        this._size = beanPropertyMap._size;
        this._spillCount = beanPropertyMap._spillCount;
        this._aliasDefs = beanPropertyMap._aliasDefs;
        this._aliasMapping = beanPropertyMap._aliasMapping;
        this._hashArea = Arrays.copyOf(beanPropertyMap._hashArea, beanPropertyMap._hashArea.length);
        this._propsInOrder = Arrays.copyOf(beanPropertyMap._propsInOrder, beanPropertyMap._propsInOrder.length);
        this._hashArea[n2] = settableBeanProperty;
        this._propsInOrder[n3] = settableBeanProperty;
    }

    private BeanPropertyMap(BeanPropertyMap beanPropertyMap, SettableBeanProperty settableBeanProperty, String string, int n2) {
        this._caseInsensitive = beanPropertyMap._caseInsensitive;
        this._locale = beanPropertyMap._locale;
        this._hashMask = beanPropertyMap._hashMask;
        this._size = beanPropertyMap._size;
        this._spillCount = beanPropertyMap._spillCount;
        this._aliasDefs = beanPropertyMap._aliasDefs;
        this._aliasMapping = beanPropertyMap._aliasMapping;
        this._hashArea = Arrays.copyOf(beanPropertyMap._hashArea, beanPropertyMap._hashArea.length);
        int n3 = beanPropertyMap._propsInOrder.length;
        this._propsInOrder = Arrays.copyOf(beanPropertyMap._propsInOrder, n3 + 1);
        this._propsInOrder[n3] = settableBeanProperty;
        int n4 = this._hashMask + 1;
        int n5 = n2 << 1;
        if (this._hashArea[n5] != null && this._hashArea[n5 = n4 + (n2 >> 1) << 1] != null) {
            n5 = (n4 + (n4 >> 1) << 1) + this._spillCount;
            this._spillCount += 2;
            if (n5 >= this._hashArea.length) {
                this._hashArea = Arrays.copyOf(this._hashArea, this._hashArea.length + 4);
            }
        }
        this._hashArea[n5] = string;
        this._hashArea[n5 + 1] = settableBeanProperty;
    }

    protected BeanPropertyMap(BeanPropertyMap beanPropertyMap, boolean bl2) {
        this._caseInsensitive = bl2;
        this._locale = beanPropertyMap._locale;
        this._aliasDefs = beanPropertyMap._aliasDefs;
        this._aliasMapping = beanPropertyMap._aliasMapping;
        this._propsInOrder = Arrays.copyOf(beanPropertyMap._propsInOrder, beanPropertyMap._propsInOrder.length);
        this.init(Arrays.asList(this._propsInOrder));
    }

    public BeanPropertyMap withCaseInsensitivity(boolean bl2) {
        if (this._caseInsensitive == bl2) {
            return this;
        }
        return new BeanPropertyMap(this, bl2);
    }

    protected void init(Collection<SettableBeanProperty> collection) {
        this._size = collection.size();
        int n2 = BeanPropertyMap.findSize(this._size);
        this._hashMask = n2 - 1;
        int n3 = (n2 + (n2 >> 1)) * 2;
        Object[] objectArray = new Object[n3];
        int n4 = 0;
        for (SettableBeanProperty settableBeanProperty : collection) {
            if (settableBeanProperty == null) continue;
            String string = this.getPropertyName(settableBeanProperty);
            int n5 = this._hashCode(string);
            int n6 = n5 << 1;
            if (objectArray[n6] != null && objectArray[n6 = n2 + (n5 >> 1) << 1] != null) {
                n6 = (n2 + (n2 >> 1) << 1) + n4;
                n4 += 2;
                if (n6 >= objectArray.length) {
                    objectArray = Arrays.copyOf(objectArray, objectArray.length + 4);
                }
            }
            objectArray[n6] = string;
            objectArray[n6 + 1] = settableBeanProperty;
        }
        this._hashArea = objectArray;
        this._spillCount = n4;
    }

    private static final int findSize(int n2) {
        int n3;
        if (n2 <= 5) {
            return 8;
        }
        if (n2 <= 12) {
            return 16;
        }
        int n4 = n2 + (n2 >> 2);
        for (n3 = 32; n3 < n4; n3 += n3) {
        }
        return n3;
    }

    public static BeanPropertyMap construct(MapperConfig<?> mapperConfig, Collection<SettableBeanProperty> collection, Map<String, List<PropertyName>> map, boolean bl2) {
        return new BeanPropertyMap(bl2, collection, map, mapperConfig.getLocale());
    }

    public BeanPropertyMap withProperty(SettableBeanProperty settableBeanProperty) {
        int n2;
        String string = this.getPropertyName(settableBeanProperty);
        int n3 = this._hashArea.length;
        for (n2 = 1; n2 < n3; n2 += 2) {
            SettableBeanProperty settableBeanProperty2 = (SettableBeanProperty)this._hashArea[n2];
            if (settableBeanProperty2 == null || !settableBeanProperty2.getName().equals(string)) continue;
            return new BeanPropertyMap(this, settableBeanProperty, n2, this._findFromOrdered(settableBeanProperty2));
        }
        n2 = this._hashCode(string);
        return new BeanPropertyMap(this, settableBeanProperty, string, n2);
    }

    public BeanPropertyMap assignIndexes() {
        int n2 = 0;
        int n3 = this._hashArea.length;
        for (int i2 = 1; i2 < n3; i2 += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this._hashArea[i2];
            if (settableBeanProperty == null) continue;
            settableBeanProperty.assignIndex(n2++);
        }
        return this;
    }

    public BeanPropertyMap renameAll(NameTransformer nameTransformer) {
        if (nameTransformer == null || nameTransformer == NameTransformer.NOP) {
            return this;
        }
        int n2 = this._propsInOrder.length;
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            SettableBeanProperty settableBeanProperty = this._propsInOrder[i2];
            if (settableBeanProperty == null) {
                arrayList.add(settableBeanProperty);
                continue;
            }
            arrayList.add(this._rename(settableBeanProperty, nameTransformer));
        }
        return new BeanPropertyMap(this._caseInsensitive, arrayList, this._aliasDefs, this._locale);
    }

    public BeanPropertyMap withoutProperties(Collection<String> collection, Collection<String> collection2) {
        if ((collection == null || collection.isEmpty()) && collection2 == null) {
            return this;
        }
        int n2 = this._propsInOrder.length;
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            SettableBeanProperty settableBeanProperty = this._propsInOrder[i2];
            if (settableBeanProperty == null || IgnorePropertiesUtil.shouldIgnore(settableBeanProperty.getName(), collection, collection2)) continue;
            arrayList.add(settableBeanProperty);
        }
        return new BeanPropertyMap(this._caseInsensitive, arrayList, this._aliasDefs, this._locale);
    }

    public void replace(SettableBeanProperty settableBeanProperty, SettableBeanProperty settableBeanProperty2) {
        int n2 = 1;
        int n3 = this._hashArea.length;
        while (true) {
            if (n2 >= n3) {
                throw new NoSuchElementException("No entry '" + settableBeanProperty.getName() + "' found, can't replace");
            }
            if (this._hashArea[n2] == settableBeanProperty) break;
            n2 += 2;
        }
        this._hashArea[n2] = settableBeanProperty2;
        this._propsInOrder[this._findFromOrdered((SettableBeanProperty)settableBeanProperty)] = settableBeanProperty2;
    }

    public void remove(SettableBeanProperty settableBeanProperty) {
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(this._size);
        String string = this.getPropertyName(settableBeanProperty);
        boolean bl2 = false;
        int n2 = this._hashArea.length;
        for (int i2 = 1; i2 < n2; i2 += 2) {
            SettableBeanProperty settableBeanProperty2 = (SettableBeanProperty)this._hashArea[i2];
            if (settableBeanProperty2 == null) continue;
            if (!bl2 && (bl2 = string.equals(this._hashArea[i2 - 1]))) {
                this._propsInOrder[this._findFromOrdered((SettableBeanProperty)settableBeanProperty2)] = null;
                continue;
            }
            arrayList.add(settableBeanProperty2);
        }
        if (!bl2) {
            throw new NoSuchElementException("No entry '" + settableBeanProperty.getName() + "' found, can't remove");
        }
        this.init(arrayList);
    }

    public int size() {
        return this._size;
    }

    public boolean isCaseInsensitive() {
        return this._caseInsensitive;
    }

    @Override
    public Iterator<SettableBeanProperty> iterator() {
        return this._properties().iterator();
    }

    private List<SettableBeanProperty> _properties() {
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(this._size);
        int n2 = this._hashArea.length;
        for (int i2 = 1; i2 < n2; i2 += 2) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)this._hashArea[i2];
            if (settableBeanProperty == null) continue;
            arrayList.add(settableBeanProperty);
        }
        return arrayList;
    }

    public SettableBeanProperty[] getPropertiesInInsertionOrder() {
        return this._propsInOrder;
    }

    protected final String getPropertyName(SettableBeanProperty settableBeanProperty) {
        return this._caseInsensitive ? settableBeanProperty.getName().toLowerCase(this._locale) : settableBeanProperty.getName();
    }

    public SettableBeanProperty find(String string) {
        int n2;
        int n3;
        Object object;
        if (string == null) {
            throw new IllegalArgumentException("Cannot pass null property name");
        }
        if (this._caseInsensitive) {
            string = string.toLowerCase(this._locale);
        }
        if ((object = this._hashArea[n3 = (n2 = string.hashCode() & this._hashMask) << 1]) == string || string.equals(object)) {
            return (SettableBeanProperty)this._hashArea[n3 + 1];
        }
        return this._find2(string, n2, object);
    }

    private final SettableBeanProperty _find2(String string, int n2, Object object) {
        if (object == null) {
            return this._findWithAlias(this._aliasMapping.get(string));
        }
        int n3 = this._hashMask + 1;
        int n4 = n3 + (n2 >> 1) << 1;
        object = this._hashArea[n4];
        if (string.equals(object)) {
            return (SettableBeanProperty)this._hashArea[n4 + 1];
        }
        if (object != null) {
            int n5;
            int n6 = n5 + this._spillCount;
            for (n5 = n3 + (n3 >> 1) << 1; n5 < n6; n5 += 2) {
                object = this._hashArea[n5];
                if (object != string && !string.equals(object)) continue;
                return (SettableBeanProperty)this._hashArea[n5 + 1];
            }
        }
        return this._findWithAlias(this._aliasMapping.get(string));
    }

    private SettableBeanProperty _findWithAlias(String string) {
        if (string == null) {
            return null;
        }
        int n2 = this._hashCode(string);
        int n3 = n2 << 1;
        Object object = this._hashArea[n3];
        if (string.equals(object)) {
            return (SettableBeanProperty)this._hashArea[n3 + 1];
        }
        if (object == null) {
            return null;
        }
        return this._find2ViaAlias(string, n2, object);
    }

    private SettableBeanProperty _find2ViaAlias(String string, int n2, Object object) {
        int n3 = this._hashMask + 1;
        int n4 = n3 + (n2 >> 1) << 1;
        object = this._hashArea[n4];
        if (string.equals(object)) {
            return (SettableBeanProperty)this._hashArea[n4 + 1];
        }
        if (object != null) {
            int n5;
            int n6 = n5 + this._spillCount;
            for (n5 = n3 + (n3 >> 1) << 1; n5 < n6; n5 += 2) {
                object = this._hashArea[n5];
                if (object != string && !string.equals(object)) continue;
                return (SettableBeanProperty)this._hashArea[n5 + 1];
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Properties=[");
        int n2 = 0;
        for (SettableBeanProperty settableBeanProperty : this) {
            if (n2++ > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(settableBeanProperty.getName());
            stringBuilder.append('(');
            stringBuilder.append(settableBeanProperty.getType());
            stringBuilder.append(')');
        }
        stringBuilder.append(']');
        if (!this._aliasDefs.isEmpty()) {
            stringBuilder.append("(aliases: ");
            stringBuilder.append(this._aliasDefs);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    protected SettableBeanProperty _rename(SettableBeanProperty settableBeanProperty, NameTransformer nameTransformer) {
        JsonDeserializer<Object> jsonDeserializer;
        if (settableBeanProperty == null) {
            return settableBeanProperty;
        }
        String string = nameTransformer.transform(settableBeanProperty.getName());
        JsonDeserializer<Object> jsonDeserializer2 = (settableBeanProperty = settableBeanProperty.withSimpleName(string)).getValueDeserializer();
        if (jsonDeserializer2 != null && (jsonDeserializer = jsonDeserializer2.unwrappingDeserializer(nameTransformer)) != jsonDeserializer2) {
            settableBeanProperty = settableBeanProperty.withValueDeserializer(jsonDeserializer);
        }
        return settableBeanProperty;
    }

    private final int _findFromOrdered(SettableBeanProperty settableBeanProperty) {
        int n2 = this._propsInOrder.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this._propsInOrder[i2] != settableBeanProperty) continue;
            return i2;
        }
        throw new IllegalStateException("Illegal state: property '" + settableBeanProperty.getName() + "' missing from _propsInOrder");
    }

    private final int _hashCode(String string) {
        return string.hashCode() & this._hashMask;
    }

    private Map<String, String> _buildAliasMapping(Map<String, List<PropertyName>> map, boolean bl2, Locale locale) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, List<PropertyName>> entry : map.entrySet()) {
            String string = entry.getKey();
            if (bl2) {
                string = string.toLowerCase(locale);
            }
            for (PropertyName propertyName : entry.getValue()) {
                String string2 = propertyName.getSimpleName();
                if (bl2) {
                    string2 = string2.toLowerCase(locale);
                }
                hashMap.put(string2, string);
            }
        }
        return hashMap;
    }
}

