/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Base64Variants;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.FormatSchema;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonEncoding;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.PrettyPrinter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.Version;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.exc.StreamReadException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.exc.StreamWriteException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.TypeReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DatabindException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.InjectableValues;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonDeserializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MappingJsonFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.Module;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectReader;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectWriter;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionConfigs;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.DatatypeFeatures;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.Deserializers;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.NamedType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.NullNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.Serializers;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.TypeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.TypeModifier;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.RootNameLookup;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectMapper
extends ObjectCodec
implements Serializable {
    protected static final AnnotationIntrospector DEFAULT_ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
    protected static final BaseSettings DEFAULT_BASE = new BaseSettings(null, DEFAULT_ANNOTATION_INTROSPECTOR, null, TypeFactory.defaultInstance(), null, StdDateFormat.instance, null, Locale.getDefault(), null, Base64Variants.getDefaultVariant(), LaissezFaireSubTypeValidator.instance, new DefaultAccessorNamingStrategy.Provider());
    protected final JsonFactory _jsonFactory;
    protected TypeFactory _typeFactory;
    protected InjectableValues _injectableValues;
    protected SubtypeResolver _subtypeResolver;
    protected final ConfigOverrides _configOverrides;
    protected final CoercionConfigs _coercionConfigs;
    protected SimpleMixInResolver _mixIns;
    protected SerializationConfig _serializationConfig;
    protected DefaultSerializerProvider _serializerProvider;
    protected SerializerFactory _serializerFactory;
    protected DeserializationConfig _deserializationConfig;
    protected DefaultDeserializationContext _deserializationContext;
    protected Set<Object> _registeredModuleTypes;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers = new ConcurrentHashMap(64, 0.6f, 2);

    public ObjectMapper() {
        this(null, null, null);
    }

    public ObjectMapper(JsonFactory jsonFactory) {
        this(jsonFactory, null, null);
    }

    public ObjectMapper(JsonFactory jsonFactory, DefaultSerializerProvider defaultSerializerProvider, DefaultDeserializationContext defaultDeserializationContext) {
        SimpleMixInResolver simpleMixInResolver;
        if (jsonFactory == null) {
            this._jsonFactory = new MappingJsonFactory(this);
        } else {
            this._jsonFactory = jsonFactory;
            if (jsonFactory.getCodec() == null) {
                this._jsonFactory.setCodec(this);
            }
        }
        this._subtypeResolver = new StdSubtypeResolver();
        RootNameLookup rootNameLookup = new RootNameLookup();
        this._typeFactory = TypeFactory.defaultInstance();
        this._mixIns = simpleMixInResolver = new SimpleMixInResolver(null);
        BaseSettings baseSettings = DEFAULT_BASE.withClassIntrospector(this.defaultClassIntrospector());
        this._configOverrides = new ConfigOverrides();
        this._coercionConfigs = new CoercionConfigs();
        this._serializationConfig = new SerializationConfig(baseSettings, this._subtypeResolver, simpleMixInResolver, rootNameLookup, this._configOverrides, DatatypeFeatures.defaultFeatures());
        this._deserializationConfig = new DeserializationConfig(baseSettings, this._subtypeResolver, simpleMixInResolver, rootNameLookup, this._configOverrides, this._coercionConfigs, DatatypeFeatures.defaultFeatures());
        boolean bl2 = this._jsonFactory.requiresPropertyOrdering();
        if (bl2 ^ this._serializationConfig.isEnabled(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY)) {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, bl2);
        }
        this._serializerProvider = defaultSerializerProvider == null ? new DefaultSerializerProvider.Impl() : defaultSerializerProvider;
        this._deserializationContext = defaultDeserializationContext == null ? new DefaultDeserializationContext.Impl(BeanDeserializerFactory.instance) : defaultDeserializationContext;
        this._serializerFactory = BeanSerializerFactory.instance;
    }

    protected ClassIntrospector defaultClassIntrospector() {
        return new BasicClassIntrospector();
    }

    protected ObjectReader _newReader(DeserializationConfig deserializationConfig) {
        return new ObjectReader(this, deserializationConfig);
    }

    protected ObjectReader _newReader(DeserializationConfig deserializationConfig, JavaType javaType, Object object, FormatSchema formatSchema, InjectableValues injectableValues) {
        return new ObjectReader(this, deserializationConfig, javaType, object, formatSchema, injectableValues);
    }

    protected ObjectWriter _newWriter(SerializationConfig serializationConfig) {
        return new ObjectWriter(this, serializationConfig);
    }

    protected ObjectWriter _newWriter(SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter) {
        return new ObjectWriter(this, serializationConfig, javaType, prettyPrinter);
    }

    public ObjectMapper registerModule(Module module) {
        this._assertNotNull("module", module);
        String string = module.getModuleName();
        if (string == null) {
            throw new IllegalArgumentException("Module without defined name");
        }
        Version version = module.version();
        if (version == null) {
            throw new IllegalArgumentException("Module without defined version");
        }
        Object object = module.getDependencies().iterator();
        while (object.hasNext()) {
            Module module2 = object.next();
            this.registerModule(module2);
        }
        if (this.isEnabled(MapperFeature.IGNORE_DUPLICATE_MODULE_REGISTRATIONS) && (object = module.getTypeId()) != null) {
            if (this._registeredModuleTypes == null) {
                this._registeredModuleTypes = new LinkedHashSet<Object>();
            }
            if (!this._registeredModuleTypes.add(object)) {
                return this;
            }
        }
        module.setupModule(new Module.SetupContext(){

            @Override
            public void addDeserializers(Deserializers deserializers) {
                DeserializerFactory deserializerFactory = ObjectMapper.this._deserializationContext._factory.withAdditionalDeserializers(deserializers);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void addKeyDeserializers(KeyDeserializers keyDeserializers) {
                DeserializerFactory deserializerFactory = ObjectMapper.this._deserializationContext._factory.withAdditionalKeyDeserializers(keyDeserializers);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void addBeanDeserializerModifier(BeanDeserializerModifier beanDeserializerModifier) {
                DeserializerFactory deserializerFactory = ObjectMapper.this._deserializationContext._factory.withDeserializerModifier(beanDeserializerModifier);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void addSerializers(Serializers serializers) {
                ObjectMapper.this._serializerFactory = ObjectMapper.this._serializerFactory.withAdditionalSerializers(serializers);
            }

            @Override
            public void addKeySerializers(Serializers serializers) {
                ObjectMapper.this._serializerFactory = ObjectMapper.this._serializerFactory.withAdditionalKeySerializers(serializers);
            }

            @Override
            public void addBeanSerializerModifier(BeanSerializerModifier beanSerializerModifier) {
                ObjectMapper.this._serializerFactory = ObjectMapper.this._serializerFactory.withSerializerModifier(beanSerializerModifier);
            }

            @Override
            public void addAbstractTypeResolver(AbstractTypeResolver abstractTypeResolver) {
                DeserializerFactory deserializerFactory = ObjectMapper.this._deserializationContext._factory.withAbstractTypeResolver(abstractTypeResolver);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void addTypeModifier(TypeModifier typeModifier) {
                TypeFactory typeFactory = ObjectMapper.this._typeFactory;
                typeFactory = typeFactory.withModifier(typeModifier);
                ObjectMapper.this.setTypeFactory(typeFactory);
            }

            @Override
            public void addValueInstantiators(ValueInstantiators valueInstantiators) {
                DeserializerFactory deserializerFactory = ObjectMapper.this._deserializationContext._factory.withValueInstantiators(valueInstantiators);
                ObjectMapper.this._deserializationContext = ObjectMapper.this._deserializationContext.with(deserializerFactory);
            }

            @Override
            public void registerSubtypes(NamedType ... namedTypeArray) {
                ObjectMapper.this.registerSubtypes(namedTypeArray);
            }

            @Override
            public void setMixInAnnotations(Class<?> clazz, Class<?> clazz2) {
                ObjectMapper.this.addMixIn(clazz, clazz2);
            }

            @Override
            public void setNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
                ObjectMapper.this.setPropertyNamingStrategy(propertyNamingStrategy);
            }
        });
        return this;
    }

    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        this._assertNotNull("out", outputStream);
        JsonGenerator jsonGenerator = this._jsonFactory.createGenerator(outputStream, jsonEncoding);
        this._serializationConfig.initialize(jsonGenerator);
        return jsonGenerator;
    }

    public SerializationConfig getSerializationConfig() {
        return this._serializationConfig;
    }

    public DeserializationConfig getDeserializationConfig() {
        return this._deserializationConfig;
    }

    public ObjectMapper addMixIn(Class<?> clazz, Class<?> clazz2) {
        this._mixIns.addLocalDefinition(clazz, clazz2);
        return this;
    }

    public SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    public ObjectMapper setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(propertyNamingStrategy);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(propertyNamingStrategy);
        return this;
    }

    public ObjectMapper setSerializationInclusion(JsonInclude.Include include) {
        this.setPropertyInclusion(JsonInclude.Value.construct(include, include));
        return this;
    }

    @Deprecated
    public ObjectMapper setPropertyInclusion(JsonInclude.Value value) {
        return this.setDefaultPropertyInclusion(value);
    }

    public ObjectMapper setDefaultPropertyInclusion(JsonInclude.Value value) {
        this._configOverrides.setDefaultInclusion(value);
        return this;
    }

    public void registerSubtypes(NamedType ... namedTypeArray) {
        this.getSubtypeResolver().registerSubtypes(namedTypeArray);
    }

    public ObjectMapper setTypeFactory(TypeFactory typeFactory) {
        this._typeFactory = typeFactory;
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(typeFactory);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(typeFactory);
        return this;
    }

    public JavaType constructType(Type type) {
        this._assertNotNull("t", type);
        return this._typeFactory.constructType(type);
    }

    @Override
    public JsonFactory getFactory() {
        return this._jsonFactory;
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._serializationConfig.isEnabled(mapperFeature);
    }

    @Deprecated
    public ObjectMapper configure(MapperFeature mapperFeature, boolean bl2) {
        this._serializationConfig = bl2 ? (SerializationConfig)this._serializationConfig.with(mapperFeature) : (SerializationConfig)this._serializationConfig.without(mapperFeature);
        this._deserializationConfig = bl2 ? (DeserializationConfig)this._deserializationConfig.with(mapperFeature) : (DeserializationConfig)this._deserializationConfig.without(mapperFeature);
        return this;
    }

    public ObjectMapper configure(SerializationFeature serializationFeature, boolean bl2) {
        this._serializationConfig = bl2 ? this._serializationConfig.with(serializationFeature) : this._serializationConfig.without(serializationFeature);
        return this;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature) {
        this._serializationConfig = this._serializationConfig.with(serializationFeature);
        return this;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature) {
        this._serializationConfig = this._serializationConfig.without(serializationFeature);
        return this;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature) {
        this._deserializationConfig = this._deserializationConfig.without(deserializationFeature);
        return this;
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("p", jsonParser);
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(clazz));
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, TypeReference<T> typeReference) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("p", jsonParser);
        return (T)this._readValue(this.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(typeReference));
    }

    public JsonNode readTree(InputStream inputStream) throws IOException {
        this._assertNotNull("in", inputStream);
        return this._readTreeAndClose(this._jsonFactory.createParser(inputStream));
    }

    @Override
    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException, StreamWriteException, DatabindException {
        this._assertNotNull("g", jsonGenerator);
        SerializationConfig serializationConfig = this.getSerializationConfig();
        if (serializationConfig.isEnabled(SerializationFeature.INDENT_OUTPUT) && jsonGenerator.getPrettyPrinter() == null) {
            jsonGenerator.setPrettyPrinter(serializationConfig.constructDefaultPrettyPrinter());
        }
        if (serializationConfig.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseableValue(jsonGenerator, object, serializationConfig);
        } else {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
    }

    public <T> T readValue(Reader reader, Class<T> clazz) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", reader);
        return (T)this._readMapAndClose(this._jsonFactory.createParser(reader), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, Class<T> clazz) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", byArray);
        return (T)this._readMapAndClose(this._jsonFactory.createParser(byArray), this._typeFactory.constructType(clazz));
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException, StreamWriteException, DatabindException {
        this._writeValueAndClose(this.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public ObjectWriter writer() {
        return this._newWriter(this.getSerializationConfig());
    }

    public ObjectWriter writerFor(Class<?> clazz) {
        return this._newWriter(this.getSerializationConfig(), clazz == null ? null : this._typeFactory.constructType(clazz), null);
    }

    public ObjectWriter writerWithDefaultPrettyPrinter() {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        return this._newWriter(serializationConfig, null, serializationConfig.getDefaultPrettyPrinter());
    }

    public ObjectReader reader() {
        return this._newReader(this.getDeserializationConfig()).with(this._injectableValues);
    }

    public ObjectReader readerFor(Class<?> clazz) {
        JavaType javaType = clazz == null ? null : this._typeFactory.constructType(clazz);
        return this._newReader(this.getDeserializationConfig(), javaType, null, null, this._injectableValues);
    }

    protected DefaultSerializerProvider _serializerProvider(SerializationConfig serializationConfig) {
        return this._serializerProvider.createInstance(serializationConfig, this._serializerFactory);
    }

    protected final void _writeValueAndClose(JsonGenerator jsonGenerator, Object object) throws IOException {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        if (serializationConfig.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseable(jsonGenerator, object, serializationConfig);
            return;
        }
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, exception);
            return;
        }
        jsonGenerator.close();
    }

    private final void _writeCloseable(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) throws IOException {
        Closeable closeable = (Closeable)object;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            Closeable closeable2 = closeable;
            closeable = null;
            closeable2.close();
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, closeable, exception);
            return;
        }
        jsonGenerator.close();
    }

    private final void _writeCloseableValue(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) throws IOException {
        Closeable closeable = (Closeable)object;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(null, closeable, exception);
            return;
        }
        closeable.close();
    }

    protected Object _readValue(DeserializationConfig deserializationConfig, JsonParser jsonParser, JavaType javaType) throws IOException {
        JsonToken jsonToken = this._initForReading(jsonParser, javaType);
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
        Object object = jsonToken == JsonToken.VALUE_NULL ? this._findRootDeserializer(defaultDeserializationContext, javaType).getNullValue(defaultDeserializationContext) : (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT ? null : defaultDeserializationContext.readRootValue(jsonParser, javaType, this._findRootDeserializer(defaultDeserializationContext, javaType), null));
        jsonParser.clearCurrentToken();
        if (deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(jsonParser, defaultDeserializationContext, javaType);
        }
        return object;
    }

    protected Object _readMapAndClose(JsonParser jsonParser, JavaType javaType) throws IOException {
        try (JsonParser jsonParser2 = jsonParser;){
            Object object;
            DeserializationConfig deserializationConfig = this.getDeserializationConfig();
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser2, deserializationConfig);
            JsonToken jsonToken = this._initForReading(jsonParser2, javaType);
            if (jsonToken == JsonToken.VALUE_NULL) {
                object = this._findRootDeserializer(defaultDeserializationContext, javaType).getNullValue(defaultDeserializationContext);
            } else if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                object = null;
            } else {
                object = defaultDeserializationContext.readRootValue(jsonParser2, javaType, this._findRootDeserializer(defaultDeserializationContext, javaType), null);
                defaultDeserializationContext.checkUnresolvedObjectId();
            }
            if (deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(jsonParser2, defaultDeserializationContext, javaType);
            }
            Object object2 = object;
            return object2;
        }
    }

    protected JsonNode _readTreeAndClose(JsonParser jsonParser) throws IOException {
        try (JsonParser jsonParser2 = jsonParser;){
            JavaType javaType = this.constructType((Type)((Object)JsonNode.class));
            DeserializationConfig deserializationConfig = this.getDeserializationConfig();
            deserializationConfig.initialize(jsonParser2);
            JsonToken jsonToken = jsonParser2.currentToken();
            if (jsonToken == null && (jsonToken = jsonParser2.nextToken()) == null) {
                JsonNode jsonNode = deserializationConfig.getNodeFactory().missingNode();
                return jsonNode;
            }
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser2, deserializationConfig);
            JsonNode jsonNode = jsonToken == JsonToken.VALUE_NULL ? deserializationConfig.getNodeFactory().nullNode() : (JsonNode)defaultDeserializationContext.readRootValue(jsonParser2, javaType, this._findRootDeserializer(defaultDeserializationContext, javaType), null);
            if (deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(jsonParser2, defaultDeserializationContext, javaType);
            }
            NullNode nullNode = jsonNode;
            return nullNode;
        }
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser jsonParser, DeserializationConfig deserializationConfig) {
        return this._deserializationContext.createInstance(deserializationConfig, jsonParser, this._injectableValues);
    }

    protected JsonToken _initForReading(JsonParser jsonParser, JavaType javaType) throws IOException {
        this._deserializationConfig.initialize(jsonParser);
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            throw MismatchedInputException.from(jsonParser, javaType, "No content to map due to end-of-input");
        }
        return jsonToken;
    }

    protected final void _verifyNoTrailingTokens(JsonParser jsonParser, DeserializationContext deserializationContext, JavaType javaType) throws IOException {
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken != null) {
            Class<?> clazz = ClassUtil.rawClass(javaType);
            deserializationContext.reportTrailingTokens(clazz, jsonParser, jsonToken);
        }
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws DatabindException {
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            return (JsonDeserializer)deserializationContext.reportBadDefinition(javaType, "Cannot find a deserializer for type " + javaType);
        }
        this._rootDeserializers.put(javaType, jsonDeserializer);
        return jsonDeserializer;
    }

    protected final void _assertNotNull(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", string));
        }
    }
}

