/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Serializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Output;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util.Util;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public final class OptionalSerializers {
    public static void addDefaultSerializers(Kryo kryo) {
        if (Util.isClassAvailable("java.util.Optional")) {
            kryo.addDefaultSerializer(Optional.class, new OptionalSerializer());
        }
        if (Util.isClassAvailable("java.util.OptionalInt")) {
            kryo.addDefaultSerializer(OptionalInt.class, new OptionalIntSerializer());
        }
        if (Util.isClassAvailable("java.util.OptionalLong")) {
            kryo.addDefaultSerializer(OptionalLong.class, new OptionalLongSerializer());
        }
        if (Util.isClassAvailable("java.util.OptionalDouble")) {
            kryo.addDefaultSerializer(OptionalDouble.class, new OptionalDoubleSerializer());
        }
    }

    private static class OptionalDoubleSerializer
    extends Serializer<OptionalDouble> {
        private OptionalDoubleSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, OptionalDouble optionalDouble) {
            output.writeBoolean(optionalDouble.isPresent());
            if (optionalDouble.isPresent()) {
                output.writeDouble(optionalDouble.getAsDouble());
            }
        }

        @Override
        public OptionalDouble read(Kryo kryo, Input input, Class<OptionalDouble> clazz) {
            boolean bl2 = input.readBoolean();
            return bl2 ? OptionalDouble.of(input.readDouble()) : OptionalDouble.empty();
        }
    }

    private static class OptionalLongSerializer
    extends Serializer<OptionalLong> {
        private OptionalLongSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, OptionalLong optionalLong) {
            output.writeBoolean(optionalLong.isPresent());
            if (optionalLong.isPresent()) {
                output.writeLong(optionalLong.getAsLong());
            }
        }

        @Override
        public OptionalLong read(Kryo kryo, Input input, Class<OptionalLong> clazz) {
            boolean bl2 = input.readBoolean();
            return bl2 ? OptionalLong.of(input.readLong()) : OptionalLong.empty();
        }
    }

    private static class OptionalIntSerializer
    extends Serializer<OptionalInt> {
        private OptionalIntSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, OptionalInt optionalInt) {
            output.writeBoolean(optionalInt.isPresent());
            if (optionalInt.isPresent()) {
                output.writeInt(optionalInt.getAsInt());
            }
        }

        @Override
        public OptionalInt read(Kryo kryo, Input input, Class<OptionalInt> clazz) {
            boolean bl2 = input.readBoolean();
            return bl2 ? OptionalInt.of(input.readInt()) : OptionalInt.empty();
        }
    }

    private static class OptionalSerializer
    extends Serializer<Optional> {
        private OptionalSerializer() {
            this.setAcceptsNull(false);
        }

        @Override
        public void write(Kryo kryo, Output output, Optional optional) {
            Object var4_4 = optional.isPresent() ? optional.get() : null;
            kryo.writeClassAndObject(output, var4_4);
        }

        @Override
        public Optional read(Kryo kryo, Input input, Class<Optional> clazz) {
            return Optional.ofNullable(kryo.readClassAndObject(input));
        }

        @Override
        public Optional copy(Kryo kryo, Optional optional) {
            if (optional.isPresent()) {
                return Optional.of(kryo.copy(optional.get()));
            }
            return optional;
        }
    }
}

