/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.serializers;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Kryo;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.Serializer;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Input;
import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.io.Output;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;

public class MapSerializer
extends Serializer<Map> {
    private Class keyClass;
    private Class valueClass;
    private Serializer keySerializer;
    private Serializer valueSerializer;
    private boolean keysCanBeNull = true;
    private boolean valuesCanBeNull = true;
    private Class keyGenericType;
    private Class valueGenericType;

    public void setKeysCanBeNull(boolean bl2) {
        this.keysCanBeNull = bl2;
    }

    public void setKeyClass(Class clazz, Serializer serializer) {
        this.keyClass = clazz;
        this.keySerializer = serializer;
    }

    public void setValueClass(Class clazz, Serializer serializer) {
        this.valueClass = clazz;
        this.valueSerializer = serializer;
    }

    public void setValuesCanBeNull(boolean bl2) {
        this.valuesCanBeNull = bl2;
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] classArray) {
        this.keyGenericType = null;
        this.valueGenericType = null;
        if (classArray != null && classArray.length > 0) {
            if (classArray[0] != null && kryo.isFinal(classArray[0])) {
                this.keyGenericType = classArray[0];
            }
            if (classArray.length > 1 && classArray[1] != null && kryo.isFinal(classArray[1])) {
                this.valueGenericType = classArray[1];
            }
        }
    }

    @Override
    public void write(Kryo kryo, Output output, Map map) {
        int n2 = map.size();
        output.writeInt(n2, true);
        Serializer serializer = this.keySerializer;
        if (this.keyGenericType != null) {
            if (serializer == null) {
                serializer = kryo.getSerializer(this.keyGenericType);
            }
            this.keyGenericType = null;
        }
        Serializer serializer2 = this.valueSerializer;
        if (this.valueGenericType != null) {
            if (serializer2 == null) {
                serializer2 = kryo.getSerializer(this.valueGenericType);
            }
            this.valueGenericType = null;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (serializer != null) {
                if (this.keysCanBeNull) {
                    kryo.writeObjectOrNull(output, entry.getKey(), serializer);
                } else {
                    kryo.writeObject(output, entry.getKey(), serializer);
                }
            } else {
                kryo.writeClassAndObject(output, entry.getKey());
            }
            if (serializer2 != null) {
                if (this.valuesCanBeNull) {
                    kryo.writeObjectOrNull(output, entry.getValue(), serializer2);
                    continue;
                }
                kryo.writeObject(output, entry.getValue(), serializer2);
                continue;
            }
            kryo.writeClassAndObject(output, entry.getValue());
        }
    }

    protected Map create(Kryo kryo, Input input, Class<Map> clazz) {
        return kryo.newInstance(clazz);
    }

    @Override
    public Map read(Kryo kryo, Input input, Class<Map> clazz) {
        Map map = this.create(kryo, input, clazz);
        int n2 = input.readInt(true);
        Class clazz2 = this.keyClass;
        Class clazz3 = this.valueClass;
        Serializer serializer = this.keySerializer;
        if (this.keyGenericType != null) {
            clazz2 = this.keyGenericType;
            if (serializer == null) {
                serializer = kryo.getSerializer(clazz2);
            }
            this.keyGenericType = null;
        }
        Serializer serializer2 = this.valueSerializer;
        if (this.valueGenericType != null) {
            clazz3 = this.valueGenericType;
            if (serializer2 == null) {
                serializer2 = kryo.getSerializer(clazz3);
            }
            this.valueGenericType = null;
        }
        kryo.reference(map);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = serializer != null ? (this.keysCanBeNull ? kryo.readObjectOrNull(input, clazz2, serializer) : kryo.readObject(input, clazz2, serializer)) : kryo.readClassAndObject(input);
            Object object2 = serializer2 != null ? (this.valuesCanBeNull ? kryo.readObjectOrNull(input, clazz3, serializer2) : kryo.readObject(input, clazz3, serializer2)) : kryo.readClassAndObject(input);
            map.put(object, object2);
        }
        return map;
    }

    protected Map createCopy(Kryo kryo, Map map) {
        return (Map)kryo.newInstance(map.getClass());
    }

    @Override
    public Map copy(Kryo kryo, Map map) {
        Map map2 = this.createCopy(kryo, map);
        for (Map.Entry entry : map.entrySet()) {
            map2.put(kryo.copy(entry.getKey()), kryo.copy(entry.getValue()));
        }
        return map2;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface BindMap {
        public Class<? extends Serializer> keySerializer() default Serializer.class;

        public Class<? extends Serializer> valueSerializer() default Serializer.class;

        public Class<?> keyClass() default Object.class;

        public Class<?> valueClass() default Object.class;

        public boolean keysCanBeNull() default true;

        public boolean valuesCanBeNull() default true;
    }
}

