/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.kryo5.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectMap<K, V>
implements Iterable<Entry<K, V>> {
    static final Object dummy = new Object();
    public int size;
    K[] keyTable;
    V[] valueTable;
    float loadFactor;
    int threshold;
    protected int shift;
    protected int mask;

    public ObjectMap() {
        this(51, 0.8f);
    }

    public ObjectMap(int n2, float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and < 1: " + f2);
        }
        this.loadFactor = f2;
        int n3 = ObjectMap.tableSize(n2, f2);
        this.threshold = (int)((float)n3 * f2);
        this.mask = n3 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[n3];
        this.valueTable = new Object[n3];
    }

    protected int place(K k2) {
        return (int)((long)k2.hashCode() * -7046029254386353131L >>> this.shift);
    }

    int locateKey(K k2) {
        if (k2 == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] KArray = this.keyTable;
        int n2 = this.place(k2);
        K k3;
        while ((k3 = KArray[n2]) != null) {
            if (k3.equals(k2)) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return -(n2 + 1);
    }

    public V put(K k2, V v2) {
        int n2 = this.locateKey(k2);
        if (n2 >= 0) {
            V v3 = this.valueTable[n2];
            this.valueTable[n2] = v2;
            return v3;
        }
        n2 = -(n2 + 1);
        this.keyTable[n2] = k2;
        this.valueTable[n2] = v2;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    private void putResize(K k2, V v2) {
        K[] KArray = this.keyTable;
        int n2 = this.place(k2);
        while (true) {
            if (KArray[n2] == null) {
                KArray[n2] = k2;
                this.valueTable[n2] = v2;
                return;
            }
            n2 = n2 + 1 & this.mask;
        }
    }

    public <T extends K> V get(T t2) {
        int n2 = this.place(t2);
        K k2;
        while ((k2 = this.keyTable[n2]) != null) {
            if (k2.equals(t2)) {
                return this.valueTable[n2];
            }
            n2 = n2 + 1 & this.mask;
        }
        return null;
    }

    public V get(K k2, V v2) {
        int n2 = this.place(k2);
        K k3;
        while ((k3 = this.keyTable[n2]) != null) {
            if (k3.equals(k2)) {
                return this.valueTable[n2];
            }
            n2 = n2 + 1 & this.mask;
        }
        return v2;
    }

    public V remove(K k2) {
        int n2 = this.locateKey(k2);
        if (n2 < 0) {
            return null;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        V v2 = VArray[n2];
        int n3 = this.mask;
        int n4 = n2 + 1 & n3;
        while ((k2 = KArray[n4]) != null) {
            int n5 = this.place(k2);
            if ((n4 - n5 & n3) > (n2 - n5 & n3)) {
                KArray[n2] = k2;
                VArray[n2] = VArray[n4];
                n2 = n4;
            }
            n4 = n4 + 1 & n3;
        }
        KArray[n2] = null;
        VArray[n2] = null;
        --this.size;
        return v2;
    }

    public void clear(int n2) {
        int n3 = ObjectMap.tableSize(n2, this.loadFactor);
        if (this.keyTable.length <= n3) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n3);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
        Arrays.fill(this.valueTable, null);
    }

    public boolean containsKey(K k2) {
        return this.locateKey(k2) >= 0;
    }

    final void resize(int n2) {
        int n3 = this.keyTable.length;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new Object[n2];
        this.valueTable = new Object[n2];
        if (this.size > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                K k2 = KArray[i2];
                if (k2 == null) continue;
                this.putResize(k2, VArray[i2]);
            }
        }
    }

    public int hashCode() {
        int n2 = this.size;
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n3 = KArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            K k2 = KArray[i2];
            if (k2 == null) continue;
            n2 += k2.hashCode();
            V v2 = VArray[i2];
            if (v2 == null) continue;
            n2 += v2.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectMap)) {
            return false;
        }
        ObjectMap objectMap = (ObjectMap)object;
        if (objectMap.size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = KArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            V v2;
            K k2 = KArray[i2];
            if (k2 == null || !((v2 = VArray[i2]) == null ? objectMap.get(k2, dummy) != null : !v2.equals(objectMap.get(k2)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(", ", true);
    }

    private String toString(String string, boolean bl2) {
        V v2;
        K k2;
        if (this.size == 0) {
            return bl2 ? "{}" : "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        if (bl2) {
            stringBuilder.append('{');
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = KArray.length;
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append((Object)(k2 == this ? "(this)" : k2));
            stringBuilder.append('=');
            v2 = VArray[n2];
            stringBuilder.append((Object)(v2 == this ? "(this)" : v2));
            break;
        }
        while (n2-- > 0) {
            k2 = KArray[n2];
            if (k2 == null) continue;
            stringBuilder.append(string);
            stringBuilder.append((Object)(k2 == this ? "(this)" : k2));
            stringBuilder.append('=');
            v2 = VArray[n2];
            stringBuilder.append((Object)(v2 == this ? "(this)" : v2));
        }
        if (bl2) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public Entries<K, V> iterator() {
        return this.entries();
    }

    public Entries<K, V> entries() {
        return new Entries(this);
    }

    public static int tableSize(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("capacity must be >= 0: " + n2);
        }
        int n3 = ObjectMap.nextPowerOfTwo(Math.max(2, (int)Math.ceil((float)n2 / f2)));
        if (n3 > 0x40000000) {
            throw new IllegalArgumentException("The required capacity is too large: " + n2);
        }
        return n3;
    }

    public static int nextPowerOfTwo(int n2) {
        if (n2 == 0) {
            return 1;
        }
        --n2;
        n2 |= n2 >> 1;
        n2 |= n2 >> 2;
        n2 |= n2 >> 4;
        n2 |= n2 >> 8;
        n2 |= n2 >> 16;
        return n2 + 1;
    }

    public static class Entries<K, V>
    extends MapIterator<K, V, Entry<K, V>> {
        Entry<K, V> entry = new Entry();

        public Entries(ObjectMap<K, V> objectMap) {
            super(objectMap);
        }

        @Override
        public Entry<K, V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            K[] KArray = this.map.keyTable;
            this.entry.key = KArray[this.nextIndex];
            this.entry.value = this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        public Entries<K, V> iterator() {
            return this;
        }
    }

    private static abstract class MapIterator<K, V, I>
    implements Iterable<I>,
    Iterator<I> {
        public boolean hasNext;
        final ObjectMap<K, V> map;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public MapIterator(ObjectMap<K, V> objectMap) {
            this.map = objectMap;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            K[] KArray = this.map.keyTable;
            int n2 = KArray.length;
            while (++this.nextIndex < n2) {
                if (KArray[this.nextIndex] == null) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            Object k2;
            int n2 = this.currentIndex;
            if (n2 < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            K[] KArray = this.map.keyTable;
            V[] VArray = this.map.valueTable;
            int n3 = this.map.mask;
            int n4 = n2 + 1 & n3;
            while ((k2 = KArray[n4]) != null) {
                int n5 = this.map.place(k2);
                if ((n4 - n5 & n3) > (n2 - n5 & n3)) {
                    KArray[n2] = k2;
                    VArray[n2] = VArray[n4];
                    n2 = n4;
                }
                n4 = n4 + 1 & n3;
            }
            KArray[n2] = null;
            VArray[n2] = null;
            --this.map.size;
            if (n2 != this.currentIndex) {
                --this.nextIndex;
            }
            this.currentIndex = -1;
        }
    }

    public static class Entry<K, V> {
        public K key;
        public V value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

