package com.gradle.maven.extension.api.cache;

import java.time.Duration;

/**
 * Configures the cleanup policy of the local build cache.
 * <p>
 * The specified values will take precedence over the values defined in the {@code gradle-enterprise.xml}.
 *
 * @since 1.6.5
 */
public interface CleanupPolicy {

    /**
     * Gets whether the local build cache cleanup is enabled.
     *
     * @return {@code true} if the local build cache cleanup is enabled, {@code false} otherwise
     * @since 1.6.5
     */
    boolean isEnabled();

    /**
     * Sets whether to enable the local build cache cleanup.
     * <p>
     * Configuration via the {@code gradle.cache.local.cleanup.enabled} system property will always take precedence.
     *
     * @param enabled whether to enable the local build cache cleanup
     * @since 1.6.5
     */
    void setEnabled(boolean enabled);

    /**
     * Gets the local build cache retention period.
     *
     * @return the local build cache cleanup retention period
     * @since 1.6.5
     */
    Duration getRetentionPeriod();

    /**
     * Sets the local build cache cleanup retention period.
     * <p>
     * Configuration via the {@code gradle.cache.local.cleanup.retention} system property will always take precedence.
     *
     * @param retentionPeriod the local build cache cleanup retention period
     * @since 1.6.5
     */
    void setRetentionPeriod(Duration retentionPeriod);

    /**
     * Gets the local build cache cleanup interval.
     *
     * @return the local build cache cleanup interval
     * @since 1.6.5
     */
    Duration getCleanupInterval();

    /**
     * Sets the local build cache cleanup interval.
     * <p>
     * Configuration via the {@code gradle.cache.local.cleanup.interval} system property will always take precedence.
     *
     * @param cleanupInterval the local build cache cleanup interval
     * @since 1.6.5
     */
    void setCleanupInterval(Duration cleanupInterval);

}
