package com.gradle.maven.extension.api;

import com.gradle.nullability.Nullable;
import org.apache.maven.execution.MavenSession;

/**
 * Allows to interact with the Gradle Enterprise Maven extension.
 *
 * @since 1.11
 */
public interface GradleEnterpriseListener {

    /**
     * Allows configuring the Gradle Enterprise Maven extension via the Gradle Enterprise API. This callback is guaranteed to be taken into account by the Gradle Enterprise Maven extension,
     * even in case of catastrophic build failures, such as a very early unexpected exception.
     *
     * @param api     the Gradle Enterprise API
     * @param session the Maven session. Can be {@code null} in case of a very early error, before the Maven session is started
     * @since 1.11
     */
    void configure(GradleEnterpriseApi api, @Nullable MavenSession session) throws Exception;

}
