/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.ajax;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.ajax.attributes.ThrottlingSettings;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.value.LongValue;

public abstract class JQueryAjaxBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final IJQueryAjaxAware source;
    private final Duration duration;

    public JQueryAjaxBehavior(IJQueryAjaxAware source) {
        this(source, Duration.NONE);
    }

    public JQueryAjaxBehavior(IJQueryAjaxAware source, Duration duration) {
        this.source = source;
        this.duration = duration;
    }

    protected void respond(AjaxRequestTarget target) {
        if (this.source != null) {
            this.source.onAjax(target, this.newEvent());
        }
    }

    protected abstract JQueryEvent newEvent();

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        if (this.duration.compareTo((LongValue)Duration.NONE) > 0) {
            attributes.setThrottlingSettings(new ThrottlingSettings("jquery-throttle", this.duration));
        }
    }

    protected CallbackParameter[] getCallbackParameters() {
        return new CallbackParameter[0];
    }

    public String getCallbackFunction() {
        return super.getCallbackFunction(this.getCallbackParameters()).toString();
    }
}

