/* Generated By:JavaCC: Do not edit this line. QueryParser.java */
package com.google.visualization.datasource.query.parser;

import com.google.visualization.datasource.base.InvalidQueryException;
import com.google.visualization.datasource.datatable.value.BooleanValue;
import com.google.visualization.datasource.datatable.value.NumberValue;
import com.google.visualization.datasource.datatable.value.TextValue;
import com.google.visualization.datasource.datatable.value.Value;
import com.google.visualization.datasource.query.AbstractColumn;
import com.google.visualization.datasource.query.AggregationColumn;
import com.google.visualization.datasource.query.AggregationType;
import com.google.visualization.datasource.query.ColumnColumnFilter;
import com.google.visualization.datasource.query.ColumnIsNullFilter;
import com.google.visualization.datasource.query.ColumnValueFilter;
import com.google.visualization.datasource.query.ComparisonFilter;
import com.google.visualization.datasource.query.CompoundFilter;
import com.google.visualization.datasource.query.NegationFilter;
import com.google.visualization.datasource.query.Query;
import com.google.visualization.datasource.query.QueryFilter;
import com.google.visualization.datasource.query.QueryFormat;
import com.google.visualization.datasource.query.QueryGroup;
import com.google.visualization.datasource.query.QueryLabels;
import com.google.visualization.datasource.query.QueryOptions;
import com.google.visualization.datasource.query.QueryPivot;
import com.google.visualization.datasource.query.QuerySelection;
import com.google.visualization.datasource.query.QuerySort;
import com.google.visualization.datasource.query.ScalarFunctionColumn;
import com.google.visualization.datasource.query.SortOrder;
import com.google.visualization.datasource.query.SimpleColumn;
import com.google.visualization.datasource.query.scalarfunction.Constant;
import com.google.visualization.datasource.query.scalarfunction.CurrentDateTime;
import com.google.visualization.datasource.query.scalarfunction.DateDiff;
import com.google.visualization.datasource.query.scalarfunction.Difference;
import com.google.visualization.datasource.query.scalarfunction.Lower;
import com.google.visualization.datasource.query.scalarfunction.Product;
import com.google.visualization.datasource.query.scalarfunction.Quotient;
import com.google.visualization.datasource.query.scalarfunction.ScalarFunction;
import com.google.visualization.datasource.query.scalarfunction.Sum;
import com.google.visualization.datasource.query.scalarfunction.ToDate;
import com.google.visualization.datasource.query.scalarfunction.TimeComponentExtractor;
import com.google.visualization.datasource.query.scalarfunction.Upper;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

/**
 *  Query parser.  AUTOGENERATED, see QueryParser.jj
 */
public class QueryParser implements QueryParserConstants {

  public static Query parseString(String queryString)
      throws ParseException, InvalidQueryException {
    Reader r = new BufferedReader(new StringReader(queryString));
    QueryParser parser = new QueryParser(r);
    Query query = parser.queryStatement();
    return query;
  }

// The entire query
  final public Query queryStatement() throws ParseException, InvalidQueryException {
  Query query = new Query();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_SELECT:
      selectClause(query);
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_WHERE:
      whereClause(query);
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_GROUP:
      groupByClause(query);
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_PIVOT:
      pivotClause(query);
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_ORDER:
      orderByClause(query);
      break;
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_LIMIT:
      limitClause(query);
      break;
    default:
      jj_la1[5] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_OFFSET:
      offsetClause(query);
      break;
    default:
      jj_la1[6] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_LABEL:
      labelClause(query);
      break;
    default:
      jj_la1[7] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_FORMAT:
      formatClause(query);
      break;
    default:
      jj_la1[8] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_OPTIONS:
      optionsClause(query);
      break;
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    jj_consume_token(0);
   {if (true) return query;}
    throw new Error("Missing return statement in function");
  }

// The select clause (e.g., SELECT c1, c2)
  final public void selectClause(Query query) throws ParseException, InvalidQueryException {
  QuerySelection selection = new QuerySelection();
  AbstractColumn column;
    jj_consume_token(KW_SELECT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_TRUE:
    case KW_FALSE:
    case KW_DATE:
    case KW_TIMEOFDAY:
    case KW_DATETIME:
    case KW_TIMESTAMP:
    case KW_MIN:
    case KW_MAX:
    case KW_AVG:
    case KW_COUNT:
    case KW_SUM:
    case KW_NO_VALUES:
    case KW_NO_FORMAT:
    case KW_IS:
    case KW_NULL:
    case KW_YEAR:
    case KW_MONTH:
    case KW_DAY:
    case KW_HOUR:
    case KW_MINUTE:
    case KW_SECOND:
    case KW_MILLISECOND:
    case KW_WITH:
    case KW_CONTAINS:
    case KW_STARTS:
    case KW_ENDS:
    case KW_MATCHES:
    case KW_LIKE:
    case KW_NOW:
    case KW_DATEDIFF:
    case KW_QUARTER:
    case KW_LOWER:
    case KW_UPPER:
    case KW_DAYOFWEEK:
    case KW_TODATE:
    case ID:
    case INTEGER_LITERAL:
    case DECIMAL_LITERAL:
    case STRING_LITERAL:
    case QUOTED_ID:
    case OP_LPAREN:
    case OP_MINUS:
      column = abstractColumnDescriptor();
       selection.addColumn(column);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OP_COMMA:
          ;
          break;
        default:
          jj_la1[10] = jj_gen;
          break label_1;
        }
        jj_consume_token(OP_COMMA);
        column = abstractColumnDescriptor();
           selection.addColumn(column);
      }
       query.setSelection(selection);
      break;
    case OP_ASTERISK:
      jj_consume_token(OP_ASTERISK);
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

// The where clause (e.g., WHERE (c1 > 3) AND (NOT(c3 <= c4)))
  final public void whereClause(Query query) throws ParseException, InvalidQueryException {
  QueryFilter filter;
    jj_consume_token(KW_WHERE);
    filter = logicalExpression();
    query.setFilter(filter);
  }

// The group by clause (e.g. GROUP BY c1, c2)
  final public void groupByClause(Query query) throws ParseException, InvalidQueryException {
  QueryGroup group = new QueryGroup();
  AbstractColumn column;
    jj_consume_token(KW_GROUP);
    jj_consume_token(KW_BY);
    column = abstractColumnDescriptor();
    group.addColumn(column);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OP_COMMA:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_2;
      }
      jj_consume_token(OP_COMMA);
      column = abstractColumnDescriptor();
        group.addColumn(column);
    }
    query.setGroup(group);
  }

// The pivot clause (e.g. PIVOT c1, c2)
  final public void pivotClause(Query query) throws ParseException, InvalidQueryException {
  QueryPivot pivot = new QueryPivot();
  AbstractColumn column;
    jj_consume_token(KW_PIVOT);
    column = abstractColumnDescriptor();
    pivot.addColumn(column);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OP_COMMA:
        ;
        break;
      default:
        jj_la1[13] = jj_gen;
        break label_3;
      }
      jj_consume_token(OP_COMMA);
      column = abstractColumnDescriptor();
        pivot.addColumn(column);
    }
    query.setPivot(pivot);
  }

// The order by clause (e.g., ORDER BY c1, c2 ASC, c3 DESC)
  final public void orderByClause(Query query) throws ParseException, InvalidQueryException {
  QuerySort sort = new QuerySort();
  AbstractColumn column;
  SortOrder order;
    jj_consume_token(KW_ORDER);
    jj_consume_token(KW_BY);
    column = abstractColumnDescriptor();
    order = sortOrder();
    sort.addSort(column, order);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OP_COMMA:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_4;
      }
      jj_consume_token(OP_COMMA);
      column = abstractColumnDescriptor();
      order = sortOrder();
      sort.addSort(column, order);
    }
    query.setSort(sort);
  }

// The limit clause (e.g., LIMIT 100)
  final public void limitClause(Query query) throws ParseException, InvalidQueryException {
  int limit;
    jj_consume_token(KW_LIMIT);
    limit = integerLiteral();
    query.setRowLimit(limit);
  }

// The offset clause (e.g., OFFSET 100)
  final public void offsetClause(Query query) throws ParseException, InvalidQueryException {
  int offset;
    jj_consume_token(KW_OFFSET);
    offset = integerLiteral();
    query.setRowOffset(offset);
  }

// The label clause (e.g., LABEL c1 "Department", c3 "Salary")
  final public void labelClause(Query query) throws ParseException, InvalidQueryException {
  QueryLabels labels = new QueryLabels();
  AbstractColumn column;
  String label;
    jj_consume_token(KW_LABEL);
    column = abstractColumnDescriptor();
    label = stringLiteral();
    labels.addLabel(column, label);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OP_COMMA:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_5;
      }
      jj_consume_token(OP_COMMA);
      column = abstractColumnDescriptor();
      label = stringLiteral();
      labels.addLabel(column, label);
    }
    query.setLabels(labels);
  }

// The format clause (e.g., FORMAT c1 "#", c3 "dd-MM-YYYY")
  final public void formatClause(Query query) throws ParseException, InvalidQueryException {
  QueryFormat formats = new QueryFormat();
  AbstractColumn column;
  String pattern;
    jj_consume_token(KW_FORMAT);
    column = abstractColumnDescriptor();
    pattern = stringLiteral();
    formats.addPattern(column, pattern);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OP_COMMA:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_6;
      }
      jj_consume_token(OP_COMMA);
      column = abstractColumnDescriptor();
      pattern = stringLiteral();
      formats.addPattern(column, pattern);
    }
    query.setUserFormatOptions(formats);
  }

// The options clause (e.g., OPTIONS no_format)
  final public void optionsClause(Query query) throws ParseException {
  QueryOptions queryOptions = new QueryOptions();
  QueryOptionEnum optionEnum;
    jj_consume_token(KW_OPTIONS);
    label_7:
    while (true) {
      optionEnum = queryOption();
      optionEnum.setInQueryOptions(queryOptions);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_NO_VALUES:
      case KW_NO_FORMAT:
        ;
        break;
      default:
        jj_la1[17] = jj_gen;
        break label_7;
      }
    }
    query.setOptions(queryOptions);
  }

// a logical expression, e.g., c1 > c2 or not c1 < 3 and (c3 >= c4)
// currently implemented as simply a call to possibleOrExpression
  final public QueryFilter logicalExpression() throws ParseException, InvalidQueryException {
  QueryFilter filter;
    filter = possibleOrExpression();
      {if (true) return filter;}
    throw new Error("Missing return statement in function");
  }

// A possible OR expression, i.e., an OR of several possible AND expressions.
// It is "possible" because it can also match a single expression without any
// ORs and then it is just returned as is.
  final public QueryFilter possibleOrExpression() throws ParseException, InvalidQueryException {
  ArrayList subFilters = new ArrayList();
  QueryFilter filter;
    filter = possibleAndExpression();
      subFilters.add(filter);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_OR:
        ;
        break;
      default:
        jj_la1[18] = jj_gen;
        break label_8;
      }
      jj_consume_token(KW_OR);
      filter = possibleAndExpression();
                                                 subFilters.add(filter);
    }
      if (subFilters.size() == 1) {
        {if (true) return (QueryFilter)subFilters.get(0);}
      } else {
        {if (true) return new CompoundFilter(
            CompoundFilter.LogicalOperator.OR,
            GenericsHelper.makeTypedList(subFilters));}
      }
    throw new Error("Missing return statement in function");
  }

// A possible AND expression, i.e., an AND of several possible NOT expressions.
// It is "possible" because it can also match a single expression without any
// ANDs and then it is just returned as is.
  final public QueryFilter possibleAndExpression() throws ParseException, InvalidQueryException {
  ArrayList subFilters = new ArrayList();
  QueryFilter filter;
    filter = possibleNotExpression();
      subFilters.add(filter);
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_AND:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_9;
      }
      jj_consume_token(KW_AND);
      filter = possibleNotExpression();
                                                  subFilters.add(filter);
    }
    if (subFilters.size() == 1) {
      {if (true) return (QueryFilter)subFilters.get(0);}
    } else {
      {if (true) return new CompoundFilter(
          CompoundFilter.LogicalOperator.AND,
          GenericsHelper.makeTypedList(subFilters));}
    }
    throw new Error("Missing return statement in function");
  }

// A primary expression, with an optional NOT
  final public QueryFilter possibleNotExpression() throws ParseException, InvalidQueryException {
  QueryFilter subFilter;
  QueryFilter filter;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_NOT:
      jj_consume_token(KW_NOT);
      subFilter = primaryExpression();
        filter = new NegationFilter(subFilter);
      break;
    case KW_TRUE:
    case KW_FALSE:
    case KW_DATE:
    case KW_TIMEOFDAY:
    case KW_DATETIME:
    case KW_TIMESTAMP:
    case KW_MIN:
    case KW_MAX:
    case KW_AVG:
    case KW_COUNT:
    case KW_SUM:
    case KW_NO_VALUES:
    case KW_NO_FORMAT:
    case KW_IS:
    case KW_NULL:
    case KW_YEAR:
    case KW_MONTH:
    case KW_DAY:
    case KW_HOUR:
    case KW_MINUTE:
    case KW_SECOND:
    case KW_MILLISECOND:
    case KW_WITH:
    case KW_CONTAINS:
    case KW_STARTS:
    case KW_ENDS:
    case KW_MATCHES:
    case KW_LIKE:
    case KW_NOW:
    case KW_DATEDIFF:
    case KW_QUARTER:
    case KW_LOWER:
    case KW_UPPER:
    case KW_DAYOFWEEK:
    case KW_TODATE:
    case ID:
    case INTEGER_LITERAL:
    case DECIMAL_LITERAL:
    case STRING_LITERAL:
    case QUOTED_ID:
    case OP_LPAREN:
    case OP_MINUS:
      subFilter = primaryExpression();
        filter = subFilter;
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return filter;}
    throw new Error("Missing return statement in function");
  }

// A primary expression, i.e., a binary comparison operator between two operands
// or an expression in parentheses.
  final public QueryFilter primaryExpression() throws ParseException, InvalidQueryException {
  QueryFilter filter;
    if (jj_2_1(2147483647)) {
      filter = primitiveFilter();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OP_LPAREN:
        jj_consume_token(OP_LPAREN);
        filter = logicalExpression();
        jj_consume_token(OP_RPAREN);
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return filter;}
    throw new Error("Missing return statement in function");
  }

// A comparison expression, i.e., a binary comparison operator between two
// operands that may be literals or column ids. Or an IS NULL or IS NOT NULL.
  final public QueryFilter primitiveFilter() throws ParseException, InvalidQueryException {
  QueryFilter filter;
  AbstractColumn col1;
  AbstractColumn col2;
  ComparisonFilter.Operator op;
  Value val;
    if (jj_2_3(2147483647)) {
      val = literal();
      op = comparisonOperator();
      col1 = abstractColumnDescriptor();
      filter = new ColumnValueFilter(col1, val, op, true);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_TRUE:
      case KW_FALSE:
      case KW_DATE:
      case KW_TIMEOFDAY:
      case KW_DATETIME:
      case KW_TIMESTAMP:
      case KW_MIN:
      case KW_MAX:
      case KW_AVG:
      case KW_COUNT:
      case KW_SUM:
      case KW_NO_VALUES:
      case KW_NO_FORMAT:
      case KW_IS:
      case KW_NULL:
      case KW_YEAR:
      case KW_MONTH:
      case KW_DAY:
      case KW_HOUR:
      case KW_MINUTE:
      case KW_SECOND:
      case KW_MILLISECOND:
      case KW_WITH:
      case KW_CONTAINS:
      case KW_STARTS:
      case KW_ENDS:
      case KW_MATCHES:
      case KW_LIKE:
      case KW_NOW:
      case KW_DATEDIFF:
      case KW_QUARTER:
      case KW_LOWER:
      case KW_UPPER:
      case KW_DAYOFWEEK:
      case KW_TODATE:
      case ID:
      case INTEGER_LITERAL:
      case DECIMAL_LITERAL:
      case STRING_LITERAL:
      case QUOTED_ID:
      case OP_LPAREN:
      case OP_MINUS:
        col1 = abstractColumnDescriptor();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case KW_IS:
          jj_consume_token(KW_IS);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case KW_NULL:
            jj_consume_token(KW_NULL);
                filter = new ColumnIsNullFilter(col1);
            break;
          case KW_NOT:
            jj_consume_token(KW_NOT);
            jj_consume_token(KW_NULL);
                filter = new NegationFilter(new ColumnIsNullFilter(col1));
            break;
          default:
            jj_la1[22] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        case KW_CONTAINS:
        case KW_STARTS:
        case KW_ENDS:
        case KW_MATCHES:
        case KW_LIKE:
        case OP_EQUALS:
        case OP_NOT_EQUALS:
        case OP_LESS_THAN:
        case OP_LESS_OR_EQUAL:
        case OP_GREATER_THAN:
        case OP_GREATER_OR_EQUAL:
          op = comparisonOperator();
          if (jj_2_2(2147483647)) {
            val = literal();
              filter = new ColumnValueFilter(col1, val, op, false);
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case KW_TRUE:
            case KW_FALSE:
            case KW_DATE:
            case KW_TIMEOFDAY:
            case KW_DATETIME:
            case KW_TIMESTAMP:
            case KW_MIN:
            case KW_MAX:
            case KW_AVG:
            case KW_COUNT:
            case KW_SUM:
            case KW_NO_VALUES:
            case KW_NO_FORMAT:
            case KW_IS:
            case KW_NULL:
            case KW_YEAR:
            case KW_MONTH:
            case KW_DAY:
            case KW_HOUR:
            case KW_MINUTE:
            case KW_SECOND:
            case KW_MILLISECOND:
            case KW_WITH:
            case KW_CONTAINS:
            case KW_STARTS:
            case KW_ENDS:
            case KW_MATCHES:
            case KW_LIKE:
            case KW_NOW:
            case KW_DATEDIFF:
            case KW_QUARTER:
            case KW_LOWER:
            case KW_UPPER:
            case KW_DAYOFWEEK:
            case KW_TODATE:
            case ID:
            case INTEGER_LITERAL:
            case DECIMAL_LITERAL:
            case STRING_LITERAL:
            case QUOTED_ID:
            case OP_LPAREN:
            case OP_MINUS:
              col2 = abstractColumnDescriptor();
                filter = new ColumnColumnFilter(col1, col2, op);
              break;
            default:
              jj_la1[23] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
        default:
          jj_la1[24] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[25] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return filter;}
    throw new Error("Missing return statement in function");
  }

// A comparison operator, i.e., one of <, >, =, !=, <>, <=, >= and maybe others.
  final public ComparisonFilter.Operator comparisonOperator() throws ParseException {
  ComparisonFilter.Operator op;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OP_EQUALS:
      jj_consume_token(OP_EQUALS);
                   op = ComparisonFilter.Operator.EQ;
      break;
    case OP_NOT_EQUALS:
      jj_consume_token(OP_NOT_EQUALS);
                       op = ComparisonFilter.Operator.NE;
      break;
    case OP_LESS_THAN:
      jj_consume_token(OP_LESS_THAN);
                      op = ComparisonFilter.Operator.LT;
      break;
    case OP_LESS_OR_EQUAL:
      jj_consume_token(OP_LESS_OR_EQUAL);
                          op = ComparisonFilter.Operator.LE;
      break;
    case OP_GREATER_THAN:
      jj_consume_token(OP_GREATER_THAN);
                         op = ComparisonFilter.Operator.GT;
      break;
    case OP_GREATER_OR_EQUAL:
      jj_consume_token(OP_GREATER_OR_EQUAL);
                             op = ComparisonFilter.Operator.GE;
      break;
    case KW_CONTAINS:
      jj_consume_token(KW_CONTAINS);
                     op = ComparisonFilter.Operator.CONTAINS;
      break;
    case KW_STARTS:
      jj_consume_token(KW_STARTS);
      jj_consume_token(KW_WITH);
                             op = ComparisonFilter.Operator.STARTS_WITH;
      break;
    case KW_ENDS:
      jj_consume_token(KW_ENDS);
      jj_consume_token(KW_WITH);
                           op = ComparisonFilter.Operator.ENDS_WITH;
      break;
    case KW_MATCHES:
      jj_consume_token(KW_MATCHES);
                    op = ComparisonFilter.Operator.MATCHES;
      break;
    case KW_LIKE:
      jj_consume_token(KW_LIKE);
                 op = ComparisonFilter.Operator.LIKE;
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return op;}
    throw new Error("Missing return statement in function");
  }

// A literal. Corresponds to a value on the server, i.e., can be of one of the
// following types: string, number, boolean, date, timeOfDay, dateTime.
  final public Value literal() throws ParseException, InvalidQueryException {
  Value val;
  String str;
  double num;
  boolean bool;
  String dateStr;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRING_LITERAL:
      str = stringLiteral();
                             val = new TextValue(str);
      break;
    case INTEGER_LITERAL:
    case DECIMAL_LITERAL:
    case OP_MINUS:
      num = decimalLiteral();
                              val = new NumberValue(num);
      break;
    case KW_TRUE:
    case KW_FALSE:
      bool = booleanLiteral();
                               val = BooleanValue.getInstance(bool);
      break;
    case KW_DATE:
      jj_consume_token(KW_DATE);
      dateStr = stringLiteral();
        val = ParserUtils.stringToDate(dateStr);
      break;
    case KW_TIMEOFDAY:
      jj_consume_token(KW_TIMEOFDAY);
      dateStr = stringLiteral();
        val = ParserUtils.stringToTimeOfDay(dateStr);
      break;
    case KW_DATETIME:
    case KW_TIMESTAMP:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_DATETIME:
        jj_consume_token(KW_DATETIME);
        break;
      case KW_TIMESTAMP:
        jj_consume_token(KW_TIMESTAMP);
        break;
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      dateStr = stringLiteral();
        val = ParserUtils.stringToDatetime(dateStr);
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return val;}
    throw new Error("Missing return statement in function");
  }

// A single query option (e.g., no_format)
  final public QueryOptionEnum queryOption() throws ParseException {
  QueryOptionEnum result = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_NO_VALUES:
      jj_consume_token(KW_NO_VALUES);
                      result = QueryOptionEnum.NO_VALUES;
      break;
    case KW_NO_FORMAT:
      jj_consume_token(KW_NO_FORMAT);
                      result = QueryOptionEnum.NO_FORMAT;
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

// An abstract column descriptor, i.e., either a column id, an aggregation
// function name followed by parentheses with column id (e.g., max(c1)) or a
// scalar function followed by parentheses with abstract columns
// (e.g., curr_time(), year(d1), year(sum(c1)), month(c2)), ....
  final public AbstractColumn abstractColumnDescriptor() throws ParseException, InvalidQueryException {
  AbstractColumn column;
  AbstractColumn result = null;
    if (jj_2_4(2)) {
      column = arithmeticExpression();
                                                     result = column;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_TRUE:
      case KW_FALSE:
      case KW_DATE:
      case KW_TIMEOFDAY:
      case KW_DATETIME:
      case KW_TIMESTAMP:
      case KW_MIN:
      case KW_MAX:
      case KW_AVG:
      case KW_COUNT:
      case KW_SUM:
      case KW_NO_VALUES:
      case KW_NO_FORMAT:
      case KW_IS:
      case KW_NULL:
      case KW_YEAR:
      case KW_MONTH:
      case KW_DAY:
      case KW_HOUR:
      case KW_MINUTE:
      case KW_SECOND:
      case KW_MILLISECOND:
      case KW_WITH:
      case KW_CONTAINS:
      case KW_STARTS:
      case KW_ENDS:
      case KW_MATCHES:
      case KW_LIKE:
      case KW_NOW:
      case KW_DATEDIFF:
      case KW_QUARTER:
      case KW_LOWER:
      case KW_UPPER:
      case KW_DAYOFWEEK:
      case KW_TODATE:
      case ID:
      case INTEGER_LITERAL:
      case DECIMAL_LITERAL:
      case STRING_LITERAL:
      case QUOTED_ID:
      case OP_LPAREN:
      case OP_MINUS:
        column = atomicAbstractColumnDescriptor();
                                                  result = column;
        break;
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

// An atomic abstract column descriptor, i.e., the same as abstract column,
// except it does not include arithmetic expressions like: c1+c2/c3*(c4+c5).
  final public AbstractColumn atomicAbstractColumnDescriptor() throws ParseException, InvalidQueryException {
  AggregationType aggregationType;
  ScalarFunction scalarFunction;
  String columnId;
  AbstractColumn column;
  ArrayList columns = new ArrayList();
  AbstractColumn result = null;
  Value value;
    if (jj_2_5(2)) {
      aggregationType = aggregationFunction();
      jj_consume_token(OP_LPAREN);
      columnId = columnId();
      jj_consume_token(OP_RPAREN);
       result = new AggregationColumn(new SimpleColumn(columnId),
           aggregationType);
    } else if (jj_2_6(2)) {
      scalarFunction = scalarFunction();
      jj_consume_token(OP_LPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case KW_TRUE:
      case KW_FALSE:
      case KW_DATE:
      case KW_TIMEOFDAY:
      case KW_DATETIME:
      case KW_TIMESTAMP:
      case KW_MIN:
      case KW_MAX:
      case KW_AVG:
      case KW_COUNT:
      case KW_SUM:
      case KW_NO_VALUES:
      case KW_NO_FORMAT:
      case KW_IS:
      case KW_NULL:
      case KW_YEAR:
      case KW_MONTH:
      case KW_DAY:
      case KW_HOUR:
      case KW_MINUTE:
      case KW_SECOND:
      case KW_MILLISECOND:
      case KW_WITH:
      case KW_CONTAINS:
      case KW_STARTS:
      case KW_ENDS:
      case KW_MATCHES:
      case KW_LIKE:
      case KW_NOW:
      case KW_DATEDIFF:
      case KW_QUARTER:
      case KW_LOWER:
      case KW_UPPER:
      case KW_DAYOFWEEK:
      case KW_TODATE:
      case ID:
      case INTEGER_LITERAL:
      case DECIMAL_LITERAL:
      case STRING_LITERAL:
      case QUOTED_ID:
      case OP_LPAREN:
      case OP_MINUS:
        column = abstractColumnDescriptor();
                                              columns.add(column);
        break;
      default:
        jj_la1[31] = jj_gen;
        ;
      }
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OP_COMMA:
          ;
          break;
        default:
          jj_la1[32] = jj_gen;
          break label_10;
        }
        jj_consume_token(OP_COMMA);
        column = abstractColumnDescriptor();
            columns.add(column);
      }
      jj_consume_token(OP_RPAREN);
            result = new ScalarFunctionColumn(
              GenericsHelper.makeTypedList(columns), scalarFunction);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OP_LPAREN:
        jj_consume_token(OP_LPAREN);
        column = abstractColumnDescriptor();
        jj_consume_token(OP_RPAREN);
         result = column;
        break;
      case KW_TRUE:
      case KW_FALSE:
      case KW_DATE:
      case KW_TIMEOFDAY:
      case KW_DATETIME:
      case KW_TIMESTAMP:
      case INTEGER_LITERAL:
      case DECIMAL_LITERAL:
      case STRING_LITERAL:
      case OP_MINUS:
        value = literal();
         result = new ScalarFunctionColumn(new ArrayList(),
           new Constant(value));
        break;
      case KW_MIN:
      case KW_MAX:
      case KW_AVG:
      case KW_COUNT:
      case KW_SUM:
      case KW_NO_VALUES:
      case KW_NO_FORMAT:
      case KW_IS:
      case KW_NULL:
      case KW_YEAR:
      case KW_MONTH:
      case KW_DAY:
      case KW_HOUR:
      case KW_MINUTE:
      case KW_SECOND:
      case KW_MILLISECOND:
      case KW_WITH:
      case KW_CONTAINS:
      case KW_STARTS:
      case KW_ENDS:
      case KW_MATCHES:
      case KW_LIKE:
      case KW_NOW:
      case KW_DATEDIFF:
      case KW_QUARTER:
      case KW_LOWER:
      case KW_UPPER:
      case KW_DAYOFWEEK:
      case KW_TODATE:
      case ID:
      case QUOTED_ID:
        columnId = columnId();
                               result = new SimpleColumn(columnId);
        break;
      default:
        jj_la1[33] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

// An arithmetic expression, e.g., c1 + c2 / c1 * 3 - (c3 + c4).
  final public AbstractColumn arithmeticExpression() throws ParseException, InvalidQueryException {
  AbstractColumn column;
    column = possibleSummationOrSubtraction();
    {if (true) return column;}
    throw new Error("Missing return statement in function");
  }

// A possible sum or subtraction expression of possible multiplication or division expressions.
// It is "possible" because it can also match a single expression without any
// multiplications and divisions, and then it is just returned as is.
  final public AbstractColumn possibleSummationOrSubtraction() throws ParseException, InvalidQueryException {
  AbstractColumn column;
  AbstractColumn column1;
    column = possibleMultiplicationOrDivision();
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OP_PLUS:
      case OP_MINUS:
        ;
        break;
      default:
        jj_la1[34] = jj_gen;
        break label_11;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OP_PLUS:
        jj_consume_token(OP_PLUS);
        column1 = possibleMultiplicationOrDivision();
    column =
      new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(
          new AbstractColumn[] {column, column1}), Sum.getInstance() );
        break;
      case OP_MINUS:
        jj_consume_token(OP_MINUS);
        column1 = possibleMultiplicationOrDivision();
    column =
      new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(
          new AbstractColumn[]{column, column1}),
          Difference.getInstance());
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return column;}
    throw new Error("Missing return statement in function");
  }

// A possible multiplication or division expression of atomic abstract column descriptors.
  final public AbstractColumn possibleMultiplicationOrDivision() throws ParseException, InvalidQueryException {
  AbstractColumn column;
  AbstractColumn column1;
    column = atomicAbstractColumnDescriptor();
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OP_ASTERISK:
      case OP_SLASH:
        ;
        break;
      default:
        jj_la1[36] = jj_gen;
        break label_12;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OP_ASTERISK:
        jj_consume_token(OP_ASTERISK);
        column1 = atomicAbstractColumnDescriptor();
    column =
      new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(
          new AbstractColumn[] {column, column1}), Product.getInstance() );
        break;
      case OP_SLASH:
        jj_consume_token(OP_SLASH);
        column1 = atomicAbstractColumnDescriptor();
    column =
      new ScalarFunctionColumn(GenericsHelper.makeAbstractColumnList(
          new AbstractColumn[]{column, column1}),
          Quotient.getInstance());
        break;
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return column;}
    throw new Error("Missing return statement in function");
  }

// An aggregation function, e.g., "max", "avg", ...
  final public AggregationType aggregationFunction() throws ParseException {
  AggregationType result = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_MIN:
      jj_consume_token(KW_MIN);
                result = AggregationType.MIN;
      break;
    case KW_MAX:
      jj_consume_token(KW_MAX);
                result = AggregationType.MAX;
      break;
    case KW_COUNT:
      jj_consume_token(KW_COUNT);
                  result = AggregationType.COUNT;
      break;
    case KW_AVG:
      jj_consume_token(KW_AVG);
                result = AggregationType.AVG;
      break;
    case KW_SUM:
      jj_consume_token(KW_SUM);
                result = AggregationType.SUM;
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

// A scalar function, e.g., "datediff", "upper".
  final public ScalarFunction scalarFunction() throws ParseException {
  ScalarFunction result = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_YEAR:
      jj_consume_token(KW_YEAR);
                 result = TimeComponentExtractor.getInstance(
          TimeComponentExtractor.TimeComponent.YEAR);
      break;
    case KW_MONTH:
      jj_consume_token(KW_MONTH);
                  result = TimeComponentExtractor.getInstance(
          TimeComponentExtractor.TimeComponent.MONTH);
      break;
    case KW_DAY:
      jj_consume_token(KW_DAY);
                result = TimeComponentExtractor.getInstance(
          TimeComponentExtractor.TimeComponent.DAY);
      break;
    case KW_HOUR:
      jj_consume_token(KW_HOUR);
                 result = TimeComponentExtractor.getInstance(
          TimeComponentExtractor.TimeComponent.HOUR);
      break;
    case KW_MINUTE:
      jj_consume_token(KW_MINUTE);
                   result = TimeComponentExtractor.getInstance(
          TimeComponentExtractor.TimeComponent.MINUTE);
      break;
    case KW_SECOND:
      jj_consume_token(KW_SECOND);
                   result = TimeComponentExtractor.getInstance(
          TimeComponentExtractor.TimeComponent.SECOND);
      break;
    case KW_MILLISECOND:
      jj_consume_token(KW_MILLISECOND);
                        result = TimeComponentExtractor.getInstance(
          TimeComponentExtractor.TimeComponent.MILLISECOND);
      break;
    case KW_NOW:
      jj_consume_token(KW_NOW);
                result = CurrentDateTime.getInstance();
      break;
    case KW_DATEDIFF:
      jj_consume_token(KW_DATEDIFF);
                     result = DateDiff.getInstance();
      break;
    case KW_LOWER:
      jj_consume_token(KW_LOWER);
                  result = Lower.getInstance();
      break;
    case KW_UPPER:
      jj_consume_token(KW_UPPER);
                  result = Upper.getInstance();
      break;
    case KW_QUARTER:
      jj_consume_token(KW_QUARTER);
                    result = TimeComponentExtractor.getInstance(
          TimeComponentExtractor.TimeComponent.QUARTER);
      break;
    case KW_DAYOFWEEK:
      jj_consume_token(KW_DAYOFWEEK);
                      result = TimeComponentExtractor.getInstance(
          TimeComponentExtractor.TimeComponent.DAY_OF_WEEK);
      break;
    case KW_TODATE:
      jj_consume_token(KW_TODATE);
                   result = ToDate.getInstance();
      break;
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

// A single column id. This may be a simple id (e.g. c1), a quoted id
// (e.g. `my column`) or a non-reserved keyword (e.g. max)
  final public String columnId() throws ParseException {
  Token t;
  String result = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      t = jj_consume_token(ID);
                result = t.image;
      break;
    case QUOTED_ID:
      t = jj_consume_token(QUOTED_ID);
                       result = ParserUtils.stripQuotes(t.image);
      break;
    case KW_MIN:
    case KW_MAX:
    case KW_AVG:
    case KW_COUNT:
    case KW_SUM:
    case KW_NO_VALUES:
    case KW_NO_FORMAT:
    case KW_IS:
    case KW_NULL:
    case KW_YEAR:
    case KW_MONTH:
    case KW_DAY:
    case KW_HOUR:
    case KW_MINUTE:
    case KW_SECOND:
    case KW_MILLISECOND:
    case KW_WITH:
    case KW_CONTAINS:
    case KW_STARTS:
    case KW_ENDS:
    case KW_MATCHES:
    case KW_LIKE:
    case KW_NOW:
    case KW_DATEDIFF:
    case KW_QUARTER:
    case KW_LOWER:
    case KW_UPPER:
    case KW_DAYOFWEEK:
    case KW_TODATE:
      result = nonReservedKeyword();
      break;
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

// A non-reserved keyword (e.g. min)
  final public String nonReservedKeyword() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_MIN:
      t = jj_consume_token(KW_MIN);
      break;
    case KW_MAX:
      t = jj_consume_token(KW_MAX);
      break;
    case KW_AVG:
      t = jj_consume_token(KW_AVG);
      break;
    case KW_COUNT:
      t = jj_consume_token(KW_COUNT);
      break;
    case KW_SUM:
      t = jj_consume_token(KW_SUM);
      break;
    case KW_NO_VALUES:
      t = jj_consume_token(KW_NO_VALUES);
      break;
    case KW_NO_FORMAT:
      t = jj_consume_token(KW_NO_FORMAT);
      break;
    case KW_IS:
      t = jj_consume_token(KW_IS);
      break;
    case KW_NULL:
      t = jj_consume_token(KW_NULL);
      break;
    case KW_YEAR:
      t = jj_consume_token(KW_YEAR);
      break;
    case KW_MONTH:
      t = jj_consume_token(KW_MONTH);
      break;
    case KW_DAY:
      t = jj_consume_token(KW_DAY);
      break;
    case KW_HOUR:
      t = jj_consume_token(KW_HOUR);
      break;
    case KW_MINUTE:
      t = jj_consume_token(KW_MINUTE);
      break;
    case KW_SECOND:
      t = jj_consume_token(KW_SECOND);
      break;
    case KW_MILLISECOND:
      t = jj_consume_token(KW_MILLISECOND);
      break;
    case KW_WITH:
      t = jj_consume_token(KW_WITH);
      break;
    case KW_CONTAINS:
      t = jj_consume_token(KW_CONTAINS);
      break;
    case KW_STARTS:
      t = jj_consume_token(KW_STARTS);
      break;
    case KW_ENDS:
      t = jj_consume_token(KW_ENDS);
      break;
    case KW_MATCHES:
      t = jj_consume_token(KW_MATCHES);
      break;
    case KW_LIKE:
      t = jj_consume_token(KW_LIKE);
      break;
    case KW_NOW:
      t = jj_consume_token(KW_NOW);
      break;
    case KW_DATEDIFF:
      t = jj_consume_token(KW_DATEDIFF);
      break;
    case KW_QUARTER:
      t = jj_consume_token(KW_QUARTER);
      break;
    case KW_LOWER:
      t = jj_consume_token(KW_LOWER);
      break;
    case KW_UPPER:
      t = jj_consume_token(KW_UPPER);
      break;
    case KW_DAYOFWEEK:
      t = jj_consume_token(KW_DAYOFWEEK);
      break;
    case KW_TODATE:
      t = jj_consume_token(KW_TODATE);
      break;
    default:
      jj_la1[41] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

// A sort order (e.g., DESC). This can match the empty option and returns
// ASCENDING in that case.
  final public SortOrder sortOrder() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_ASC:
      jj_consume_token(KW_ASC);
                {if (true) return SortOrder.ASCENDING;}
      break;
    case KW_DESC:
      jj_consume_token(KW_DESC);
                 {if (true) return SortOrder.DESCENDING;}
      break;
    default:
      jj_la1[42] = jj_gen;
       {if (true) return SortOrder.ASCENDING;}
    }
    throw new Error("Missing return statement in function");
  }

// An integer literal (like 4, 0, -3)
  final public int integerLiteral() throws ParseException {
  Token t1;
  Token t2;
  String s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      t1 = jj_consume_token(INTEGER_LITERAL);
                               s = t1.image;
      break;
    case OP_MINUS:
      t1 = jj_consume_token(OP_MINUS);
      t2 = jj_consume_token(INTEGER_LITERAL);
                                              s = t1.image + t2.image;
      break;
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return Integer.parseInt(s);}
    throw new Error("Missing return statement in function");
  }

// A String literal, returned without its surrounding quotes or double quotes.
  final public String stringLiteral() throws ParseException {
  Token t;
    t = jj_consume_token(STRING_LITERAL);
    {if (true) return ParserUtils.stripQuotes(t.image);}
    throw new Error("Missing return statement in function");
  }

// A decimal (numeric, of type double) literal.
  final public double decimalLiteral() throws ParseException {
  Token t1;
  Token t2;
  String s;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECIMAL_LITERAL:
      t1 = jj_consume_token(DECIMAL_LITERAL);
                              s = t1.image;
      break;
    case INTEGER_LITERAL:
      t1 = jj_consume_token(INTEGER_LITERAL);
                             s = t1.image;
      break;
    case OP_MINUS:
      t1 = jj_consume_token(OP_MINUS);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECIMAL_LITERAL:
        t2 = jj_consume_token(DECIMAL_LITERAL);
        break;
      case INTEGER_LITERAL:
        t2 = jj_consume_token(INTEGER_LITERAL);
        break;
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    s = t1.image + t2.image;
      break;
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return Double.parseDouble(s);}
    throw new Error("Missing return statement in function");
  }

// A boolean literal, either true or false.
  final public boolean booleanLiteral() throws ParseException {
  boolean b;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case KW_TRUE:
      jj_consume_token(KW_TRUE);
                 b = true;
      break;
    case KW_FALSE:
      jj_consume_token(KW_FALSE);
                  b = false;
      break;
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return b;}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_3R_66() {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3R_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) return true;
    }
    return false;
  }

  private boolean jj_3R_25() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) return true;
    }
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_scan_token(KW_TIMEOFDAY)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_scan_token(KW_DATE)) return true;
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_14() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_scan_token(QUOTED_ID)) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(KW_LIKE)) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(KW_MATCHES)) return true;
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_scan_token(KW_ENDS)) return true;
    if (jj_scan_token(KW_WITH)) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_scan_token(KW_STARTS)) return true;
    if (jj_scan_token(KW_WITH)) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_scan_token(KW_CONTAINS)) return true;
    return false;
  }

  private boolean jj_3R_60() {
    if (jj_scan_token(OP_GREATER_OR_EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_59() {
    if (jj_scan_token(OP_GREATER_THAN)) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_scan_token(OP_LESS_OR_EQUAL)) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_scan_token(KW_TODATE)) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_scan_token(OP_LESS_THAN)) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_scan_token(OP_NOT_EQUALS)) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_scan_token(KW_DAYOFWEEK)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_scan_token(OP_EQUALS)) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_scan_token(KW_QUARTER)) return true;
    return false;
  }

  private boolean jj_3R_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_scan_token(KW_UPPER)) return true;
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_scan_token(KW_LOWER)) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_scan_token(KW_DATEDIFF)) return true;
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_scan_token(KW_NOW)) return true;
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_scan_token(KW_MILLISECOND)) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_scan_token(KW_SECOND)) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_scan_token(KW_MINUTE)) return true;
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(KW_HOUR)) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_scan_token(KW_DAY)) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_3R_46()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) return true;
    }
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(KW_NOT)) return true;
    if (jj_scan_token(KW_NULL)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_scan_token(KW_MONTH)) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_scan_token(KW_NULL)) return true;
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_scan_token(KW_YEAR)) return true;
    return false;
  }

  private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_scan_token(KW_IS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) return true;
    }
    return false;
  }

  private boolean jj_3R_19() {
    if (jj_3R_47()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) return true;
    }
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_scan_token(KW_SUM)) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_scan_token(KW_AVG)) return true;
    return false;
  }

  private boolean jj_3R_29() {
    if (jj_scan_token(KW_COUNT)) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_3R_14()) return true;
    if (jj_3R_46()) return true;
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_28() {
    if (jj_scan_token(KW_MAX)) return true;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_scan_token(KW_MIN)) return true;
    return false;
  }

  private boolean jj_3R_13() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) return true;
    }
    return false;
  }

  private boolean jj_3R_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_scan_token(OP_SLASH)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_scan_token(OP_ASTERISK)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) return true;
    }
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_3R_76()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_77()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_scan_token(OP_MINUS)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_scan_token(OP_PLUS)) return true;
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_54() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    }
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_3R_53()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_54()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_scan_token(KW_FALSE)) return true;
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(KW_TRUE)) return true;
    return false;
  }

  private boolean jj_3R_52() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) return true;
    }
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(OP_MINUS)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) return true;
    }
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_15() {
    if (jj_3R_26()) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(DECIMAL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_scan_token(OP_LPAREN)) return true;
    if (jj_3R_47()) return true;
    if (jj_scan_token(OP_RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_scan_token(OP_COMMA)) return true;
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_17()) return true;
    if (jj_scan_token(OP_LPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_86()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_87()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(OP_RPAREN)) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_16()) return true;
    if (jj_scan_token(OP_LPAREN)) return true;
    if (jj_3R_85()) return true;
    if (jj_scan_token(OP_RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_76() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) {
    jj_scanpos = xsp;
    if (jj_3R_82()) return true;
    }
    }
    }
    }
    return false;
  }

  /** Generated Token Manager. */
  public QueryParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[47];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x20,0x40,0x80,0x100,0x200,0x800,0x1000,0x2000,0x4000,0x8000,0x0,0xff8c0000,0x0,0x0,0x0,0x0,0x0,0x0,0x200000,0x100000,0xffcc0000,0x0,0x400000,0xff8c0000,0x0,0xff8c0000,0x0,0x6000000,0x78c0000,0x0,0xff8c0000,0xff8c0000,0x0,0xff8c0000,0x0,0x0,0x0,0x0,0xf8000000,0x0,0xf8000000,0xf8000000,0x30000,0x0,0x0,0x0,0xc0000,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc7ffffff,0x0,0x0,0x0,0x0,0x0,0x3,0x0,0x0,0xc7ffffff,0x0,0x8,0xc7ffffff,0x1f004,0xc7ffffff,0x1f000,0x0,0x46000000,0x3,0xc7ffffff,0xc7ffffff,0x0,0xc7ffffff,0x0,0x0,0x0,0x0,0x0,0xfe07f0,0x81ffffff,0xffffff,0x0,0x2000000,0x6000000,0x6000000,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0xa02,0x1,0x1,0x1,0x1,0x1,0x0,0x0,0x0,0x802,0x2,0x0,0x802,0x1f8,0x802,0x1f8,0x0,0x800,0x0,0x802,0x802,0x1,0x802,0xc00,0xc00,0x1200,0x1200,0x0,0x0,0x0,0x0,0x0,0x800,0x0,0x800,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[6];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public QueryParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public QueryParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new QueryParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 47; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 47; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public QueryParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new QueryParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 47; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 47; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public QueryParser(QueryParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 47; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(QueryParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 47; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List jj_expentries = new java.util.ArrayList();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[78];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 47; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 78; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 6; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
