/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.common.base.Objects;
import com.google.inject.Key;

public final class NodeId {
    private final Key<?> key;
    private final NodeType nodeType;

    private NodeId(Key<?> key, NodeType nodeType) {
        this.key = key;
        this.nodeType = nodeType;
    }

    public static NodeId newTypeId(Key<?> key) {
        return new NodeId(key, NodeType.TYPE);
    }

    public static NodeId newInstanceId(Key<?> key) {
        return new NodeId(key, NodeType.INSTANCE);
    }

    public Key<?> getKey() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.nodeType});
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(NodeId.class)) {
            return false;
        }
        NodeId other = (NodeId)obj;
        return Objects.equal(this.key, other.key) && Objects.equal((Object)((Object)this.nodeType), (Object)((Object)other.nodeType));
    }

    public String toString() {
        String string = String.valueOf(String.valueOf((Object)this.nodeType));
        String string2 = String.valueOf(String.valueOf(this.key));
        return new StringBuilder(22 + string.length() + string2.length()).append("NodeId{nodeType=").append(string).append(" key=").append(string2).append("}").toString();
    }

    public static enum NodeType {
        TYPE,
        INSTANCE;

    }
}

