package com.google.genai.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Interval extends Interval {

  private final Optional<Instant> startTime;

  private final Optional<Instant> endTime;

  private AutoValue_Interval(
      Optional<Instant> startTime,
      Optional<Instant> endTime) {
    this.startTime = startTime;
    this.endTime = endTime;
  }

  @JsonProperty("startTime")
  @Override
  public Optional<Instant> startTime() {
    return startTime;
  }

  @JsonProperty("endTime")
  @Override
  public Optional<Instant> endTime() {
    return endTime;
  }

  @Override
  public String toString() {
    return "Interval{"
        + "startTime=" + startTime + ", "
        + "endTime=" + endTime
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Interval) {
      Interval that = (Interval) o;
      return this.startTime.equals(that.startTime())
          && this.endTime.equals(that.endTime());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= startTime.hashCode();
    h$ *= 1000003;
    h$ ^= endTime.hashCode();
    return h$;
  }

  @Override
  public Interval.Builder toBuilder() {
    return new AutoValue_Interval.Builder(this);
  }

  static final class Builder extends Interval.Builder {
    private Optional<Instant> startTime = Optional.empty();
    private Optional<Instant> endTime = Optional.empty();
    Builder() {
    }
    Builder(Interval source) {
      this.startTime = source.startTime();
      this.endTime = source.endTime();
    }
    @Override
    public Interval.Builder startTime(Instant startTime) {
      this.startTime = Optional.of(startTime);
      return this;
    }
    @Override
    public Interval.Builder endTime(Instant endTime) {
      this.endTime = Optional.of(endTime);
      return this;
    }
    @Override
    public Interval build() {
      return new AutoValue_Interval(
          this.startTime,
          this.endTime);
    }
  }

}
