/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.connection;

import com.google.firebase.database.connection.CompoundHash;
import com.google.firebase.database.connection.Connection;
import com.google.firebase.database.connection.ConnectionAuthTokenProvider;
import com.google.firebase.database.connection.ConnectionContext;
import com.google.firebase.database.connection.ConnectionUtils;
import com.google.firebase.database.connection.HostInfo;
import com.google.firebase.database.connection.ListenHashProvider;
import com.google.firebase.database.connection.PersistentConnection;
import com.google.firebase.database.connection.RangeMerge;
import com.google.firebase.database.connection.RequestResultCallback;
import com.google.firebase.database.connection.util.RetryHelper;
import com.google.firebase.database.logging.LogWrapper;
import com.google.firebase.database.util.GAuthToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PersistentConnectionImpl
implements Connection.Delegate,
PersistentConnection {
    private static final String REQUEST_ERROR = "error";
    private static final String REQUEST_QUERIES = "q";
    private static final String REQUEST_TAG = "t";
    private static final String REQUEST_STATUS = "s";
    private static final String REQUEST_PATH = "p";
    private static final String REQUEST_NUMBER = "r";
    private static final String REQUEST_PAYLOAD = "b";
    private static final String REQUEST_COUNTERS = "c";
    private static final String REQUEST_DATA_PAYLOAD = "d";
    private static final String REQUEST_DATA_HASH = "h";
    private static final String REQUEST_COMPOUND_HASH = "ch";
    private static final String REQUEST_COMPOUND_HASH_PATHS = "ps";
    private static final String REQUEST_COMPOUND_HASH_HASHES = "hs";
    private static final String REQUEST_CREDENTIAL = "cred";
    private static final String REQUEST_AUTHVAR = "authvar";
    private static final String REQUEST_ACTION = "a";
    private static final String REQUEST_ACTION_STATS = "s";
    private static final String REQUEST_ACTION_QUERY = "q";
    private static final String REQUEST_ACTION_PUT = "p";
    private static final String REQUEST_ACTION_MERGE = "m";
    private static final String REQUEST_ACTION_QUERY_UNLISTEN = "n";
    private static final String REQUEST_ACTION_ONDISCONNECT_PUT = "o";
    private static final String REQUEST_ACTION_ONDISCONNECT_MERGE = "om";
    private static final String REQUEST_ACTION_ONDISCONNECT_CANCEL = "oc";
    private static final String REQUEST_ACTION_AUTH = "auth";
    private static final String REQUEST_ACTION_GAUTH = "gauth";
    private static final String REQUEST_ACTION_UNAUTH = "unauth";
    private static final String REQUEST_NOAUTH = "noauth";
    private static final String RESPONSE_FOR_REQUEST = "b";
    private static final String SERVER_ASYNC_ACTION = "a";
    private static final String SERVER_ASYNC_PAYLOAD = "b";
    private static final String SERVER_ASYNC_DATA_UPDATE = "d";
    private static final String SERVER_ASYNC_DATA_MERGE = "m";
    private static final String SERVER_ASYNC_DATA_RANGE_MERGE = "rm";
    private static final String SERVER_ASYNC_AUTH_REVOKED = "ac";
    private static final String SERVER_ASYNC_LISTEN_CANCELLED = "c";
    private static final String SERVER_ASYNC_SECURITY_DEBUG = "sd";
    private static final String SERVER_DATA_UPDATE_PATH = "p";
    private static final String SERVER_DATA_UPDATE_BODY = "d";
    private static final String SERVER_DATA_START_PATH = "s";
    private static final String SERVER_DATA_END_PATH = "e";
    private static final String SERVER_DATA_RANGE_MERGE = "m";
    private static final String SERVER_DATA_TAG = "t";
    private static final String SERVER_DATA_WARNINGS = "w";
    private static final String SERVER_RESPONSE_DATA = "d";
    private static final long SUCCESSFUL_CONNECTION_ESTABLISHED_DELAY = 30000L;
    private static final long IDLE_TIMEOUT = 60000L;
    private static final long INVALID_AUTH_TOKEN_THRESHOLD = 3L;
    private static final String SERVER_KILL_INTERRUPT_REASON = "server_kill";
    private static final String IDLE_INTERRUPT_REASON = "connection_idle";
    private static final String TOKEN_REFRESH_INTERRUPT_REASON = "token_refresh";
    private static long connectionIds = 0L;
    private final PersistentConnection.Delegate delegate;
    private final HostInfo hostInfo;
    private final ConnectionContext context;
    private final ConnectionFactory connFactory;
    private final ConnectionAuthTokenProvider authTokenProvider;
    private final ScheduledExecutorService executorService;
    private final LogWrapper logger;
    private final RetryHelper retryHelper;
    private String cachedHost;
    private HashSet<String> interruptReasons = new HashSet();
    private boolean firstConnection = true;
    private long lastConnectionEstablishedTime;
    private Connection realtime;
    private ConnectionState connectionState = ConnectionState.Disconnected;
    private long writeCounter = 0L;
    private long requestCounter = 0L;
    private Map<Long, ConnectionRequestCallback> requestCBHash;
    private List<OutstandingDisconnect> onDisconnectRequestQueue;
    private Map<Long, OutstandingPut> outstandingPuts;
    private Map<ListenQuerySpec, OutstandingListen> listens;
    private String authToken;
    private boolean forceAuthTokenRefresh;
    private String lastSessionId;
    private long currentGetTokenAttempt = 0L;
    private int invalidAuthTokenCount = 0;
    private ScheduledFuture<?> inactivityTimer = null;
    private long lastWriteTimestamp;
    private boolean hasOnDisconnects;

    public PersistentConnectionImpl(ConnectionContext context, HostInfo info, PersistentConnection.Delegate delegate) {
        this(context, info, delegate, new DefaultConnectionFactory());
    }

    PersistentConnectionImpl(ConnectionContext context, HostInfo info, PersistentConnection.Delegate delegate, ConnectionFactory connFactory) {
        this.context = context;
        this.hostInfo = info;
        this.delegate = delegate;
        this.connFactory = connFactory;
        this.executorService = context.getExecutorService();
        this.authTokenProvider = context.getAuthTokenProvider();
        this.listens = new HashMap<ListenQuerySpec, OutstandingListen>();
        this.requestCBHash = new HashMap<Long, ConnectionRequestCallback>();
        this.outstandingPuts = new HashMap<Long, OutstandingPut>();
        this.onDisconnectRequestQueue = new ArrayList<OutstandingDisconnect>();
        this.retryHelper = new RetryHelper.Builder(this.executorService, context.getLogger(), RetryHelper.class).withMinDelayAfterFailure(1000L).withRetryExponent(1.3).withMaxDelay(30000L).withJitterFactor(0.7).build();
        long connId = connectionIds++;
        this.logger = new LogWrapper(context.getLogger(), PersistentConnection.class, "pc_" + connId);
        this.lastSessionId = null;
        this.doIdleCheck();
    }

    @Override
    public void onReady(long timestamp, String sessionId) {
        if (this.logger.logsDebug()) {
            this.logger.debug("onReady", new Object[0]);
        }
        this.lastConnectionEstablishedTime = System.currentTimeMillis();
        this.handleTimestamp(timestamp);
        if (this.firstConnection) {
            this.sendConnectStats();
        }
        this.restoreAuth();
        this.firstConnection = false;
        this.lastSessionId = sessionId;
        this.delegate.onConnect();
    }

    @Override
    public void onCacheHost(String host) {
        this.cachedHost = host;
    }

    @Override
    public void listen(List<String> path, Map<String, Object> queryParams, ListenHashProvider currentHashFn, Long tag, RequestResultCallback listener) {
        ListenQuerySpec query = new ListenQuerySpec(path, queryParams);
        if (this.logger.logsDebug()) {
            this.logger.debug("Listening on " + query, new Object[0]);
        }
        ConnectionUtils.hardAssert(!this.listens.containsKey(query), "listen() called twice for same QuerySpec.", new Object[0]);
        if (this.logger.logsDebug()) {
            this.logger.debug("Adding listen query: " + query, new Object[0]);
        }
        OutstandingListen outstandingListen = new OutstandingListen(listener, query, tag, currentHashFn);
        this.listens.put(query, outstandingListen);
        if (this.connected()) {
            this.sendListen(outstandingListen);
        }
        this.doIdleCheck();
    }

    @Override
    public void initialize() {
        this.tryScheduleReconnect();
    }

    @Override
    public void shutdown() {
        this.interrupt("shutdown");
    }

    @Override
    public void put(List<String> path, Object data, RequestResultCallback onComplete) {
        this.putInternal("p", path, data, null, onComplete);
    }

    @Override
    public void compareAndPut(List<String> path, Object data, String hash, RequestResultCallback onComplete) {
        this.putInternal("p", path, data, hash, onComplete);
    }

    @Override
    public void merge(List<String> path, Map<String, Object> data, RequestResultCallback onComplete) {
        this.putInternal("m", path, data, null, onComplete);
    }

    @Override
    public void purgeOutstandingWrites() {
        for (OutstandingPut put : this.outstandingPuts.values()) {
            if (put.onComplete == null) continue;
            put.onComplete.onRequestResult("write_canceled", null);
        }
        for (OutstandingDisconnect onDisconnect : this.onDisconnectRequestQueue) {
            if (onDisconnect.onComplete == null) continue;
            onDisconnect.onComplete.onRequestResult("write_canceled", null);
        }
        this.outstandingPuts.clear();
        this.onDisconnectRequestQueue.clear();
        if (!this.connected()) {
            this.hasOnDisconnects = false;
        }
        this.doIdleCheck();
    }

    @Override
    public void onDataMessage(Map<String, Object> message) {
        if (message.containsKey(REQUEST_NUMBER)) {
            long rn = ((Integer)message.get(REQUEST_NUMBER)).intValue();
            ConnectionRequestCallback responseListener = this.requestCBHash.remove(rn);
            if (responseListener != null) {
                Map response = (Map)message.get("b");
                responseListener.onResponse(response);
            }
        } else if (!message.containsKey(REQUEST_ERROR)) {
            if (message.containsKey("a")) {
                String action = (String)message.get("a");
                Map body = (Map)message.get("b");
                this.onDataPush(action, body);
            } else if (this.logger.logsDebug()) {
                this.logger.debug("Ignoring unknown message: " + message, new Object[0]);
            }
        }
    }

    @Override
    public void onDisconnect(Connection.DisconnectReason reason) {
        if (this.logger.logsDebug()) {
            this.logger.debug("Got on disconnect due to " + reason.name(), new Object[0]);
        }
        this.connectionState = ConnectionState.Disconnected;
        this.realtime = null;
        this.hasOnDisconnects = false;
        this.requestCBHash.clear();
        if (this.inactivityTimer != null) {
            this.logger.debug("cancelling idle time checker", new Object[0]);
            this.inactivityTimer.cancel(false);
            this.inactivityTimer = null;
        }
        this.cancelSentTransactions();
        if (this.shouldReconnect()) {
            long timeSinceLastConnectSucceeded = System.currentTimeMillis() - this.lastConnectionEstablishedTime;
            boolean lastConnectionWasSuccessful = this.lastConnectionEstablishedTime > 0L ? timeSinceLastConnectSucceeded > 30000L : false;
            if (reason == Connection.DisconnectReason.SERVER_RESET || lastConnectionWasSuccessful) {
                this.retryHelper.signalSuccess();
            }
            this.tryScheduleReconnect();
        }
        this.lastConnectionEstablishedTime = 0L;
        this.delegate.onDisconnect();
    }

    @Override
    public void onKill(String reason) {
        if (this.logger.logsDebug()) {
            this.logger.debug("Firebase Database connection was forcefully killed by the server. Will not attempt reconnect. Reason: " + reason, new Object[0]);
        }
        this.interrupt(SERVER_KILL_INTERRUPT_REASON);
    }

    @Override
    public void unlisten(List<String> path, Map<String, Object> queryParams) {
        OutstandingListen listen;
        ListenQuerySpec query = new ListenQuerySpec(path, queryParams);
        if (this.logger.logsDebug()) {
            this.logger.debug("unlistening on " + query, new Object[0]);
        }
        if ((listen = this.removeListen(query)) != null && this.connected()) {
            this.sendUnlisten(listen);
        }
        this.doIdleCheck();
    }

    private boolean connected() {
        return this.connectionState == ConnectionState.Authenticating || this.connectionState == ConnectionState.Connected;
    }

    @Override
    public void onDisconnectPut(List<String> path, Object data, RequestResultCallback onComplete) {
        this.hasOnDisconnects = true;
        if (this.canSendWrites()) {
            this.sendOnDisconnect(REQUEST_ACTION_ONDISCONNECT_PUT, path, data, onComplete);
        } else {
            this.onDisconnectRequestQueue.add(new OutstandingDisconnect(REQUEST_ACTION_ONDISCONNECT_PUT, path, data, onComplete));
        }
        this.doIdleCheck();
    }

    private boolean canSendWrites() {
        return this.connectionState == ConnectionState.Connected;
    }

    @Override
    public void onDisconnectMerge(List<String> path, Map<String, Object> updates, RequestResultCallback onComplete) {
        this.hasOnDisconnects = true;
        if (this.canSendWrites()) {
            this.sendOnDisconnect(REQUEST_ACTION_ONDISCONNECT_MERGE, path, updates, onComplete);
        } else {
            this.onDisconnectRequestQueue.add(new OutstandingDisconnect(REQUEST_ACTION_ONDISCONNECT_MERGE, path, updates, onComplete));
        }
        this.doIdleCheck();
    }

    @Override
    public void onDisconnectCancel(List<String> path, RequestResultCallback onComplete) {
        if (this.canSendWrites()) {
            this.sendOnDisconnect(REQUEST_ACTION_ONDISCONNECT_CANCEL, path, null, onComplete);
        } else {
            this.onDisconnectRequestQueue.add(new OutstandingDisconnect(REQUEST_ACTION_ONDISCONNECT_CANCEL, path, null, onComplete));
        }
        this.doIdleCheck();
    }

    @Override
    public void interrupt(String reason) {
        if (this.logger.logsDebug()) {
            this.logger.debug("Connection interrupted for: " + reason, new Object[0]);
        }
        this.interruptReasons.add(reason);
        if (this.realtime != null) {
            this.realtime.close();
            this.realtime = null;
        } else {
            this.retryHelper.cancel();
            this.connectionState = ConnectionState.Disconnected;
        }
        this.retryHelper.signalSuccess();
    }

    @Override
    public void resume(String reason) {
        if (this.logger.logsDebug()) {
            this.logger.debug("Connection no longer interrupted for: " + reason, new Object[0]);
        }
        this.interruptReasons.remove(reason);
        if (this.shouldReconnect() && this.connectionState == ConnectionState.Disconnected) {
            this.tryScheduleReconnect();
        }
    }

    @Override
    public boolean isInterrupted(String reason) {
        return this.interruptReasons.contains(reason);
    }

    private boolean shouldReconnect() {
        return this.interruptReasons.size() == 0;
    }

    @Override
    public void refreshAuthToken() {
        this.logger.debug("Auth token refresh requested", new Object[0]);
        this.interrupt(TOKEN_REFRESH_INTERRUPT_REASON);
        this.resume(TOKEN_REFRESH_INTERRUPT_REASON);
    }

    @Override
    public void refreshAuthToken(String token) {
        this.logger.debug("Auth token refreshed.", new Object[0]);
        this.authToken = token;
        if (this.connected()) {
            if (token != null) {
                this.upgradeAuth();
            } else {
                this.sendUnauth();
            }
        }
    }

    private void tryScheduleReconnect() {
        if (this.shouldReconnect()) {
            ConnectionUtils.hardAssert(this.connectionState == ConnectionState.Disconnected, "Not in disconnected state: %s", new Object[]{this.connectionState});
            final boolean forceRefresh = this.forceAuthTokenRefresh;
            this.logger.debug("Scheduling connection attempt", new Object[0]);
            this.forceAuthTokenRefresh = false;
            this.retryHelper.retry(new Runnable(){

                @Override
                public void run() {
                    PersistentConnectionImpl.this.logger.debug("Trying to fetch auth token", new Object[0]);
                    ConnectionUtils.hardAssert(PersistentConnectionImpl.this.connectionState == ConnectionState.Disconnected, "Not in disconnected state: %s", new Object[]{PersistentConnectionImpl.this.connectionState});
                    PersistentConnectionImpl.this.connectionState = ConnectionState.GettingToken;
                    PersistentConnectionImpl.this.currentGetTokenAttempt++;
                    final long thisGetTokenAttempt = PersistentConnectionImpl.this.currentGetTokenAttempt;
                    PersistentConnectionImpl.this.authTokenProvider.getToken(forceRefresh, new ConnectionAuthTokenProvider.GetTokenCallback(){

                        @Override
                        public void onSuccess(String token) {
                            if (thisGetTokenAttempt == PersistentConnectionImpl.this.currentGetTokenAttempt) {
                                if (PersistentConnectionImpl.this.connectionState == ConnectionState.GettingToken) {
                                    PersistentConnectionImpl.this.logger.debug("Successfully fetched token, opening connection", new Object[0]);
                                    PersistentConnectionImpl.this.openNetworkConnection(token);
                                } else {
                                    ConnectionUtils.hardAssert(PersistentConnectionImpl.this.connectionState == ConnectionState.Disconnected, "Expected connection state disconnected, but was %s", new Object[]{PersistentConnectionImpl.this.connectionState});
                                    PersistentConnectionImpl.this.logger.debug("Not opening connection after token refresh, because connection was set to disconnected", new Object[0]);
                                }
                            } else {
                                PersistentConnectionImpl.this.logger.debug("Ignoring getToken result, because this was not the latest attempt.", new Object[0]);
                            }
                        }

                        @Override
                        public void onError(String error) {
                            if (thisGetTokenAttempt == PersistentConnectionImpl.this.currentGetTokenAttempt) {
                                PersistentConnectionImpl.this.connectionState = ConnectionState.Disconnected;
                                PersistentConnectionImpl.this.logger.debug("Error fetching token: " + error, new Object[0]);
                                PersistentConnectionImpl.this.tryScheduleReconnect();
                            } else {
                                PersistentConnectionImpl.this.logger.debug("Ignoring getToken error, because this was not the latest attempt.", new Object[0]);
                            }
                        }
                    });
                }
            });
        }
    }

    private void openNetworkConnection(String token) {
        ConnectionUtils.hardAssert(this.connectionState == ConnectionState.GettingToken, "Trying to open network connection while in the wrong state: %s", new Object[]{this.connectionState});
        if (token == null) {
            this.delegate.onAuthStatus(false);
        }
        this.authToken = token;
        this.connectionState = ConnectionState.Connecting;
        this.realtime = this.connFactory.newConnection(this);
        this.realtime.open();
    }

    private void sendOnDisconnect(String action, List<String> path, Object data, final RequestResultCallback onComplete) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("p", ConnectionUtils.pathToString(path));
        request.put("d", data);
        this.sendAction(action, request, new ConnectionRequestCallback(){

            @Override
            public void onResponse(Map<String, Object> response) {
                String status = (String)response.get("s");
                String errorMessage = null;
                String errorCode = null;
                if (!status.equals("ok")) {
                    errorCode = status;
                    errorMessage = (String)response.get("d");
                }
                if (onComplete != null) {
                    onComplete.onRequestResult(errorCode, errorMessage);
                }
            }
        });
    }

    private void cancelSentTransactions() {
        ArrayList<OutstandingPut> cancelledTransactionWrites = new ArrayList<OutstandingPut>();
        Iterator<Map.Entry<Long, OutstandingPut>> iter = this.outstandingPuts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, OutstandingPut> entry = iter.next();
            OutstandingPut put = entry.getValue();
            if (!put.getRequest().containsKey(REQUEST_DATA_HASH) || !put.wasSent()) continue;
            cancelledTransactionWrites.add(put);
            iter.remove();
        }
        for (OutstandingPut put : cancelledTransactionWrites) {
            put.getOnComplete().onRequestResult("disconnected", null);
        }
    }

    private void sendUnlisten(OutstandingListen listen) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("p", ConnectionUtils.pathToString(listen.query.path));
        Long tag = listen.getTag();
        if (tag != null) {
            request.put("q", listen.getQuery().queryParams);
            request.put("t", tag);
        }
        this.sendAction(REQUEST_ACTION_QUERY_UNLISTEN, request, null);
    }

    private OutstandingListen removeListen(ListenQuerySpec query) {
        if (this.logger.logsDebug()) {
            this.logger.debug("removing query " + query, new Object[0]);
        }
        if (!this.listens.containsKey(query)) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Trying to remove listener for QuerySpec " + query + " but no listener exists.", new Object[0]);
            }
            return null;
        }
        OutstandingListen oldListen = this.listens.get(query);
        this.listens.remove(query);
        this.doIdleCheck();
        return oldListen;
    }

    private Collection<OutstandingListen> removeListens(List<String> path) {
        if (this.logger.logsDebug()) {
            this.logger.debug("removing all listens at path " + path, new Object[0]);
        }
        ArrayList<OutstandingListen> removedListens = new ArrayList<OutstandingListen>();
        for (Map.Entry<ListenQuerySpec, OutstandingListen> entry : this.listens.entrySet()) {
            ListenQuerySpec query = entry.getKey();
            OutstandingListen listen = entry.getValue();
            if (!query.path.equals(path)) continue;
            removedListens.add(listen);
        }
        for (OutstandingListen toRemove : removedListens) {
            this.listens.remove(toRemove.getQuery());
        }
        this.doIdleCheck();
        return removedListens;
    }

    private void onDataPush(String action, Map<String, Object> body) {
        if (this.logger.logsDebug()) {
            this.logger.debug("handleServerMessage: " + action + " " + body, new Object[0]);
        }
        if (action.equals("d") || action.equals("m")) {
            boolean isMerge = action.equals("m");
            String pathString = (String)body.get("p");
            Object payloadData = body.get("d");
            Long tagNumber = ConnectionUtils.longFromObject(body.get("t"));
            if (isMerge && payloadData instanceof Map && ((Map)payloadData).size() == 0) {
                if (this.logger.logsDebug()) {
                    this.logger.debug("ignoring empty merge for path " + pathString, new Object[0]);
                }
            } else {
                List<String> path = ConnectionUtils.stringToPath(pathString);
                this.delegate.onDataUpdate(path, payloadData, isMerge, tagNumber);
            }
        } else if (action.equals(SERVER_ASYNC_DATA_RANGE_MERGE)) {
            String pathString = (String)body.get("p");
            List<String> path = ConnectionUtils.stringToPath(pathString);
            Object payloadData = body.get("d");
            Long tag = ConnectionUtils.longFromObject(body.get("t"));
            List ranges = (List)payloadData;
            ArrayList<RangeMerge> rangeMerges = new ArrayList<RangeMerge>();
            for (Map range : ranges) {
                String startString = (String)range.get("s");
                String endString = (String)range.get(SERVER_DATA_END_PATH);
                List<String> start = startString != null ? ConnectionUtils.stringToPath(startString) : null;
                List<String> end = endString != null ? ConnectionUtils.stringToPath(endString) : null;
                Object update = range.get("m");
                rangeMerges.add(new RangeMerge(start, end, update));
            }
            if (rangeMerges.isEmpty()) {
                if (this.logger.logsDebug()) {
                    this.logger.debug("Ignoring empty range merge for path " + pathString, new Object[0]);
                }
            } else {
                this.delegate.onRangeMergeUpdate(path, rangeMerges, tag);
            }
        } else if (action.equals("c")) {
            String pathString = (String)body.get("p");
            List<String> path = ConnectionUtils.stringToPath(pathString);
            this.onListenRevoked(path);
        } else if (action.equals(SERVER_ASYNC_AUTH_REVOKED)) {
            String status = (String)body.get("s");
            String reason = (String)body.get("d");
            this.onAuthRevoked(status, reason);
        } else if (action.equals(SERVER_ASYNC_SECURITY_DEBUG)) {
            this.onSecurityDebugPacket(body);
        } else if (this.logger.logsDebug()) {
            this.logger.debug("Unrecognized action from server: " + action, new Object[0]);
        }
    }

    private void onListenRevoked(List<String> path) {
        Collection<OutstandingListen> listens = this.removeListens(path);
        if (listens != null) {
            for (OutstandingListen listen : listens) {
                listen.resultCallback.onRequestResult("permission_denied", null);
            }
        }
    }

    private void onAuthRevoked(String errorCode, String errorMessage) {
        this.logger.debug("Auth token revoked: " + errorCode + " (" + errorMessage + ")", new Object[0]);
        this.authToken = null;
        this.forceAuthTokenRefresh = true;
        this.delegate.onAuthStatus(false);
        this.realtime.close();
    }

    private void onSecurityDebugPacket(Map<String, Object> message) {
        this.logger.info((String)message.get("msg"));
    }

    private void upgradeAuth() {
        this.sendAuthHelper(false);
    }

    private void sendAuthAndRestoreState() {
        this.sendAuthHelper(true);
    }

    private void sendAuthHelper(final boolean restoreStateAfterComplete) {
        ConnectionUtils.hardAssert(this.connected(), "Must be connected to send auth, but was: %s", new Object[]{this.connectionState});
        ConnectionUtils.hardAssert(this.authToken != null, "Auth token must be set to authenticate!", new Object[0]);
        ConnectionRequestCallback onComplete = new ConnectionRequestCallback(){

            @Override
            public void onResponse(Map<String, Object> response) {
                PersistentConnectionImpl.this.connectionState = ConnectionState.Connected;
                String status = (String)response.get("s");
                if (status.equals("ok")) {
                    PersistentConnectionImpl.this.invalidAuthTokenCount = 0;
                    PersistentConnectionImpl.this.delegate.onAuthStatus(true);
                    if (restoreStateAfterComplete) {
                        PersistentConnectionImpl.this.restoreState();
                    }
                } else {
                    PersistentConnectionImpl.this.authToken = null;
                    PersistentConnectionImpl.this.forceAuthTokenRefresh = true;
                    PersistentConnectionImpl.this.delegate.onAuthStatus(false);
                    String reason = (String)response.get("d");
                    PersistentConnectionImpl.this.logger.debug("Authentication failed: " + status + " (" + reason + ")", new Object[0]);
                    PersistentConnectionImpl.this.realtime.close();
                    if (status.equals("invalid_token") || status.equals("permission_denied")) {
                        PersistentConnectionImpl.this.invalidAuthTokenCount++;
                        if ((long)PersistentConnectionImpl.this.invalidAuthTokenCount >= 3L) {
                            PersistentConnectionImpl.this.retryHelper.setMaxDelay();
                            PersistentConnectionImpl.this.logger.warn("Provided authentication credentials are invalid. This usually indicates your FirebaseApp instance was not initialized correctly. Make sure your database URL is correct and that your service account is for the correct project and is authorized to access it.");
                        }
                    }
                }
            }
        };
        HashMap<String, Object> request = new HashMap<String, Object>();
        GAuthToken googleAuthToken = GAuthToken.tryParseFromString(this.authToken);
        if (googleAuthToken != null) {
            request.put(REQUEST_CREDENTIAL, googleAuthToken.getToken());
            if (googleAuthToken.getAuth() != null) {
                if (!googleAuthToken.getAuth().isEmpty()) {
                    request.put(REQUEST_AUTHVAR, googleAuthToken.getAuth());
                }
            } else {
                request.put(REQUEST_NOAUTH, true);
            }
            this.sendSensitive(REQUEST_ACTION_GAUTH, true, request, onComplete);
        } else {
            request.put(REQUEST_CREDENTIAL, this.authToken);
            this.sendSensitive(REQUEST_ACTION_AUTH, true, request, onComplete);
        }
    }

    private void sendUnauth() {
        ConnectionUtils.hardAssert(this.connected(), "Must be connected to send unauth.", new Object[0]);
        ConnectionUtils.hardAssert(this.authToken == null, "Auth token must not be set.", new Object[0]);
        this.sendAction(REQUEST_ACTION_UNAUTH, Collections.emptyMap(), null);
    }

    private void restoreAuth() {
        if (this.logger.logsDebug()) {
            this.logger.debug("calling restore state", new Object[0]);
        }
        ConnectionUtils.hardAssert(this.connectionState == ConnectionState.Connecting, "Wanted to restore auth, but was in wrong state: %s", new Object[]{this.connectionState});
        if (this.authToken == null) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Not restoring auth because token is null.", new Object[0]);
            }
            this.connectionState = ConnectionState.Connected;
            this.restoreState();
        } else {
            if (this.logger.logsDebug()) {
                this.logger.debug("Restoring auth.", new Object[0]);
            }
            this.connectionState = ConnectionState.Authenticating;
            this.sendAuthAndRestoreState();
        }
    }

    private void restoreState() {
        ConnectionUtils.hardAssert(this.connectionState == ConnectionState.Connected, "Should be connected if we're restoring state, but we are: %s", new Object[]{this.connectionState});
        if (this.logger.logsDebug()) {
            this.logger.debug("Restoring outstanding listens", new Object[0]);
        }
        for (OutstandingListen listen : this.listens.values()) {
            if (this.logger.logsDebug()) {
                this.logger.debug("Restoring listen " + listen.getQuery(), new Object[0]);
            }
            this.sendListen(listen);
        }
        if (this.logger.logsDebug()) {
            this.logger.debug("Restoring writes.", new Object[0]);
        }
        ArrayList<Long> outstanding = new ArrayList<Long>(this.outstandingPuts.keySet());
        Collections.sort(outstanding);
        for (Long put : outstanding) {
            this.sendPut(put);
        }
        for (OutstandingDisconnect disconnect : this.onDisconnectRequestQueue) {
            this.sendOnDisconnect(disconnect.getAction(), disconnect.getPath(), disconnect.getData(), disconnect.getOnComplete());
        }
        this.onDisconnectRequestQueue.clear();
    }

    private void handleTimestamp(long timestamp) {
        if (this.logger.logsDebug()) {
            this.logger.debug("handling timestamp", new Object[0]);
        }
        long timestampDelta = timestamp - System.currentTimeMillis();
        HashMap<String, Object> updates = new HashMap<String, Object>();
        updates.put("serverTimeOffset", timestampDelta);
        this.delegate.onServerInfoUpdate(updates);
    }

    private Map<String, Object> getPutObject(List<String> path, Object data, String hash) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("p", ConnectionUtils.pathToString(path));
        request.put("d", data);
        if (hash != null) {
            request.put(REQUEST_DATA_HASH, hash);
        }
        return request;
    }

    private void putInternal(String action, List<String> path, Object data, String hash, RequestResultCallback onComplete) {
        Map<String, Object> request = this.getPutObject(path, data, hash);
        long writeId = this.writeCounter++;
        this.outstandingPuts.put(writeId, new OutstandingPut(action, request, onComplete));
        if (this.canSendWrites()) {
            this.sendPut(writeId);
        }
        this.lastWriteTimestamp = System.currentTimeMillis();
        this.doIdleCheck();
    }

    private void sendPut(final long putId) {
        assert (this.canSendWrites()) : "sendPut called when we can't send writes (we're disconnected or writes are paused).";
        final OutstandingPut put = this.outstandingPuts.get(putId);
        final RequestResultCallback onComplete = put.getOnComplete();
        final String action = put.getAction();
        put.markSent();
        this.sendAction(action, put.getRequest(), new ConnectionRequestCallback(){

            @Override
            public void onResponse(Map<String, Object> response) {
                OutstandingPut currentPut;
                if (PersistentConnectionImpl.this.logger.logsDebug()) {
                    PersistentConnectionImpl.this.logger.debug(action + " response: " + response, new Object[0]);
                }
                if ((currentPut = (OutstandingPut)PersistentConnectionImpl.this.outstandingPuts.get(putId)) == put) {
                    PersistentConnectionImpl.this.outstandingPuts.remove(putId);
                    if (onComplete != null) {
                        String status = (String)response.get("s");
                        if (status.equals("ok")) {
                            onComplete.onRequestResult(null, null);
                        } else {
                            String errorMessage = (String)response.get("d");
                            onComplete.onRequestResult(status, errorMessage);
                        }
                    }
                } else if (PersistentConnectionImpl.this.logger.logsDebug()) {
                    PersistentConnectionImpl.this.logger.debug("Ignoring on complete for put " + putId + " because it was removed already.", new Object[0]);
                }
                PersistentConnectionImpl.this.doIdleCheck();
            }
        });
    }

    private void sendListen(final OutstandingListen listen) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("p", ConnectionUtils.pathToString(listen.getQuery().path));
        Long tag = listen.getTag();
        if (tag != null) {
            request.put("q", listen.query.queryParams);
            request.put("t", tag);
        }
        ListenHashProvider hashFunction = listen.getHashFunction();
        request.put(REQUEST_DATA_HASH, hashFunction.getSimpleHash());
        if (hashFunction.shouldIncludeCompoundHash()) {
            CompoundHash compoundHash = hashFunction.getCompoundHash();
            ArrayList<String> posts = new ArrayList<String>();
            for (List<String> path : compoundHash.getPosts()) {
                posts.add(ConnectionUtils.pathToString(path));
            }
            HashMap<String, List<String>> hash = new HashMap<String, List<String>>();
            hash.put(REQUEST_COMPOUND_HASH_HASHES, compoundHash.getHashes());
            hash.put(REQUEST_COMPOUND_HASH_PATHS, posts);
            request.put(REQUEST_COMPOUND_HASH, hash);
        }
        this.sendAction("q", request, new ConnectionRequestCallback(){

            @Override
            public void onResponse(Map<String, Object> response) {
                OutstandingListen currentListen;
                Map serverBody;
                String status = (String)response.get("s");
                if (status.equals("ok") && (serverBody = (Map)response.get("d")).containsKey(PersistentConnectionImpl.SERVER_DATA_WARNINGS)) {
                    List warnings = (List)serverBody.get(PersistentConnectionImpl.SERVER_DATA_WARNINGS);
                    PersistentConnectionImpl.this.warnOnListenerWarnings(warnings, listen.query);
                }
                if ((currentListen = (OutstandingListen)PersistentConnectionImpl.this.listens.get(listen.getQuery())) == listen) {
                    if (!status.equals("ok")) {
                        PersistentConnectionImpl.this.removeListen(listen.getQuery());
                        String errorMessage = (String)response.get("d");
                        listen.resultCallback.onRequestResult(status, errorMessage);
                    } else {
                        listen.resultCallback.onRequestResult(null, null);
                    }
                }
            }
        });
    }

    private void sendStats(Map<String, Integer> stats) {
        if (!stats.isEmpty()) {
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("c", stats);
            this.sendAction("s", request, new ConnectionRequestCallback(){

                @Override
                public void onResponse(Map<String, Object> response) {
                    String status = (String)response.get("s");
                    if (!status.equals("ok")) {
                        String errorMessage = (String)response.get("d");
                        if (PersistentConnectionImpl.this.logger.logsDebug()) {
                            PersistentConnectionImpl.this.logger.debug("Failed to send stats: " + status + " (message: " + errorMessage + ")", new Object[0]);
                        }
                    }
                }
            });
        } else if (this.logger.logsDebug()) {
            this.logger.debug("Not sending stats because stats are empty", new Object[0]);
        }
    }

    private void warnOnListenerWarnings(List<String> warnings, ListenQuerySpec query) {
        if (warnings.contains("no_index")) {
            String indexSpec = "\".indexOn\": \"" + query.queryParams.get("i") + '\"';
            this.logger.warn("Using an unspecified index. Consider adding '" + indexSpec + "' at " + ConnectionUtils.pathToString(query.path) + " to your security and Firebase Database rules for better performance");
        }
    }

    private void sendConnectStats() {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        assert (!this.context.isPersistenceEnabled()) : "Stats for persistence on JVM missing (persistence not yet supported)";
        stats.put("sdk.admin_java." + this.context.getClientSdkVersion().replace('.', '-'), 1);
        if (this.logger.logsDebug()) {
            this.logger.debug("Sending first connection stats", new Object[0]);
        }
        this.sendStats(stats);
    }

    private void sendAction(String action, Map<String, Object> message, ConnectionRequestCallback onResponse) {
        this.sendSensitive(action, false, message, onResponse);
    }

    private void sendSensitive(String action, boolean isSensitive, Map<String, Object> message, ConnectionRequestCallback onResponse) {
        long rn = this.nextRequestNumber();
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put(REQUEST_NUMBER, rn);
        request.put("a", action);
        request.put("b", message);
        this.realtime.sendRequest(request, isSensitive);
        this.requestCBHash.put(rn, onResponse);
    }

    private long nextRequestNumber() {
        return this.requestCounter++;
    }

    private void doIdleCheck() {
        if (this.isIdle()) {
            if (this.inactivityTimer != null) {
                this.inactivityTimer.cancel(false);
            }
            this.inactivityTimer = this.executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    PersistentConnectionImpl.this.inactivityTimer = null;
                    if (PersistentConnectionImpl.this.idleHasTimedOut()) {
                        PersistentConnectionImpl.this.interrupt(PersistentConnectionImpl.IDLE_INTERRUPT_REASON);
                    } else {
                        PersistentConnectionImpl.this.doIdleCheck();
                    }
                }
            }, 60000L, TimeUnit.MILLISECONDS);
        } else if (this.isInterrupted(IDLE_INTERRUPT_REASON)) {
            ConnectionUtils.hardAssert(!this.isIdle());
            this.resume(IDLE_INTERRUPT_REASON);
        }
    }

    private boolean isIdle() {
        return this.listens.isEmpty() && this.requestCBHash.isEmpty() && !this.hasOnDisconnects && this.outstandingPuts.isEmpty();
    }

    private boolean idleHasTimedOut() {
        long now = System.currentTimeMillis();
        return this.isIdle() && now > this.lastWriteTimestamp + 60000L;
    }

    private static class DefaultConnectionFactory
    implements ConnectionFactory {
        private DefaultConnectionFactory() {
        }

        @Override
        public Connection newConnection(PersistentConnectionImpl delegate) {
            return new Connection(delegate.context, delegate.hostInfo, delegate.cachedHost, delegate, delegate.lastSessionId);
        }
    }

    static interface ConnectionFactory {
        public Connection newConnection(PersistentConnectionImpl var1);
    }

    private static class OutstandingDisconnect {
        private final String action;
        private final List<String> path;
        private final Object data;
        private final RequestResultCallback onComplete;

        private OutstandingDisconnect(String action, List<String> path, Object data, RequestResultCallback onComplete) {
            this.action = action;
            this.path = path;
            this.data = data;
            this.onComplete = onComplete;
        }

        public String getAction() {
            return this.action;
        }

        public List<String> getPath() {
            return this.path;
        }

        public Object getData() {
            return this.data;
        }

        public RequestResultCallback getOnComplete() {
            return this.onComplete;
        }
    }

    private static class OutstandingPut {
        private String action;
        private Map<String, Object> request;
        private RequestResultCallback onComplete;
        private boolean sent;

        private OutstandingPut(String action, Map<String, Object> request, RequestResultCallback onComplete) {
            this.action = action;
            this.request = request;
            this.onComplete = onComplete;
        }

        String getAction() {
            return this.action;
        }

        Map<String, Object> getRequest() {
            return this.request;
        }

        RequestResultCallback getOnComplete() {
            return this.onComplete;
        }

        void markSent() {
            this.sent = true;
        }

        boolean wasSent() {
            return this.sent;
        }
    }

    private static class OutstandingListen {
        private final RequestResultCallback resultCallback;
        private final ListenQuerySpec query;
        private final ListenHashProvider hashFunction;
        private final Long tag;

        private OutstandingListen(RequestResultCallback callback, ListenQuerySpec query, Long tag, ListenHashProvider hashFunction) {
            this.resultCallback = callback;
            this.query = query;
            this.hashFunction = hashFunction;
            this.tag = tag;
        }

        ListenQuerySpec getQuery() {
            return this.query;
        }

        Long getTag() {
            return this.tag;
        }

        ListenHashProvider getHashFunction() {
            return this.hashFunction;
        }

        public String toString() {
            return this.query.toString() + " (Tag: " + this.tag + ")";
        }
    }

    private static class ListenQuerySpec {
        private final List<String> path;
        private final Map<String, Object> queryParams;

        public ListenQuerySpec(List<String> path, Map<String, Object> queryParams) {
            this.path = path;
            this.queryParams = queryParams;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ListenQuerySpec)) {
                return false;
            }
            ListenQuerySpec that = (ListenQuerySpec)o;
            if (!this.path.equals(that.path)) {
                return false;
            }
            return this.queryParams.equals(that.queryParams);
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = 31 * result + this.queryParams.hashCode();
            return result;
        }

        public String toString() {
            return ConnectionUtils.pathToString(this.path) + " (params: " + this.queryParams + ")";
        }
    }

    private static interface ConnectionRequestCallback {
        public void onResponse(Map<String, Object> var1);
    }

    private static enum ConnectionState {
        Disconnected,
        GettingToken,
        Connecting,
        Authenticating,
        Connected;

    }
}

