/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.Reusable;
import dagger.internal.codegen.AutoValue_Scope;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.SimpleAnnotationMirror;
import dagger.producers.ProductionScope;
import dagger.releasablereferences.CanReleaseReferences;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

abstract class Scope {
    Scope() {
    }

    abstract Equivalence.Wrapper<AnnotationMirror> scopeAnnotation();

    static Scope scope(AnnotationMirror scopeAnnotation) {
        Preconditions.checkArgument((boolean)Scope.isScope(scopeAnnotation));
        return new AutoValue_Scope((Equivalence.Wrapper<AnnotationMirror>)AnnotationMirrors.equivalence().wrap((Object)scopeAnnotation));
    }

    static boolean isScope(AnnotationMirror scopeAnnotation) {
        return Scope.isScope(MoreElements.asType(scopeAnnotation.getAnnotationType().asElement()));
    }

    static boolean isScope(TypeElement scopeAnnotationType) {
        return MoreElements.isAnnotationPresent(scopeAnnotationType, javax.inject.Scope.class);
    }

    static Scope scope(TypeElement scopeType) {
        return Scope.scope(SimpleAnnotationMirror.of(scopeType));
    }

    private static Scope scope(Elements elements, Class<? extends Annotation> scopeAnnotationClass) {
        return Scope.scope(elements.getTypeElement(scopeAnnotationClass.getCanonicalName()));
    }

    static ImmutableSet<Scope> scopesOf(Element element) {
        return FluentIterable.from(InjectionAnnotations.getScopes(element)).transform(Scope::scope).toSet();
    }

    static Optional<Scope> uniqueScopeOf(Element element) {
        ImmutableSet<? extends AnnotationMirror> scopeAnnotations = InjectionAnnotations.getScopes(element);
        if (scopeAnnotations.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)Scope.scope((AnnotationMirror)Iterables.getOnlyElement(scopeAnnotations)));
    }

    static Scope productionScope(Elements elements) {
        return Scope.scope(elements, ProductionScope.class);
    }

    static Scope singletonScope(Elements elements) {
        return Scope.scope(elements, Singleton.class);
    }

    static Scope reusableScope(Elements elements) {
        return Scope.scope(elements, Reusable.class);
    }

    boolean canReleaseReferences() {
        return MoreElements.isAnnotationPresent(this.scopeAnnotationElement(), CanReleaseReferences.class) || !this.releasableReferencesMetadata().isEmpty();
    }

    ImmutableSet<? extends AnnotationMirror> releasableReferencesMetadata() {
        return AnnotationMirrors.getAnnotatedAnnotations(this.scopeAnnotationElement(), CanReleaseReferences.class);
    }

    Optional<AnnotationMirror> releasableReferencesMetadata(TypeMirror metadataType) {
        for (AnnotationMirror metadata : this.releasableReferencesMetadata()) {
            if (!MoreTypes.equivalence().equivalent((Object)metadata.getAnnotationType(), (Object)metadataType)) continue;
            return Optional.of((Object)metadata);
        }
        return Optional.absent();
    }

    public String getReadableSource() {
        return ErrorMessages.stripCommonTypePrefixes("@" + this.getQualifiedName());
    }

    public String getQualifiedName() {
        return this.scopeAnnotationElement().getQualifiedName().toString();
    }

    public TypeElement scopeAnnotationElement() {
        return MoreTypes.asTypeElement(((AnnotationMirror)this.scopeAnnotation().get()).getAnnotationType());
    }

    public String toString() {
        return ((AnnotationMirror)this.scopeAnnotation().get()).toString();
    }
}

