/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.AutoValue_OptionalFactories_PresentFactorySpec;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.FrameworkType;
import dagger.internal.codegen.OptionalType;
import dagger.internal.codegen.TypeNames;
import dagger.producers.internal.Producers;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Provider;
import javax.lang.model.element.Modifier;

final class OptionalFactories {
    private final Map<PresentFactorySpec, TypeSpec> presentFactoryClasses = new TreeMap<PresentFactorySpec, TypeSpec>(Comparator.comparing(PresentFactorySpec::valueKind).thenComparing(PresentFactorySpec::bindingType).thenComparing(PresentFactorySpec::optionalKind));
    private final Map<OptionalType.OptionalKind, MethodSpec> absentOptionalProviderMethods = new TreeMap<OptionalType.OptionalKind, MethodSpec>();
    private final Map<OptionalType.OptionalKind, FieldSpec> absentOptionalProviderFields = new TreeMap<OptionalType.OptionalKind, FieldSpec>();

    OptionalFactories() {
    }

    CodeBlock absentOptionalProvider(ContributionBinding binding) {
        OptionalType.OptionalKind optionalKind = OptionalType.from(binding.key()).kind();
        return CodeBlock.of("$N()", this.absentOptionalProviderMethods.computeIfAbsent(optionalKind, this::absentOptionalProviderMethod));
    }

    private MethodSpec absentOptionalProviderMethod(OptionalType.OptionalKind optionalKind) {
        TypeVariableName typeVariable = TypeVariableName.get("T");
        return MethodSpec.methodBuilder(String.format("absent%sProvider", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, optionalKind.name()))).addModifiers(Modifier.PRIVATE, Modifier.STATIC).addTypeVariable(typeVariable).returns(TypeNames.providerOf(optionalKind.of(typeVariable))).addJavadoc("Returns a {@link $T} that returns {@code $L}.", Provider.class, optionalKind.absentValueExpression()).addCode("$L // safe covariant cast\n", AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])).addCode("$1T provider = ($1T) $2N;", TypeNames.providerOf(optionalKind.of(typeVariable)), this.absentOptionalProviderFields.computeIfAbsent(optionalKind, this::absentOptionalProviderField)).addCode("return provider;", new Object[0]).build();
    }

    private FieldSpec absentOptionalProviderField(OptionalType.OptionalKind optionalKind) {
        return FieldSpec.builder(TypeNames.PROVIDER, String.format("ABSENT_%s_PROVIDER", optionalKind.name()), Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.RAWTYPES, new AnnotationSpecs.Suppression[0])).initializer("$T.create($L)", InstanceFactory.class, optionalKind.absentValueExpression()).addJavadoc("A {@link $T} that returns {@code $L}.", Provider.class, optionalKind.absentValueExpression()).build();
    }

    CodeBlock presentOptionalFactory(ContributionBinding binding, CodeBlock delegateFactory) {
        return CodeBlock.of("$N.of($L)", this.presentFactoryClasses.computeIfAbsent(PresentFactorySpec.of(binding), this::presentOptionalFactoryClass), delegateFactory);
    }

    private TypeSpec presentOptionalFactoryClass(PresentFactorySpec spec) {
        FieldSpec delegateField = FieldSpec.builder(spec.delegateType(), "delegate", Modifier.PRIVATE, Modifier.FINAL).build();
        ParameterSpec delegateParameter = ParameterSpec.builder(delegateField.type, "delegate", new Modifier[0]).build();
        MethodSpec.Builder getMethodBuilder = MethodSpec.methodBuilder("get").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC);
        block0 : switch (spec.bindingType()) {
            case PROVISION: {
                getMethodBuilder.returns(spec.optionalType()).addCode("return $L;", spec.optionalKind().presentExpression(FrameworkType.PROVIDER.to(spec.valueKind(), CodeBlock.of("$N", delegateField))));
                break;
            }
            case PRODUCTION: {
                getMethodBuilder.returns(TypeNames.listenableFutureOf(spec.optionalType()));
                switch (spec.valueKind()) {
                    case FUTURE: 
                    case PRODUCER: {
                        getMethodBuilder.addCode("return $T.immediateFuture($L);", Futures.class, spec.optionalKind().presentExpression(FrameworkType.PRODUCER.to(spec.valueKind(), CodeBlock.of("$N", delegateField))));
                        break block0;
                    }
                    case INSTANCE: {
                        getMethodBuilder.addCode("return $L;", OptionalFactories.transformFutureToOptional(spec.optionalKind(), spec.typeVariable(), CodeBlock.of("$N.get()", delegateField)));
                        break block0;
                    }
                    case PRODUCED: {
                        getMethodBuilder.addCode("return $L;", OptionalFactories.transformFutureToOptional(spec.optionalKind(), spec.valueType(), CodeBlock.of("$T.createFutureProduced($N.get())", Producers.class, delegateField)));
                        break block0;
                    }
                }
                throw new UnsupportedOperationException(spec.factoryType() + " objects are not supported");
            }
            default: {
                throw new AssertionError((Object)spec.bindingType());
            }
        }
        return TypeSpec.classBuilder(spec.factoryClassName()).addTypeVariable(spec.typeVariable()).addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addSuperinterface(spec.factoryType()).addJavadoc("A {@code $T} that uses a delegate {@code $T}.", spec.factoryType(), delegateField.type).addField(delegateField).addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).addParameter(delegateParameter).addCode("this.$N = $T.checkNotNull($N);", delegateField, Preconditions.class, delegateParameter).build()).addMethod(getMethodBuilder.build()).addMethod(MethodSpec.methodBuilder("of").addModifiers(Modifier.PRIVATE, Modifier.STATIC).addTypeVariable(spec.typeVariable()).returns(spec.factoryType()).addParameter(delegateParameter).addCode("return new $L<$T>($N);", spec.factoryClassName(), spec.typeVariable(), delegateParameter).build()).build();
    }

    private static CodeBlock transformFutureToOptional(OptionalType.OptionalKind optionalKind, TypeName inputType, CodeBlock inputFuture) {
        return CodeBlock.of("$T.transform($L, $L)", Futures.class, inputFuture, TypeSpec.anonymousClassBuilder("", new Object[0]).addSuperinterface(ParameterizedTypeName.get(ClassName.get(Function.class), inputType, optionalKind.of(inputType))).addMethod(MethodSpec.methodBuilder("apply").addAnnotation(Override.class).addModifiers(Modifier.PUBLIC).returns(optionalKind.of(inputType)).addParameter(inputType, "input", new Modifier[0]).addCode("return $L;", optionalKind.presentExpression(CodeBlock.of("input", new Object[0]))).build()).build());
    }

    void addMembers(TypeSpec.Builder component) {
        component.addTypes(this.presentFactoryClasses.values());
        component.addMethods(this.absentOptionalProviderMethods.values());
        component.addFields(this.absentOptionalProviderFields.values());
    }

    static abstract class PresentFactorySpec {
        PresentFactorySpec() {
        }

        abstract BindingType bindingType();

        abstract OptionalType.OptionalKind optionalKind();

        abstract DependencyRequest.Kind valueKind();

        TypeVariableName typeVariable() {
            return TypeVariableName.get("T");
        }

        TypeName valueType() {
            return this.valueKind().typeName(this.typeVariable());
        }

        ParameterizedTypeName optionalType() {
            return this.optionalKind().of(this.valueType());
        }

        ParameterizedTypeName factoryType() {
            return this.bindingType().frameworkClassOf(this.optionalType());
        }

        ParameterizedTypeName delegateType() {
            return this.bindingType().frameworkClassOf(this.typeVariable());
        }

        String factoryClassName() {
            return "Present" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.optionalKind().name()) + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.valueKind().toString()) + this.bindingType().frameworkClass().getSimpleName();
        }

        private static PresentFactorySpec of(ContributionBinding binding) {
            OptionalType.OptionalKind optionalKind = OptionalType.from(binding.key()).kind();
            DependencyRequest.Kind valueKind = DependencyRequest.extractKindAndType(OptionalType.from(binding.key()).valueType()).kind();
            return new AutoValue_OptionalFactories_PresentFactorySpec(binding.bindingType(), optionalKind, valueKind);
        }
    }
}

