/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.BindingMethodValidator;
import dagger.internal.codegen.BindsMethodValidator;
import dagger.internal.codegen.BindsOptionalOfMethodValidator;
import dagger.internal.codegen.FactoryGenerator;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.MultibindsMethodValidator;
import dagger.internal.codegen.ProducerFactoryGenerator;
import dagger.internal.codegen.ProducesMethodValidator;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvidesMethodValidator;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class ModuleProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final Class<? extends Annotation> moduleAnnotation;
    private final ModuleValidator moduleValidator;
    private final ImmutableSet<ModuleMethodFactoryGenerator> moduleMethodFactoryGenerators;
    private final ImmutableSet<? extends BindingMethodValidator> methodValidators;
    private final Set<TypeElement> processedModuleElements = Sets.newLinkedHashSet();

    static ModuleProcessingStep moduleProcessingStep(Messager messager, ModuleValidator moduleValidator, ProvisionBinding.Factory provisionBindingFactory, FactoryGenerator factoryGenerator, ProvidesMethodValidator providesMethodValidator, BindsMethodValidator bindsMethodValidator, MultibindsMethodValidator multibindsMethodValidator, BindsOptionalOfMethodValidator bindsOptionalOfMethodValidator) {
        return new ModuleProcessingStep(messager, Module.class, moduleValidator, (ImmutableSet<ModuleMethodFactoryGenerator>)ImmutableSet.of((Object)new ProvisionModuleMethodFactoryGenerator(provisionBindingFactory, factoryGenerator)), (Iterable<? extends BindingMethodValidator>)ImmutableSet.of((Object)providesMethodValidator, (Object)bindsMethodValidator, (Object)multibindsMethodValidator, (Object)bindsOptionalOfMethodValidator));
    }

    static ModuleProcessingStep producerModuleProcessingStep(Messager messager, ModuleValidator moduleValidator, ProvisionBinding.Factory provisionBindingFactory, FactoryGenerator factoryGenerator, ProvidesMethodValidator providesMethodValidator, ProductionBinding.Factory productionBindingFactory, ProducerFactoryGenerator producerFactoryGenerator, ProducesMethodValidator producesMethodValidator, BindsMethodValidator bindsMethodValidator, MultibindsMethodValidator multibindsMethodValidator, BindsOptionalOfMethodValidator bindsOptionalOfMethodValidator) {
        return new ModuleProcessingStep(messager, ProducerModule.class, moduleValidator, (ImmutableSet<ModuleMethodFactoryGenerator>)ImmutableSet.of((Object)new ProvisionModuleMethodFactoryGenerator(provisionBindingFactory, factoryGenerator), (Object)new ProductionModuleMethodFactoryGenerator(productionBindingFactory, producerFactoryGenerator)), (Iterable<? extends BindingMethodValidator>)ImmutableSet.of((Object)providesMethodValidator, (Object)producesMethodValidator, (Object)bindsMethodValidator, (Object)multibindsMethodValidator, (Object)bindsOptionalOfMethodValidator));
    }

    ModuleProcessingStep(Messager messager, Class<? extends Annotation> moduleAnnotation, ModuleValidator moduleValidator, ImmutableSet<ModuleMethodFactoryGenerator> moduleMethodFactoryGenerators, Iterable<? extends BindingMethodValidator> methodValidators) {
        this.messager = messager;
        this.moduleAnnotation = moduleAnnotation;
        this.moduleValidator = moduleValidator;
        this.moduleMethodFactoryGenerators = moduleMethodFactoryGenerators;
        this.methodValidators = ImmutableSet.copyOf(methodValidators);
    }

    @Override
    public Set<? extends Class<? extends Annotation>> annotations() {
        ImmutableSet.Builder annotations = ImmutableSet.builder();
        annotations.add(this.moduleAnnotation);
        for (BindingMethodValidator validator : this.methodValidators) {
            annotations.add(validator.methodAnnotation());
        }
        return annotations.build();
    }

    @Override
    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet<ExecutableElement> validMethods = this.validMethods(elementsByAnnotation);
        for (TypeElement moduleElement : Sets.difference(ElementFilter.typesIn(elementsByAnnotation.get(this.moduleAnnotation)), this.processedModuleElements)) {
            List<ExecutableElement> moduleMethods;
            ValidationReport<TypeElement> report = this.moduleValidator.validate(moduleElement);
            report.printMessagesTo(this.messager);
            if (report.isClean() && this.moduleMethodsAreValid(validMethods, moduleMethods = ElementFilter.methodsIn(moduleElement.getEnclosedElements()))) {
                for (ModuleMethodFactoryGenerator generator : this.moduleMethodFactoryGenerators) {
                    for (ExecutableElement method : Util.elementsWithAnnotation(moduleMethods, generator.factoryMethodAnnotation())) {
                        generator.generate(method, moduleElement, this.messager);
                    }
                }
            }
            this.processedModuleElements.add(moduleElement);
        }
        return ImmutableSet.of();
    }

    private ImmutableSet<ExecutableElement> validMethods(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet.Builder validMethods = ImmutableSet.builder();
        for (BindingMethodValidator validator : this.methodValidators) {
            validMethods.addAll(validator.validate(this.messager, ElementFilter.methodsIn(elementsByAnnotation.get(validator.methodAnnotation()))));
        }
        return validMethods.build();
    }

    private boolean moduleMethodsAreValid(ImmutableSet<ExecutableElement> validMethods, Iterable<ExecutableElement> moduleMethods) {
        for (ExecutableElement methodElement : moduleMethods) {
            if (validMethods.contains((Object)methodElement)) continue;
            for (BindingMethodValidator validator : this.methodValidators) {
                if (!MoreElements.isAnnotationPresent(methodElement, validator.methodAnnotation())) continue;
                return false;
            }
        }
        return true;
    }

    private static final class ProductionModuleMethodFactoryGenerator
    implements ModuleMethodFactoryGenerator {
        private final ProductionBinding.Factory productionBindingFactory;
        private final ProducerFactoryGenerator producerFactoryGenerator;

        ProductionModuleMethodFactoryGenerator(ProductionBinding.Factory productionBindingFactory, ProducerFactoryGenerator productionFactoryGenerator) {
            this.productionBindingFactory = productionBindingFactory;
            this.producerFactoryGenerator = productionFactoryGenerator;
        }

        @Override
        public Class<? extends Annotation> factoryMethodAnnotation() {
            return Produces.class;
        }

        @Override
        public void generate(ExecutableElement method, TypeElement moduleElement, Messager messager) {
            this.producerFactoryGenerator.generate(this.productionBindingFactory.forProducesMethod(method, moduleElement), messager);
        }
    }

    private static final class ProvisionModuleMethodFactoryGenerator
    implements ModuleMethodFactoryGenerator {
        private final ProvisionBinding.Factory provisionBindingFactory;
        private final FactoryGenerator factoryGenerator;

        ProvisionModuleMethodFactoryGenerator(ProvisionBinding.Factory provisionBindingFactory, FactoryGenerator factoryGenerator) {
            this.provisionBindingFactory = provisionBindingFactory;
            this.factoryGenerator = factoryGenerator;
        }

        @Override
        public Class<? extends Annotation> factoryMethodAnnotation() {
            return Provides.class;
        }

        @Override
        public void generate(ExecutableElement method, TypeElement moduleElement, Messager messager) {
            this.factoryGenerator.generate(this.provisionBindingFactory.forProvidesMethod(method, moduleElement), messager);
        }
    }

    static interface ModuleMethodFactoryGenerator {
        public Class<? extends Annotation> factoryMethodAnnotation();

        public void generate(ExecutableElement var1, TypeElement var2, Messager var3);
    }
}

