/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import dagger.MapKey;
import dagger.internal.codegen.ValidationReport;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;

final class MapKeyValidator {
    MapKeyValidator() {
    }

    ValidationReport<Element> validate(Element element) {
        ValidationReport.Builder<Element> builder = ValidationReport.about(element);
        List<ExecutableElement> members = ElementFilter.methodsIn(((TypeElement)element).getEnclosedElements());
        if (members.isEmpty()) {
            builder.addError("Map key annotations must have members", element);
        } else if (element.getAnnotation(MapKey.class).unwrapValue()) {
            if (members.size() > 1) {
                builder.addError("Map key annotations with unwrapped values must have exactly one member", element);
            } else if (members.get(0).getReturnType().getKind() == TypeKind.ARRAY) {
                builder.addError("Map key annotations with unwrapped values cannot use arrays", element);
            }
        }
        return builder.build();
    }
}

