/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class InjectValidator {
    private final Types types;
    private final Elements elements;
    private final CompilerOptions compilerOptions;
    private final Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind;

    InjectValidator(Types types, Elements elements, CompilerOptions compilerOptions) {
        this(types, elements, compilerOptions, (Optional<Diagnostic.Kind>)Optional.absent());
    }

    private InjectValidator(Types types, Elements elements, CompilerOptions compilerOptions, Optional<Diagnostic.Kind> privateAndStaticInjectionDiagnosticKind) {
        this.types = types;
        this.elements = elements;
        this.compilerOptions = compilerOptions;
        this.privateAndStaticInjectionDiagnosticKind = privateAndStaticInjectionDiagnosticKind;
    }

    InjectValidator whenGeneratingCode() {
        return this.compilerOptions.ignorePrivateAndStaticInjectionForComponent() ? new InjectValidator(this.types, this.elements, this.compilerOptions, (Optional<Diagnostic.Kind>)Optional.of((Object)((Object)Diagnostic.Kind.ERROR))) : this;
    }

    ValidationReport<TypeElement> validateConstructor(ExecutableElement constructorElement) {
        ImmutableSet<? extends AnnotationMirror> scopes;
        ImmutableSet<ExecutableElement> injectConstructors;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(MoreElements.asType(constructorElement.getEnclosingElement()));
        if (constructorElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            builder.addError("Dagger does not support injection into private constructors", constructorElement);
        }
        for (AnnotationMirror qualifier : InjectionAnnotations.getQualifiers(constructorElement)) {
            builder.addError("@Qualifier annotations are not allowed on @Inject constructors.", constructorElement, qualifier);
        }
        for (AnnotationMirror scope : InjectionAnnotations.getScopes(constructorElement)) {
            builder.addError("@Scope annotations are not allowed on @Inject constructors. Annotate the class instead.", constructorElement, scope);
        }
        for (VariableElement parameter : constructorElement.getParameters()) {
            ImmutableSet<? extends AnnotationMirror> qualifiers = InjectionAnnotations.getQualifiers(parameter);
            if (qualifiers.size() > 1) {
                for (AnnotationMirror qualifier : qualifiers) {
                    builder.addError("A single injection site may not use more than one @Qualifier.", constructorElement, qualifier);
                }
            }
            if (!FrameworkTypes.isProducerType(parameter.asType())) continue;
            builder.addError(ErrorMessages.provisionMayNotDependOnProducerType(parameter.asType()), parameter);
        }
        if (this.throwsCheckedExceptions(constructorElement)) {
            builder.addItem("Dagger does not support checked exceptions on @Inject constructors.", (Diagnostic.Kind)((Object)this.privateAndStaticInjectionDiagnosticKind.or((Object)this.compilerOptions.privateMemberValidationKind())), constructorElement);
        }
        TypeElement enclosingElement = MoreElements.asType(constructorElement.getEnclosingElement());
        Set<Modifier> typeModifiers = enclosingElement.getModifiers();
        if (!Accessibility.isElementAccessibleFromOwnPackage(enclosingElement)) {
            builder.addItem("Dagger does not support injection into private classes", (Diagnostic.Kind)((Object)this.privateAndStaticInjectionDiagnosticKind.or((Object)this.compilerOptions.privateMemberValidationKind())), constructorElement);
        }
        if (typeModifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError("@Inject is nonsense on the constructor of an abstract class", constructorElement);
        }
        if (enclosingElement.getNestingKind().isNested() && !typeModifiers.contains((Object)Modifier.STATIC)) {
            builder.addError("@Inject constructors are invalid on inner classes", constructorElement);
        }
        if ((injectConstructors = InjectionAnnotations.injectedConstructors(enclosingElement)).size() > 1) {
            builder.addError("Types may only contain one @Inject constructor.", constructorElement);
        }
        if ((scopes = InjectionAnnotations.getScopes(enclosingElement)).size() > 1) {
            for (AnnotationMirror scope : scopes) {
                builder.addError("A single binding may not declare more than one @Scope.", enclosingElement, scope);
            }
        }
        return builder.build();
    }

    private ValidationReport<VariableElement> validateField(VariableElement fieldElement) {
        ImmutableSet<? extends AnnotationMirror> qualifiers;
        ValidationReport.Builder<VariableElement> builder = ValidationReport.about(fieldElement);
        Set<Modifier> modifiers = fieldElement.getModifiers();
        if (modifiers.contains((Object)Modifier.FINAL)) {
            builder.addError("@Inject fields may not be final", fieldElement);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private fields", (Diagnostic.Kind)((Object)this.privateAndStaticInjectionDiagnosticKind.or((Object)this.compilerOptions.privateMemberValidationKind())), fieldElement);
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem("Dagger does not support injection into static fields", (Diagnostic.Kind)((Object)this.privateAndStaticInjectionDiagnosticKind.or((Object)this.compilerOptions.staticMemberValidationKind())), fieldElement);
        }
        if ((qualifiers = InjectionAnnotations.getQualifiers(fieldElement)).size() > 1) {
            for (AnnotationMirror qualifier : qualifiers) {
                builder.addError("A single injection site may not use more than one @Qualifier.", fieldElement, qualifier);
            }
        }
        if (FrameworkTypes.isProducerType(fieldElement.asType())) {
            builder.addError(ErrorMessages.provisionMayNotDependOnProducerType(fieldElement.asType()), fieldElement);
        }
        return builder.build();
    }

    private ValidationReport<ExecutableElement> validateMethod(ExecutableElement methodElement) {
        ValidationReport.Builder<ExecutableElement> builder = ValidationReport.about(methodElement);
        Set<Modifier> modifiers = methodElement.getModifiers();
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addError("Methods with @Inject may not be abstract.", methodElement);
        }
        if (modifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private methods", (Diagnostic.Kind)((Object)this.privateAndStaticInjectionDiagnosticKind.or((Object)this.compilerOptions.privateMemberValidationKind())), methodElement);
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem("Dagger does not support injection into static methods", (Diagnostic.Kind)((Object)this.privateAndStaticInjectionDiagnosticKind.or((Object)this.compilerOptions.staticMemberValidationKind())), methodElement);
        }
        if (!methodElement.getTypeParameters().isEmpty()) {
            builder.addError("Methods with @Inject may not declare type parameters.", methodElement);
        }
        for (VariableElement variableElement : methodElement.getParameters()) {
            ImmutableSet<? extends AnnotationMirror> qualifiers = InjectionAnnotations.getQualifiers(variableElement);
            if (qualifiers.size() > 1) {
                for (AnnotationMirror qualifier : qualifiers) {
                    builder.addError("A single injection site may not use more than one @Qualifier.", methodElement, qualifier);
                }
            }
            if (!FrameworkTypes.isProducerType(variableElement.asType())) continue;
            builder.addError(ErrorMessages.provisionMayNotDependOnProducerType(variableElement.asType()), variableElement);
        }
        return builder.build();
    }

    ValidationReport<TypeElement> validateMembersInjectionType(TypeElement typeElement) {
        ValidationReport<TypeElement> validationReport;
        TypeMirror superclass;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(typeElement);
        boolean hasInjectedMembers = false;
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!MoreElements.isAnnotationPresent(variableElement, Inject.class)) continue;
            hasInjectedMembers = true;
            ValidationReport<VariableElement> report2 = this.validateField(variableElement);
            if (report2.isClean()) continue;
            builder.addSubreport(report2);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!MoreElements.isAnnotationPresent(executableElement, Inject.class)) continue;
            hasInjectedMembers = true;
            ValidationReport<ExecutableElement> report = this.validateMethod(executableElement);
            if (report.isClean()) continue;
            builder.addSubreport(report);
        }
        if (hasInjectedMembers && !Accessibility.isElementAccessibleFromOwnPackage(typeElement)) {
            builder.addItem("Dagger does not support injection into private classes", (Diagnostic.Kind)((Object)this.privateAndStaticInjectionDiagnosticKind.or((Object)this.compilerOptions.privateMemberValidationKind())), typeElement);
        }
        if (!(superclass = typeElement.getSuperclass()).getKind().equals((Object)TypeKind.NONE) && !(validationReport = this.validateType(MoreTypes.asTypeElement(superclass))).isClean()) {
            builder.addSubreport(validationReport);
        }
        return builder.build();
    }

    ValidationReport<TypeElement> validateType(TypeElement typeElement) {
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(typeElement);
        ValidationReport<TypeElement> membersInjectionReport = this.validateMembersInjectionType(typeElement);
        if (!membersInjectionReport.isClean()) {
            builder.addSubreport(membersInjectionReport);
        }
        for (ExecutableElement element : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            ValidationReport<TypeElement> report;
            if (!MoreElements.isAnnotationPresent(element, Inject.class) || (report = this.validateConstructor(element)).isClean()) continue;
            builder.addSubreport(report);
        }
        return builder.build();
    }

    boolean isValidType(TypeMirror type) {
        if (!type.getKind().equals((Object)TypeKind.DECLARED)) {
            return true;
        }
        return this.validateType(MoreTypes.asTypeElement(type)).isClean();
    }

    private boolean throwsCheckedExceptions(ExecutableElement methodElement) {
        TypeMirror runtimeExceptionType = this.elements.getTypeElement(RuntimeException.class.getCanonicalName()).asType();
        TypeMirror errorType = this.elements.getTypeElement(Error.class.getCanonicalName()).asType();
        for (TypeMirror typeMirror : methodElement.getThrownTypes()) {
            if (this.types.isSubtype(typeMirror, runtimeExceptionType) || this.types.isSubtype(typeMirror, errorType)) continue;
            return true;
        }
        return false;
    }
}

