/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.Lazy;
import dagger.MembersInjector;
import dagger.producers.Produced;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Set;
import javax.inject.Provider;
import javax.lang.model.type.TypeMirror;

final class FrameworkTypes {
    private static final ImmutableSet<Class<?>> PROVISION_TYPES = ImmutableSet.of(Provider.class, Lazy.class, MembersInjector.class);
    private static final ImmutableSet<Class<?>> PRODUCTION_TYPES = ImmutableSet.of(Produced.class, Producer.class);

    static boolean isProducerType(TypeMirror type) {
        return MoreTypes.isType(type) && FrameworkTypes.typeIsOneOf(PRODUCTION_TYPES, type);
    }

    static boolean isFrameworkType(TypeMirror type) {
        return MoreTypes.isType(type) && (FrameworkTypes.typeIsOneOf(PROVISION_TYPES, type) || FrameworkTypes.typeIsOneOf(PRODUCTION_TYPES, type));
    }

    private static boolean typeIsOneOf(Set<Class<?>> classes, TypeMirror type) {
        for (Class<?> clazz : classes) {
            if (!MoreTypes.isTypeOf(clazz, type)) continue;
            return true;
        }
        return false;
    }

    private FrameworkTypes() {
    }
}

