/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.Binds;
import dagger.Module;
import dagger.internal.codegen.BindingMethodValidator;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.SetType;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class BindsMethodValidator
extends BindingMethodValidator {
    private final Types types;
    private final Elements elements;

    BindsMethodValidator(Elements elements, Types types) {
        super(elements, types, Binds.class, (Iterable<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class, ProducerModule.class), BindingMethodValidator.Abstractness.MUST_BE_ABSTRACT, BindingMethodValidator.ExceptionSuperclass.RUNTIME_EXCEPTION, BindingMethodValidator.AllowsMultibindings.ALLOWS_MULTIBINDINGS);
        this.types = types;
        this.elements = elements;
    }

    @Override
    protected void checkMethod(ValidationReport.Builder<ExecutableElement> builder) {
        super.checkMethod(builder);
        this.checkParameters(builder);
    }

    private void checkParameters(ValidationReport.Builder<ExecutableElement> builder) {
        ExecutableElement method = builder.getSubject();
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() == 1) {
            VariableElement parameter = (VariableElement)Iterables.getOnlyElement(parameters);
            TypeMirror leftHandSide = method.getReturnType();
            TypeMirror rightHandSide = parameter.asType();
            ContributionType contributionType = ContributionType.fromBindingMethod(method);
            switch (contributionType) {
                case SET_VALUES: {
                    if (!SetType.isSet(leftHandSide)) {
                        builder.addError("@Binds @ElementsIntoSet methods must return a Set and take a Set parameter");
                        break;
                    }
                    this.validateTypesAreAssignable(builder, rightHandSide, this.methodParameterType(MoreTypes.asDeclared(leftHandSide), "addAll"));
                    break;
                }
                case SET: {
                    DeclaredType parameterizedSetType = this.types.getDeclaredType(this.setElement(), leftHandSide);
                    this.validateTypesAreAssignable(builder, rightHandSide, this.methodParameterType(parameterizedSetType, "add"));
                    break;
                }
                case MAP: {
                    DeclaredType parameterizedMapType = this.types.getDeclaredType(this.mapElement(), this.unboundedWildcard(), leftHandSide);
                    this.validateTypesAreAssignable(builder, rightHandSide, (TypeMirror)this.methodParameterTypes(parameterizedMapType, "put").get(1));
                    break;
                }
                case UNIQUE: {
                    this.validateTypesAreAssignable(builder, rightHandSide, leftHandSide);
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Unknown contribution type (%s) for method: %s", new Object[]{contributionType, method}));
                }
            }
        } else {
            builder.addError("@Binds methods must have only one parameter whose type is assignable to the return type");
        }
    }

    private ImmutableList<TypeMirror> methodParameterTypes(DeclaredType type, String methodName) {
        ImmutableList.Builder methodsForName = ImmutableList.builder();
        for (ExecutableElement method : ElementFilter.methodsIn(MoreElements.asType(type.asElement()).getEnclosedElements())) {
            if (!method.getSimpleName().contentEquals(methodName)) continue;
            methodsForName.add((Object)method);
        }
        ExecutableElement method = (ExecutableElement)Iterables.getOnlyElement((Iterable)methodsForName.build());
        return ImmutableList.copyOf(MoreTypes.asExecutable(this.types.asMemberOf(type, method)).getParameterTypes());
    }

    private TypeMirror methodParameterType(DeclaredType type, String methodName) {
        return (TypeMirror)Iterables.getOnlyElement(this.methodParameterTypes(type, methodName));
    }

    private void validateTypesAreAssignable(ValidationReport.Builder<ExecutableElement> builder, TypeMirror rightHandSide, TypeMirror leftHandSide) {
        if (!this.types.isAssignable(rightHandSide, leftHandSide)) {
            builder.addError("@Binds methods must have only one parameter whose type is assignable to the return type");
        }
    }

    private TypeElement setElement() {
        return this.elements.getTypeElement(Set.class.getName());
    }

    private TypeElement mapElement() {
        return this.elements.getTypeElement(Map.class.getName());
    }

    private TypeMirror unboundedWildcard() {
        return this.types.getWildcardType(null, null);
    }
}

