/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webworkwebflow;

import com.googlecode.webworkwebflow.WebworkExternalContext;
import com.googlecode.webworkwebflow.WebworkRequestHandler;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ActionSupport;
import com.opensymphony.xwork.config.ConfigurationException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.ResponseInstruction;

public class FlowAction
extends ActionSupport {
    private String flowExecutorBean;
    private FlowExecutor flowExecutor;
    private String flowId;
    private String flowExecutionKey;
    private String eventId;
    static /* synthetic */ Class class$org$springframework$webflow$executor$FlowExecutor;

    public String execute() throws Exception {
        ServletContext servletContext = ServletActionContext.getServletContext();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        ActionInvocation actionInvocation = ActionContext.getContext().getActionInvocation();
        WebworkExternalContext context = new WebworkExternalContext(actionInvocation, servletContext, request, response);
        WebworkRequestHandler handler = this.createRequestHandler();
        handler.setFlowExecutionKey(this.flowExecutionKey);
        handler.setEventId(this.eventId);
        handler.setFlowId(this.flowId);
        ResponseInstruction responseInstruction = handler.handleFlowRequest((ExternalContext)context);
        this.flowExecutionKey = responseInstruction.getFlowExecutionKey();
        return this.toResult(responseInstruction, (ExternalContext)context, actionInvocation);
    }

    protected WebworkRequestHandler createRequestHandler() {
        WebworkRequestHandler handler = new WebworkRequestHandler();
        handler.setFlowExecutor(this.getFlowExecutor());
        return handler;
    }

    protected String toResult(ResponseInstruction response, ExternalContext context, ActionInvocation actionInvocation) {
        if (response.isApplicationView()) {
            ApplicationView forward = (ApplicationView)response.getViewSelection();
            return forward.getViewName();
        }
        if (response.isNull()) {
            return null;
        }
        throw new IllegalArgumentException("Don't know how to handle response instruction " + response);
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getFlowExecutionKey() {
        return this.flowExecutionKey;
    }

    public void setFlowExecutionKey(String flowExecutionKey) {
        this.flowExecutionKey = flowExecutionKey;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public FlowExecutor getFlowExecutor() {
        if (this.flowExecutorBean != null) {
            ServletContext servletContext = ServletActionContext.getServletContext();
            WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
            if (context.containsBean(this.flowExecutorBean)) {
                this.flowExecutor = (FlowExecutor)context.getBean(this.flowExecutorBean, class$org$springframework$webflow$executor$FlowExecutor == null ? (class$org$springframework$webflow$executor$FlowExecutor = FlowAction.class$("org.springframework.webflow.executor.FlowExecutor")) : class$org$springframework$webflow$executor$FlowExecutor);
            } else {
                throw new BeanCreationException("Spring bean: '" + this.flowExecutorBean + "' Not found in WebApplicationContext!");
            }
        }
        if (this.flowExecutor == null) {
            throw new ConfigurationException("flowExecutor not found, please provide a flowExecutor for this FlowAction");
        }
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public String getFlowExecutorBean() {
        return this.flowExecutorBean;
    }

    public void setFlowExecutorBean(String flowExecutorBean) {
        this.flowExecutorBean = flowExecutorBean;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

