/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.webworkwebflow;

import com.googlecode.webworkwebflow.WebworkExternalContext;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.interceptor.Interceptor;
import com.opensymphony.xwork.interceptor.PreResultListener;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRepository;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;

public abstract class AbstractFlowScopeInterceptor
implements Interceptor,
PreResultListener {
    public static final String FLOW_EXECUTION_KEY = "flowExecutionKey";
    private String flowExecutorBean;
    private FlowExecutor flowExecutor;
    private String sessionKey = "SessionFlowExecKeyInterceptor.SESSION_KEY";
    static /* synthetic */ Class class$org$springframework$webflow$executor$FlowExecutor;

    protected boolean inWorkflow() {
        Map contextMap = ActionContext.getContext().getContextMap();
        RequestContext webflowContext = (RequestContext)contextMap.get("com.opensymphony.xwork.ActionContext.context");
        return webflowContext != null;
    }

    protected Map getFlowScopeMap() {
        if (this.inWorkflow()) {
            Map contextMap = ActionContext.getContext().getContextMap();
            RequestContext webflowContext = (RequestContext)contextMap.get("com.opensymphony.xwork.ActionContext.context");
            return webflowContext.getFlowScope().asMap();
        }
        return this.getFlowScopeExternal(this.getFlowExecutor());
    }

    protected Map getFlowScopeExternal(FlowExecutor flowExecutor) {
        FlowExecutionRepository repo = ((FlowExecutorImpl)flowExecutor).getExecutionRepository();
        ActionContext actionContext = ActionContext.getContext();
        ActionInvocation actionInvocation = actionContext.getActionInvocation();
        ServletContext servletContext = ServletActionContext.getServletContext();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        WebworkExternalContext context = new WebworkExternalContext(actionInvocation, servletContext, request, response);
        ExternalContextHolder.setExternalContext((ExternalContext)context);
        String flowExecKey = (String)actionInvocation.getInvocationContext().getParameters().get(FLOW_EXECUTION_KEY);
        if (flowExecKey == null) {
            Map sessionMap = actionContext.getSession();
            flowExecKey = (String)sessionMap.get(this.sessionKey);
        }
        FlowExecutionKey key = repo.parseFlowExecutionKey(flowExecKey);
        FlowExecution flowExecution = repo.getFlowExecution(key);
        MutableAttributeMap attrMap = flowExecution.getActiveSession().getScope();
        return attrMap.asMap();
    }

    public void init() {
    }

    public void destroy() {
    }

    public FlowExecutor getFlowExecutor() {
        if (this.flowExecutorBean != null) {
            ServletContext servletContext = ServletActionContext.getServletContext();
            WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
            if (context.containsBean(this.flowExecutorBean)) {
                this.flowExecutor = (FlowExecutor)context.getBean(this.flowExecutorBean, class$org$springframework$webflow$executor$FlowExecutor == null ? (class$org$springframework$webflow$executor$FlowExecutor = AbstractFlowScopeInterceptor.class$("org.springframework.webflow.executor.FlowExecutor")) : class$org$springframework$webflow$executor$FlowExecutor);
            } else {
                throw new BeanCreationException("Spring bean: '" + this.flowExecutorBean + "' Not found in WebApplicationContext!");
            }
        }
        if (this.flowExecutor == null) {
            throw new ConfigurationException("flowExecutor not found, please provide a flowExecutor for this FlowAction");
        }
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public String getFlowExecutorBean() {
        return this.flowExecutorBean;
    }

    public void setFlowExecutorBean(String flowExecutorBean) {
        this.flowExecutorBean = flowExecutorBean;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ String intercept(ActionInvocation var1) throws Exception;

    public abstract /* synthetic */ void beforeResult(ActionInvocation var1, String var2);
}

