/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.storage.BidiResumableWrite;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.GapicBidiWritableByteChannelSessionBuilder;
import com.google.cloud.storage.GapicWritableByteChannelSessionBuilder;
import com.google.cloud.storage.ResumableWrite;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnifiedOpts;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import java.util.function.Function;

final class GapicUploadSessionBuilder {
    private GapicUploadSessionBuilder() {
    }

    static GapicUploadSessionBuilder create() {
        return new GapicUploadSessionBuilder();
    }

    GapicWritableByteChannelSessionBuilder byteChannel(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write) {
        return new GapicWritableByteChannelSessionBuilder(write);
    }

    GapicBidiWritableByteChannelSessionBuilder bidiByteChannel(BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write) {
        return new GapicBidiWritableByteChannelSessionBuilder(write);
    }

    ApiFuture<ResumableWrite> resumableWrite(UnaryCallable<StartResumableWriteRequest, StartResumableWriteResponse> callable, WriteObjectRequest writeObjectRequest, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts, Retrying.RetrierWithAlg retrier) {
        StartResumableWriteRequest.Builder b = StartResumableWriteRequest.newBuilder();
        if (writeObjectRequest.hasWriteObjectSpec()) {
            b.setWriteObjectSpec(writeObjectRequest.getWriteObjectSpec());
        }
        if (writeObjectRequest.hasCommonObjectRequestParams()) {
            b.setCommonObjectRequestParams(writeObjectRequest.getCommonObjectRequestParams());
        }
        if (writeObjectRequest.hasObjectChecksums()) {
            b.setObjectChecksums(writeObjectRequest.getObjectChecksums());
        }
        StartResumableWriteRequest req = opts.startResumableWriteRequest().apply(b).build();
        Function<String, WriteObjectRequest> f = uploadId -> writeObjectRequest.toBuilder().clearWriteObjectSpec().setUploadId(uploadId).build();
        SettableApiFuture future = SettableApiFuture.create();
        try {
            ResumableWrite resumableWrite = (ResumableWrite)retrier.run(() -> {
                StartResumableWriteResponse resp = (StartResumableWriteResponse)callable.call((Object)req);
                return new ResumableWrite(req, resp, f);
            }, Conversions.Decoder.identity());
            future.set((Object)resumableWrite);
        }
        catch (StorageException e) {
            future.setException((Throwable)((Object)e));
        }
        return future;
    }

    ApiFuture<BidiResumableWrite> bidiResumableWrite(UnaryCallable<StartResumableWriteRequest, StartResumableWriteResponse> x, BidiWriteObjectRequest writeObjectRequest, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts, Retrying.RetrierWithAlg retrier) {
        StartResumableWriteRequest.Builder b = StartResumableWriteRequest.newBuilder();
        if (writeObjectRequest.hasWriteObjectSpec()) {
            b.setWriteObjectSpec(writeObjectRequest.getWriteObjectSpec());
        }
        if (writeObjectRequest.hasCommonObjectRequestParams()) {
            b.setCommonObjectRequestParams(writeObjectRequest.getCommonObjectRequestParams());
        }
        if (writeObjectRequest.hasObjectChecksums()) {
            b.setObjectChecksums(writeObjectRequest.getObjectChecksums());
        }
        StartResumableWriteRequest req = opts.startResumableWriteRequest().apply(b).build();
        Function<String, BidiWriteObjectRequest> f = uploadId -> writeObjectRequest.toBuilder().clearWriteObjectSpec().setUploadId(uploadId).build();
        SettableApiFuture future = SettableApiFuture.create();
        try {
            BidiResumableWrite resumableWrite = (BidiResumableWrite)retrier.run(() -> {
                StartResumableWriteResponse resp = (StartResumableWriteResponse)x.call((Object)req);
                return new BidiResumableWrite(req, resp, f);
            }, Conversions.Decoder.identity());
            future.set((Object)resumableWrite);
        }
        catch (StorageException e) {
            future.setException((Throwable)((Object)e));
        }
        return future;
    }
}

