/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.SubscriptionName;
import com.google.pubsub.v1.TopicName;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;

public class PubsubMessageWrapper {
    private PubsubMessage message;
    private final TopicName topicName;
    private final SubscriptionName subscriptionName;
    private final String ackId;
    private final int deliveryAttempt;
    private static final String PUBLISH_START_EVENT = "publish start";
    private static final String PUBLISH_END_EVENT = "publish end";
    private static final String MODACK_START_EVENT = "modack start";
    private static final String MODACK_END_EVENT = "modack end";
    private static final String NACK_START_EVENT = "nack start";
    private static final String NACK_END_EVENT = "nack end";
    private static final String ACK_START_EVENT = "ack start";
    private static final String ACK_END_EVENT = "ack end";
    private static final String GOOGCLIENT_PREFIX = "googclient_";
    private static final String MESSAGE_RESULT_ATTR_KEY = "messaging.gcp_pubsub.result";
    private Span publisherSpan;
    private Span publishFlowControlSpan;
    private Span publishBatchingSpan;
    private Span subscriberSpan;
    private Span subscribeConcurrencyControlSpan;
    private Span subscribeSchedulerSpan;
    private Span subscribeProcessSpan;

    private PubsubMessageWrapper(Builder builder) {
        this.message = builder.message;
        this.topicName = builder.topicName;
        this.subscriptionName = builder.subscriptionName;
        this.ackId = builder.ackId;
        this.deliveryAttempt = builder.deliveryAttempt;
    }

    static Builder newBuilder(PubsubMessage message, TopicName topicName) {
        return new Builder(message, topicName);
    }

    static Builder newBuilder(PubsubMessage message, SubscriptionName subscriptionName, String ackId, int deliveryAttempt) {
        return new Builder(message, subscriptionName, ackId, deliveryAttempt);
    }

    PubsubMessage getPubsubMessage() {
        return this.message;
    }

    void setPubsubMessage(PubsubMessage message) {
        this.message = message;
    }

    String getTopicName() {
        if (this.topicName != null) {
            return this.topicName.getTopic();
        }
        return "";
    }

    String getTopicProject() {
        if (this.topicName != null) {
            return this.topicName.getProject();
        }
        return "";
    }

    String getSubscriptionName() {
        if (this.subscriptionName != null) {
            return this.subscriptionName.getSubscription();
        }
        return "";
    }

    String getSubscriptionProject() {
        if (this.subscriptionName != null) {
            return this.subscriptionName.getProject();
        }
        return "";
    }

    String getMessageId() {
        return this.message.getMessageId();
    }

    String getAckId() {
        return this.ackId;
    }

    int getDataSize() {
        return this.message.getData().size();
    }

    int getSerializedSize() {
        return this.message.getSerializedSize();
    }

    String getOrderingKey() {
        return this.message.getOrderingKey();
    }

    int getDeliveryAttempt() {
        return this.deliveryAttempt;
    }

    Span getPublisherSpan() {
        return this.publisherSpan;
    }

    void setPublisherSpan(Span span) {
        this.publisherSpan = span;
    }

    void setPublishFlowControlSpan(Span span) {
        this.publishFlowControlSpan = span;
    }

    void setPublishBatchingSpan(Span span) {
        this.publishBatchingSpan = span;
    }

    Span getSubscriberSpan() {
        return this.subscriberSpan;
    }

    void setSubscriberSpan(Span span) {
        this.subscriberSpan = span;
    }

    void setSubscribeConcurrencyControlSpan(Span span) {
        this.subscribeConcurrencyControlSpan = span;
    }

    void setSubscribeSchedulerSpan(Span span) {
        this.subscribeSchedulerSpan = span;
    }

    void setSubscribeProcessSpan(Span span) {
        this.subscribeProcessSpan = span;
    }

    void addPublishStartEvent() {
        if (this.publisherSpan != null) {
            this.publisherSpan.addEvent(PUBLISH_START_EVENT);
        }
    }

    void setPublisherMessageIdSpanAttribute(String messageId) {
        if (this.publisherSpan != null) {
            this.publisherSpan.setAttribute(SemanticAttributes.MESSAGING_MESSAGE_ID, (Object)messageId);
        }
    }

    void endPublisherSpan() {
        if (this.publisherSpan != null) {
            this.publisherSpan.addEvent(PUBLISH_END_EVENT);
            this.publisherSpan.end();
        }
    }

    void endPublishFlowControlSpan() {
        if (this.publishFlowControlSpan != null) {
            this.publishFlowControlSpan.end();
        }
    }

    void endPublishBatchingSpan() {
        if (this.publishBatchingSpan != null) {
            this.publishBatchingSpan.end();
        }
    }

    void setPublishFlowControlSpanException(Throwable t) {
        if (this.publishFlowControlSpan != null) {
            this.publishFlowControlSpan.setStatus(StatusCode.ERROR, "Exception thrown during publish flow control.");
            this.publishFlowControlSpan.recordException(t);
            this.endAllPublishSpans();
        }
    }

    void addModAckStartEvent() {
        if (this.subscriberSpan != null) {
            this.subscriberSpan.addEvent(MODACK_START_EVENT);
        }
    }

    void addModAckEndEvent() {
        if (this.subscriberSpan != null) {
            this.subscriberSpan.addEvent(MODACK_END_EVENT);
        }
    }

    void addNackStartEvent() {
        if (this.subscriberSpan != null) {
            this.subscriberSpan.addEvent(NACK_START_EVENT);
        }
    }

    void addNackEndEvent() {
        if (this.subscriberSpan != null) {
            this.subscriberSpan.addEvent(NACK_END_EVENT);
        }
    }

    void addAckStartEvent() {
        if (this.subscriberSpan != null) {
            this.subscriberSpan.addEvent(ACK_START_EVENT);
        }
    }

    void addAckEndEvent() {
        if (this.subscriberSpan != null) {
            this.subscriberSpan.addEvent(ACK_END_EVENT);
        }
    }

    void endSubscriberSpan() {
        if (this.subscriberSpan != null) {
            this.subscriberSpan.end();
        }
    }

    void endSubscribeConcurrencyControlSpan() {
        if (this.subscribeConcurrencyControlSpan != null) {
            this.subscribeConcurrencyControlSpan.end();
        }
    }

    void endSubscribeSchedulerSpan() {
        if (this.subscribeSchedulerSpan != null) {
            this.subscribeSchedulerSpan.end();
        }
    }

    void endSubscribeProcessSpan(String action) {
        if (this.subscribeProcessSpan != null) {
            this.subscribeProcessSpan.addEvent(action + " called");
            this.subscribeProcessSpan.end();
            this.subscriberSpan.setAttribute(MESSAGE_RESULT_ATTR_KEY, action);
        }
    }

    void setSubscriberSpanException(Throwable t, String exception) {
        if (this.subscriberSpan != null) {
            this.subscriberSpan.setStatus(StatusCode.ERROR, exception);
            this.subscriberSpan.recordException(t);
            this.endAllSubscribeSpans();
        }
    }

    void setSubscriberSpanExpirationResult() {
        if (this.subscriberSpan != null) {
            this.subscriberSpan.setAttribute(MESSAGE_RESULT_ATTR_KEY, "expired");
            this.endSubscriberSpan();
        }
    }

    void setSubscribeConcurrencyControlSpanException(Throwable t) {
        if (this.subscribeConcurrencyControlSpan != null) {
            this.subscribeConcurrencyControlSpan.setStatus(StatusCode.ERROR, "Exception thrown during subscribe concurrency control.");
            this.subscribeConcurrencyControlSpan.recordException(t);
            this.endAllSubscribeSpans();
        }
    }

    private void endAllPublishSpans() {
        this.endPublishFlowControlSpan();
        this.endPublishBatchingSpan();
        this.endPublisherSpan();
    }

    private void endAllSubscribeSpans() {
        this.endSubscribeConcurrencyControlSpan();
        this.endSubscribeSchedulerSpan();
        this.endSubscriberSpan();
    }

    void injectSpanContext() {
        TextMapSetter<PubsubMessageWrapper> injectMessageAttributes = new TextMapSetter<PubsubMessageWrapper>(){

            public void set(PubsubMessageWrapper carrier, String key, String value) {
                PubsubMessage newMessage = PubsubMessage.newBuilder((PubsubMessage)carrier.message).putAttributes(PubsubMessageWrapper.GOOGCLIENT_PREFIX + key, value).build();
                carrier.message = newMessage;
            }
        };
        W3CTraceContextPropagator.getInstance().inject(Context.current().with((ImplicitContextKeyed)this.publisherSpan), (Object)this, (TextMapSetter)injectMessageAttributes);
    }

    Context extractSpanContext(Attributes attributes) {
        TextMapGetter<PubsubMessageWrapper> extractMessageAttributes = new TextMapGetter<PubsubMessageWrapper>(){

            public String get(PubsubMessageWrapper carrier, String key) {
                return carrier.message.getAttributesOrDefault(PubsubMessageWrapper.GOOGCLIENT_PREFIX + key, "");
            }

            public Iterable<String> keys(PubsubMessageWrapper carrier) {
                return carrier.message.getAttributesMap().keySet();
            }
        };
        Context context = W3CTraceContextPropagator.getInstance().extract(Context.current(), (Object)this, (TextMapGetter)extractMessageAttributes);
        return context;
    }

    static final class Builder {
        private PubsubMessage message = null;
        private TopicName topicName = null;
        private SubscriptionName subscriptionName = null;
        private String ackId = null;
        private int deliveryAttempt = 0;

        public Builder(PubsubMessage message, TopicName topicName) {
            this.message = message;
            this.topicName = topicName;
        }

        public Builder(PubsubMessage message, SubscriptionName subscriptionName, String ackId, int deliveryAttempt) {
            this.message = message;
            this.subscriptionName = subscriptionName;
            this.ackId = ackId;
            this.deliveryAttempt = deliveryAttempt;
        }

        public PubsubMessageWrapper build() {
            return new PubsubMessageWrapper(this);
        }
    }
}

