/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.logging.v2.LogExclusion;
import com.google.protobuf.Timestamp;
import java.util.Objects;

public class Exclusion {
    static final Function<LogExclusion, Exclusion> FROM_PROTOBUF_FUNCTION = exclusionPb -> exclusionPb != null ? Exclusion.fromProtobuf(exclusionPb) : null;
    static final Function<Exclusion, LogExclusion> TO_PROTOBUF_FUNCTION = exclusion -> exclusion != null ? exclusion.toProtobuf() : null;
    private final String name;
    private final String description;
    private final String filter;
    private final boolean disabled;
    private final Timestamp createTime;
    private final Timestamp updateTime;

    Exclusion(Builder builder) {
        this.name = (String)Preconditions.checkNotNull((Object)builder.name);
        this.description = builder.description;
        this.filter = (String)Preconditions.checkNotNull((Object)builder.filter);
        this.disabled = builder.disabled;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("description", (Object)this.description).add("filter", (Object)this.filter).add("disabled", this.disabled).add("createTime", (Object)this.createTime).add("updateTime", (Object)this.updateTime).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Exclusion)) {
            return false;
        }
        Exclusion exclusion = (Exclusion)o;
        return this.disabled == exclusion.disabled && Objects.equals(this.name, exclusion.name) && Objects.equals(this.description, exclusion.description) && Objects.equals(this.filter, exclusion.filter) && Objects.equals(this.createTime, exclusion.createTime) && Objects.equals(this.updateTime, exclusion.updateTime);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.filter, this.disabled, this.createTime, this.updateTime);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public Timestamp getUpdateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder(String name, String filter) {
        return new Builder(name, filter);
    }

    public static Exclusion of(String name, String filter) {
        return new Builder(name, filter).build();
    }

    LogExclusion toProtobuf() {
        LogExclusion.Builder builder = LogExclusion.newBuilder().setName(this.name).setFilter(this.filter).setDisabled(this.disabled);
        if (this.description != null) {
            builder.setDescription(this.description);
        }
        if (this.createTime != null) {
            builder.setCreateTime(this.createTime);
        }
        if (this.updateTime != null) {
            builder.setUpdateTime(this.updateTime);
        }
        return builder.build();
    }

    static Exclusion fromProtobuf(LogExclusion exclusionPb) {
        Builder builder = Exclusion.newBuilder(exclusionPb.getName(), exclusionPb.getFilter());
        builder.setDisabled(exclusionPb.getDisabled());
        if (!exclusionPb.getDescription().isEmpty()) {
            builder.setDescription(exclusionPb.getDescription());
        }
        if (exclusionPb.hasCreateTime()) {
            builder.setCreateTime(exclusionPb.getCreateTime());
        }
        if (exclusionPb.hasUpdateTime()) {
            builder.setUpdateTime(exclusionPb.getUpdateTime());
        }
        return builder.build();
    }

    public static class Builder {
        private String name;
        private String description;
        private String filter;
        private boolean disabled;
        private Timestamp createTime;
        private Timestamp updateTime;

        private Builder(String name, String filter) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.filter = (String)Preconditions.checkNotNull((Object)filter);
        }

        private Builder(Exclusion exclusion) {
            this.name = exclusion.name;
            this.description = exclusion.description;
            this.filter = exclusion.filter;
            this.disabled = exclusion.disabled;
            this.createTime = exclusion.createTime;
            this.updateTime = exclusion.updateTime;
        }

        @CanIgnoreReturnValue
        public Builder setName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFilter(String filter) {
            this.filter = (String)Preconditions.checkNotNull((Object)filter);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDisabled(boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCreateTime(Timestamp createTime) {
            this.createTime = createTime;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUpdateTime(Timestamp updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public Exclusion build() {
            return new Exclusion(this);
        }
    }
}

