/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CreateSessionRequest;
import com.google.cloud.dataproc.v1.DeleteSessionRequest;
import com.google.cloud.dataproc.v1.GetSessionRequest;
import com.google.cloud.dataproc.v1.ListSessionsRequest;
import com.google.cloud.dataproc.v1.ListSessionsResponse;
import com.google.cloud.dataproc.v1.Session;
import com.google.cloud.dataproc.v1.SessionControllerClient;
import com.google.cloud.dataproc.v1.SessionOperationMetadata;
import com.google.cloud.dataproc.v1.TerminateSessionRequest;
import com.google.cloud.dataproc.v1.stub.GrpcSessionControllerCallableFactory;
import com.google.cloud.dataproc.v1.stub.SessionControllerStub;
import com.google.cloud.dataproc.v1.stub.SessionControllerStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSessionControllerStub
extends SessionControllerStub {
    private static final MethodDescriptor<CreateSessionRequest, Operation> createSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.SessionController/CreateSession").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSessionRequest, Session> getSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.SessionController/GetSession").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Session.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSessionsRequest, ListSessionsResponse> listSessionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.SessionController/ListSessions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSessionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSessionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<TerminateSessionRequest, Operation> terminateSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.SessionController/TerminateSession").setRequestMarshaller(ProtoUtils.marshaller((Message)TerminateSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSessionRequest, Operation> deleteSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.SessionController/DeleteSession").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateSessionRequest, Operation> createSessionCallable;
    private final OperationCallable<CreateSessionRequest, Session, SessionOperationMetadata> createSessionOperationCallable;
    private final UnaryCallable<GetSessionRequest, Session> getSessionCallable;
    private final UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable;
    private final UnaryCallable<ListSessionsRequest, SessionControllerClient.ListSessionsPagedResponse> listSessionsPagedCallable;
    private final UnaryCallable<TerminateSessionRequest, Operation> terminateSessionCallable;
    private final OperationCallable<TerminateSessionRequest, Session, SessionOperationMetadata> terminateSessionOperationCallable;
    private final UnaryCallable<DeleteSessionRequest, Operation> deleteSessionCallable;
    private final OperationCallable<DeleteSessionRequest, Session, SessionOperationMetadata> deleteSessionOperationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSessionControllerStub create(SessionControllerStubSettings settings) throws IOException {
        return new GrpcSessionControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSessionControllerStub create(ClientContext clientContext) throws IOException {
        return new GrpcSessionControllerStub(SessionControllerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSessionControllerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSessionControllerStub(SessionControllerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSessionControllerStub(SessionControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSessionControllerCallableFactory());
    }

    protected GrpcSessionControllerStub(SessionControllerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listSessionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSessionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings terminateSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(terminateSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createSessionCallable = callableFactory.createUnaryCallable(createSessionTransportSettings, settings.createSessionSettings(), clientContext);
        this.createSessionOperationCallable = callableFactory.createOperationCallable(createSessionTransportSettings, settings.createSessionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getSessionCallable = callableFactory.createUnaryCallable(getSessionTransportSettings, settings.getSessionSettings(), clientContext);
        this.listSessionsCallable = callableFactory.createUnaryCallable(listSessionsTransportSettings, settings.listSessionsSettings(), clientContext);
        this.listSessionsPagedCallable = callableFactory.createPagedCallable(listSessionsTransportSettings, settings.listSessionsSettings(), clientContext);
        this.terminateSessionCallable = callableFactory.createUnaryCallable(terminateSessionTransportSettings, settings.terminateSessionSettings(), clientContext);
        this.terminateSessionOperationCallable = callableFactory.createOperationCallable(terminateSessionTransportSettings, settings.terminateSessionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteSessionCallable = callableFactory.createUnaryCallable(deleteSessionTransportSettings, settings.deleteSessionSettings(), clientContext);
        this.deleteSessionOperationCallable = callableFactory.createOperationCallable(deleteSessionTransportSettings, settings.deleteSessionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateSessionRequest, Operation> createSessionCallable() {
        return this.createSessionCallable;
    }

    @Override
    public OperationCallable<CreateSessionRequest, Session, SessionOperationMetadata> createSessionOperationCallable() {
        return this.createSessionOperationCallable;
    }

    @Override
    public UnaryCallable<GetSessionRequest, Session> getSessionCallable() {
        return this.getSessionCallable;
    }

    @Override
    public UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable() {
        return this.listSessionsCallable;
    }

    @Override
    public UnaryCallable<ListSessionsRequest, SessionControllerClient.ListSessionsPagedResponse> listSessionsPagedCallable() {
        return this.listSessionsPagedCallable;
    }

    @Override
    public UnaryCallable<TerminateSessionRequest, Operation> terminateSessionCallable() {
        return this.terminateSessionCallable;
    }

    @Override
    public OperationCallable<TerminateSessionRequest, Session, SessionOperationMetadata> terminateSessionOperationCallable() {
        return this.terminateSessionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteSessionRequest, Operation> deleteSessionCallable() {
        return this.deleteSessionCallable;
    }

    @Override
    public OperationCallable<DeleteSessionRequest, Session, SessionOperationMetadata> deleteSessionOperationCallable() {
        return this.deleteSessionOperationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

